/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.image;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;

public class ImageChangeUtil {
    private ImageChangeUtil() {
    }

    public static BufferedImage rotateRight(BufferedImage image) {
        return ImageChangeUtil.rotateLeftOrRight(image, 90);
    }

    public static BufferedImage rotateLeft(BufferedImage image) {
        return ImageChangeUtil.rotateLeftOrRight(image, -90);
    }

    public static BufferedImage flip(BufferedImage image) {
        double theta = Math.toRadians(180.0);
        int width = image.getWidth();
        int height = image.getHeight();
        double x = (double)width / 2.0;
        double y = (double)height / 2.0;
        AffineTransform at = new AffineTransform();
        at.setToTranslation(x, y);
        at.rotate(theta);
        at.translate(-x, -y);
        BufferedImage rtnMe = new BufferedImage(width, height, 1);
        Graphics2D g2x = rtnMe.createGraphics();
        g2x.drawImage(image, at, null);
        return rtnMe;
    }

    public static BufferedImage scale(BufferedImage image, float scale) {
        try {
            AffineTransform at = AffineTransform.getScaleInstance(scale, scale);
            AffineTransformOp op = new AffineTransformOp(at, null);
            return op.filter(image, null);
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
            ex.printStackTrace();
            return image;
        }
    }

    public static BufferedImage fitAspectDown(BufferedImage image, int scaleWidth, int scaleHeight) {
        float theta;
        if (image == null) {
            return null;
        }
        int imgWidth = image.getWidth();
        int imgHeight = image.getHeight();
        if (scaleWidth > 0 && scaleHeight > 0 && (theta = ImageChangeUtil.calcThetaDown(imgWidth, imgHeight, scaleWidth, scaleHeight)) > 0.0f) {
            image = ImageChangeUtil.scale(image, theta);
        }
        return image;
    }

    public static BufferedImage fitAspectFill(BufferedImage image, int scaleWidth, int scaleHeight) {
        if (image == null) {
            return null;
        }
        int imgWidth = image.getWidth();
        int imgHeight = image.getHeight();
        if (scaleWidth > 0 && scaleHeight > 0) {
            float theta = ImageChangeUtil.calcTheta(imgWidth, imgHeight, scaleWidth, scaleHeight);
            image = ImageChangeUtil.scale(image, theta);
        }
        return image;
    }

    public static BufferedImage resizeImageDown(BufferedImage image, double toWidth, double toHeight) throws Exception {
        if (toWidth < 10.0) {
            return null;
        }
        if (toHeight < 10.0) {
            return null;
        }
        float theta = ImageChangeUtil.calcThetaDown(image.getWidth(), image.getHeight(), toWidth, toHeight);
        if (theta > 0.0f) {
            return ImageChangeUtil.scale(image, theta);
        }
        return null;
    }

    public static float calcTheta(int fromWidth, int fromHeight, double toWidth, double toHeight) {
        if ((int)toWidth == fromWidth && (int)toHeight == fromHeight) {
            return 1.0f;
        }
        if (toWidth < (double)fromWidth || toHeight < (double)fromHeight) {
            return ImageChangeUtil.calcThetaDown(fromWidth, fromHeight, toWidth, toHeight);
        }
        if (toWidth > (double)fromWidth || toHeight > (double)fromHeight) {
            return ImageChangeUtil.calcThetaUp(fromWidth, fromHeight, toWidth, toHeight);
        }
        return 1.0f;
    }

    public static float calcThetaWidth(int fromWidth, double toWidth) {
        float theta = 0.0f;
        if ((double)fromWidth != toWidth) {
            theta = (float)toWidth / (float)fromWidth;
        }
        return theta;
    }

    public static float calcThetaDown(int fromWidth, int fromHeight, double toWidth, double toHeight) {
        float wideBy = 0.0f;
        if ((double)fromWidth > toWidth) {
            wideBy = (float)toWidth / (float)fromWidth;
        }
        float highBy = 0.0f;
        if ((double)fromHeight > toHeight) {
            highBy = (float)toHeight / (float)fromHeight;
        }
        float theta = 0.0f;
        if (wideBy == highBy) {
            theta = highBy;
        } else if (wideBy > 0.0f && highBy > 0.0f) {
            theta = wideBy < highBy ? wideBy : highBy;
        } else if (wideBy > 0.0f) {
            theta = wideBy;
        } else if (highBy > 0.0f) {
            theta = highBy;
        }
        return theta;
    }

    public static float calcThetaUp(int fromWidth, int fromHeight, double toWidth, double toHeight) {
        float wideBy = 0.0f;
        if ((double)fromWidth < toWidth) {
            wideBy = (float)toWidth / (float)fromWidth;
        }
        float highBy = 0.0f;
        if ((double)fromHeight < toHeight) {
            highBy = (float)toHeight / (float)fromHeight;
        }
        float theta = 0.0f;
        theta = wideBy == highBy ? highBy : (wideBy < highBy ? wideBy : highBy);
        return theta;
    }

    private static BufferedImage rotateLeftOrRight(BufferedImage image, int degrees) {
        switch (degrees) {
            case -90: 
            case 90: {
                break;
            }
            default: {
                return image;
            }
        }
        double theta = Math.toRadians(degrees);
        int width = image.getWidth();
        int height = image.getHeight();
        double x = (double)width / 2.0;
        double y = (double)height / 2.0;
        double diff = (double)(width - height) / 2.0;
        AffineTransform at = new AffineTransform();
        at.setToTranslation(x, y);
        at.rotate(theta);
        double xDiff = 0.0;
        double yDiff = 0.0;
        if (degrees == 90) {
            xDiff = -x + diff;
            yDiff = -y + diff;
            at.translate(xDiff, yDiff);
        } else if (degrees == -90) {
            xDiff = -x - diff;
            yDiff = -y - diff;
            at.translate(xDiff, yDiff);
        }
        BufferedImage rtnMe = new BufferedImage(height, width, 1);
        Graphics2D g2x = rtnMe.createGraphics();
        g2x.drawImage(image, at, null);
        return rtnMe;
    }
}

