/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.image;

import java.io.File;
import org.apache.sanselan.ImageFormat;
import org.apache.sanselan.Sanselan;
import org.gerhardb.lib.image.IOImage;
import org.gerhardb.lib.image.IOImageSanselan;
import org.gerhardb.lib.image.ImageFactoryPlugin;

class ImageFactorySanselan
implements ImageFactoryPlugin {
    static String[] clsEndings = new String[]{"apng", "png", "gif", "tiff", "tif", "bmp", "psd", "pnm", "pgm", "pbm", "ppm"};

    ImageFactorySanselan() {
    }

    public String[] getEndingsLowercase() {
        return clsEndings;
    }

    public boolean canHandle(File aFile) {
        boolean goodEnding = false;
        String lowerCaseName = aFile.getName().toLowerCase();
        for (int i = 0; i < clsEndings.length; ++i) {
            if (!lowerCaseName.endsWith(clsEndings[i])) continue;
            goodEnding = true;
            break;
        }
        if (goodEnding) {
            try {
                ImageFormat format = Sanselan.guessFormat(aFile);
                if (!format.equals(ImageFormat.IMAGE_FORMAT_UNKNOWN)) {
                    return true;
                }
            }
            catch (Exception ex) {
                System.out.println("ImageFactorySanselan.canHandle(): " + ex.getMessage());
            }
        }
        return false;
    }

    public IOImage makeImage(File aFile) throws Exception {
        return new IOImageSanselan(aFile);
    }

    public static void main(String[] args) {
        ImageFormat[] formats = ImageFormat.getAllFormats();
        for (int i = 0; i < formats.length; ++i) {
            System.out.println(formats[i].extension);
        }
        System.out.println("------------------------------------------------------");
        ImageFactorySanselan factory = new ImageFactorySanselan();
        String[] endings = factory.getEndingsLowercase();
        for (int i = 0; i < endings.length; ++i) {
            System.out.println(endings[i]);
        }
    }

    public String toString() {
        return "Sanselan";
    }
}

