/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.io;

import com.saic.isd.swing.filechooser.SimpleFileFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.gerhardb.lib.io.DirListModel;
import org.gerhardb.lib.io.DragDropList;
import org.gerhardb.lib.io.FileUtil;
import org.gerhardb.lib.io.IOUtils;
import org.gerhardb.lib.swing.JPanelRows;
import org.gerhardb.lib.util.startup.AppStarter;

public class DirListController {
    private Preferences myPrefs;
    private static final String LAST_SAVE = "-LastSave";
    private static final String AUTO_RESTORE = "-AutoRestore";
    private String myPreferencesLabel;
    private String myPopupName;
    private JLabel myStatusBar = new JLabel(" ");
    DirListModel myDirListModel = new DirListModel(this.myStatusBar);
    DragDropList myDirList = new DragDropList(this.myDirListModel, false);
    JScrollPane myDirScroll = new JScrollPane(this.myDirList);
    JPanel myDirPanel = new JPanel(false);
    String myLastSave;
    Clearable myClearable;
    boolean iJustShowKids = false;
    private static final String SAVE_DIRECTORY = "saveDirectory";

    public DirListController(String popupName, String preferencesLabel, boolean justShowKids, String appName) {
        this(null, popupName, preferencesLabel, justShowKids, appName);
    }

    public DirListController(Clearable clear, String popupName, String preferencesLabel, boolean justShowKids, String appName) {
        this.myClearable = clear;
        this.myPopupName = popupName;
        this.myPreferencesLabel = preferencesLabel;
        this.iJustShowKids = justShowKids;
        this.myPrefs = Preferences.userRoot().node("/" + appName + "/org/gerhardb/lib/io/DirListController");
        this.myDirList.getSelectionModel().setSelectionMode(2);
        this.layout();
    }

    public void add(File[] files) {
        this.myDirPanel.setCursor(Cursor.getPredefinedCursor(3));
        for (int i = 0; i < files.length; ++i) {
            this.myDirListModel.addDirectory(files[i]);
        }
        this.myDirPanel.setCursor(Cursor.getDefaultCursor());
    }

    public void add(File file) {
        this.myDirListModel.addDirectory(file);
    }

    public DirListModel getModel() {
        return this.myDirListModel;
    }

    public File[] getDirArray() {
        int dirCount = this.myDirListModel.getSize();
        File[] dirArray = new File[dirCount];
        for (int i = 0; i < dirCount; ++i) {
            dirArray[i] = (File)this.myDirListModel.getElementAt(i);
        }
        return dirArray;
    }

    public JPanel getPanel() {
        return this.myDirPanel;
    }

    void saveDirectoryList() {
        this.myStatusBar.setText(" ");
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(this.myPopupName + ": " + AppStarter.getString("DirListController.3"));
        chooser.setFileFilter(new SimpleFileFilter("txt", "Text file"));
        chooser.setFileSelectionMode(0);
        chooser.setCurrentDirectory(new File(this.getSaveDirectory()));
        if (this.myLastSave != null) {
            File lastFile = new File(this.myLastSave);
            if (lastFile.exists()) {
                chooser.setCurrentDirectory(lastFile);
                if (lastFile.isFile()) {
                    chooser.setSelectedFile(lastFile);
                } else {
                    chooser.setSelectedFile(new File("*.txt"));
                }
            }
        } else {
            chooser.setSelectedFile(new File("*.txt"));
        }
        int returnVal = chooser.showSaveDialog(this.myDirPanel);
        if (returnVal == 0) {
            try {
                int answer;
                File saveAsFile = chooser.getSelectedFile();
                if (saveAsFile.exists() && (answer = JOptionPane.showConfirmDialog(this.myDirPanel, AppStarter.getString("DirListController.8"), AppStarter.getString("DirListController.9"), 0)) == 1) {
                    return;
                }
                String newLine = System.getProperty("line.separator");
                try {
                    FileWriter writer = new FileWriter(saveAsFile);
                    int size = this.myDirListModel.getSize();
                    for (int i = 0; i < size; ++i) {
                        Object entry = this.myDirListModel.getElementAt(i);
                        writer.write(entry + newLine);
                    }
                    writer.flush();
                    writer.close();
                    this.rememberSave(saveAsFile);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog(this.myDirPanel, AppStarter.getString("DirListController.11") + ex.getMessage(), AppStarter.getString("DirListController.12"), 0);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    void restoreDirectoryList() {
        this.myStatusBar.setText(" ");
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(this.myPopupName + ": " + AppStarter.getString("DirListController.13"));
        chooser.setFileFilter(new SimpleFileFilter("txt", AppStarter.getString("DirListController.15")));
        chooser.setFileSelectionMode(0);
        chooser.setCurrentDirectory(new File(this.getSaveDirectory()));
        if (this.myLastSave != null) {
            File lastFile = new File(this.myLastSave);
            if (lastFile.exists()) {
                chooser.setCurrentDirectory(lastFile);
                if (lastFile.isFile()) {
                    chooser.setSelectedFile(lastFile);
                } else {
                    chooser.setSelectedFile(new File("*.txt"));
                }
            }
        } else {
            chooser.setSelectedFile(new File("*.txt"));
        }
        int returnVal = chooser.showOpenDialog(this.myDirPanel);
        if (returnVal == 0) {
            File saveAsFile = chooser.getSelectedFile();
            this.restoreDirectoryList(saveAsFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void restoreDirectoryList(File saveAsFile) {
        this.myStatusBar.setText(" ");
        if (saveAsFile == null || !saveAsFile.exists() || !saveAsFile.isFile()) {
            return;
        }
        BufferedReader buffRead = null;
        try {
            buffRead = new BufferedReader(new FileReader(saveAsFile));
            String appendMe = buffRead.readLine();
            while (appendMe != null) {
                this.add(new File(appendMe));
                appendMe = buffRead.readLine();
            }
            this.rememberSave(saveAsFile);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this.myDirPanel, AppStarter.getString("DirListController.1") + "\n" + ex.getMessage(), AppStarter.getString("DirListController.2"), 0);
            this.rememberSave(saveAsFile);
        }
        finally {
            try {
                buffRead.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    void rememberSave(File file) {
        this.myStatusBar.setText(" ");
        this.myLastSave = file.getAbsolutePath();
        this.myPrefs.put(this.myPreferencesLabel + LAST_SAVE, this.myLastSave);
        try {
            this.myPrefs.flush();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String getSaveDirectory() {
        String rtnMe = FileUtil.checkDirectory(this.myPrefs.get(SAVE_DIRECTORY, System.getProperty("user.home")));
        if (rtnMe == null) {
            rtnMe = System.getProperty("user.home");
        }
        return rtnMe;
    }

    public void setSaveDirectory(String dir) {
        String validated = FileUtil.safeValidateDirectory(dir);
        if (validated != null) {
            this.myPrefs.put(SAVE_DIRECTORY, validated);
        } else {
            this.myPrefs.remove(SAVE_DIRECTORY);
        }
    }

    private void layout() {
        this.myDirList.setMinimumSize(new Dimension(200, 100));
        JButton btnAdd = new JButton(AppStarter.getString("DirListController.21"));
        JButton btnSub = new JButton(AppStarter.getString("DirListController.22"));
        JButton btnRemove = new JButton(AppStarter.getString("DirListController.23"));
        JButton btnClear = new JButton(AppStarter.getString("DirListController.24"));
        JButton btnSave = new JButton(AppStarter.getString("save"));
        JButton btnRestore = new JButton(AppStarter.getString("DirListController.26"));
        final JCheckBox boxAutoRestore = new JCheckBox(AppStarter.getString("DirListController.27"));
        boxAutoRestore.setToolTipText(AppStarter.getString("DirListController.28"));
        boolean autoRestore = this.myPrefs.getBoolean(this.myPreferencesLabel + AUTO_RESTORE, false);
        boxAutoRestore.setSelected(autoRestore);
        boxAutoRestore.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DirListController.this.myPrefs.putBoolean(DirListController.this.myPreferencesLabel + DirListController.AUTO_RESTORE, boxAutoRestore.isSelected());
                try {
                    DirListController.this.myPrefs.flush();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        if (autoRestore) {
            this.myLastSave = this.myPrefs.get(this.myPreferencesLabel + LAST_SAVE, null);
            if (this.myLastSave != null) {
                File restoreMe = new File(this.myLastSave);
                this.restoreDirectoryList(restoreMe);
            }
        }
        JPanelRows btnPanel = new JPanelRows(1);
        JPanel aRow = btnPanel.topRow();
        aRow.add(btnAdd);
        aRow.add(btnSub);
        aRow.add(btnRemove);
        aRow.add(btnClear);
        aRow = btnPanel.nextRow();
        aRow.add(btnSave);
        aRow.add(btnRestore);
        aRow.add(boxAutoRestore);
        aRow = btnPanel.nextRow(0);
        aRow.add(this.myStatusBar);
        btnAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DirListController.this.addBtnActionPerformed();
            }
        });
        btnSub.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DirListController.this.addRecursiveActionPerformed();
            }
        });
        btnRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DirListController.this.removeBtnActionPerformed();
            }
        });
        btnClear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DirListController.this.clearBtnActionPerformed();
            }
        });
        btnSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DirListController.this.saveBtnActionPerformed();
            }
        });
        btnRestore.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DirListController.this.restoreBtnActionPerformed();
            }
        });
        this.myDirPanel.setLayout(new BorderLayout());
        this.myDirPanel.add((Component)this.myDirScroll, "Center");
        this.myDirPanel.add((Component)btnPanel, "South");
    }

    private void addBtnActionPerformed() {
        this.clear();
        JFileChooser chooser = new JFileChooser(this.getAddDirectory());
        chooser.setDialogTitle(this.myPopupName + ": " + AppStarter.getString("DirListController.29"));
        chooser.setFileSelectionMode(1);
        int returnVal = chooser.showOpenDialog(this.myDirPanel);
        if (returnVal == 0) {
            File picked = chooser.getSelectedFile();
            this.setAddDirectoryParent(picked);
            this.myDirListModel.addDirectory(picked);
        }
    }

    private void addRecursiveActionPerformed() {
        this.clear();
        final JFileChooser chooser = new JFileChooser(this.getAddDirectory());
        chooser.setDialogTitle(this.myPopupName + ": " + AppStarter.getString("DirListController.30"));
        chooser.setFileSelectionMode(1);
        int returnVal = chooser.showOpenDialog(this.myDirPanel);
        if (returnVal == 0) {
            this.myDirPanel.setCursor(Cursor.getPredefinedCursor(3));
            Runnable runMe = new Runnable(){

                public void run() {
                    File picked = chooser.getSelectedFile();
                    DirListController.this.setAddDirectoryParent(picked);
                    if (DirListController.this.iJustShowKids) {
                        DirListController.this.myDirListModel.justAddKids(picked);
                        DirListController.this.myStatusBar.setText("Done");
                    } else {
                        DirListController.this.myDirListModel.recurseAdd(picked);
                        DirListController.this.myDirListModel.addDirectory(picked);
                        DirListController.this.myStatusBar.setText("Done");
                    }
                    DirListController.this.myDirPanel.setCursor(Cursor.getPredefinedCursor(0));
                }
            };
            Thread t = new Thread(runMe);
            t.start();
        }
    }

    private void removeBtnActionPerformed() {
        this.clear();
        this.myDirList.removeSelected();
    }

    private void clearBtnActionPerformed() {
        this.clear();
        this.myDirListModel.removeAllElements();
    }

    private void saveBtnActionPerformed() {
        this.saveDirectoryList();
    }

    private void restoreBtnActionPerformed() {
        this.restoreDirectoryList();
    }

    String getAddDirectory() {
        String addDir = this.myPrefs.get(this.myPreferencesLabel, System.getProperty("user.home"));
        return IOUtils.validDirectory(addDir);
    }

    void setAddDirectoryParent(File dir) {
        if (dir.getParentFile() != null) {
            dir = dir.getParentFile();
        }
        if (!dir.isFile()) {
            this.myPrefs.put(this.myPreferencesLabel, dir.toString());
        }
    }

    private void clear() {
        if (this.myClearable != null) {
            this.myClearable.clear();
        }
    }

    public static interface Clearable {
        public void clear();
    }
}

