/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.io;

import java.io.File;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;

public class DirListModel
extends DefaultListModel {
    private JLabel myStatusBar;

    public DirListModel(JLabel status) {
        if (status != null) {
            this.myStatusBar = status;
        }
    }

    public File[] getDirArray() {
        int dirCount = super.getSize();
        File[] dirArray = new File[dirCount];
        for (int i = 0; i < dirCount; ++i) {
            dirArray[i] = (File)super.getElementAt(i);
        }
        return dirArray;
    }

    public void addDirectory(File file) {
        if (file.isDirectory()) {
            super.addElement(file);
            this.myStatusBar.setText("Added directory: " + file);
        }
    }

    public void recurseAdd(File parent) {
        File[] kids = parent.listFiles();
        if (kids != null) {
            for (int i = 0; i < kids.length; ++i) {
                if (!kids[i].isDirectory()) continue;
                this.recurseAdd(kids[i]);
                super.addElement(kids[i]);
                this.myStatusBar.setText("Added directory: " + kids[i]);
            }
        }
    }

    public void justAddKids(File parent) {
        File[] kids = parent.listFiles();
        if (kids != null) {
            for (int i = 0; i < kids.length; ++i) {
                if (!kids[i].isDirectory()) continue;
                super.addElement(kids[i]);
                this.myStatusBar.setText("Added directory: " + kids[i]);
            }
        }
    }

    public void add(int index, Object obj) {
        if (obj != null && obj instanceof File && ((File)obj).isDirectory()) {
            super.add(index, obj);
            this.myStatusBar.setText("Added directory: " + obj);
        }
    }

    public void addElement(Object obj) {
        if (obj != null && obj instanceof File && ((File)obj).isDirectory()) {
            super.addElement(obj);
            this.myStatusBar.setText("Added directory: " + obj);
        }
    }
}

