/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.io;

import java.io.File;
import java.io.FileFilter;

public class FilenameFileFilter
implements FileFilter {
    private String[] myEndings = new String[0];

    public FilenameFileFilter() {
    }

    public FilenameFileFilter(String[] endings) {
        this.myEndings = endings != null ? endings : new String[0];
    }

    public void setEndings(String[] endings) {
        this.myEndings = endings != null ? endings : new String[0];
    }

    public String[] getEndings() {
        return this.myEndings;
    }

    public boolean accept(File file) {
        if (!file.isDirectory()) {
            String name = file.getName();
            name = name.toLowerCase();
            for (int i = 0; i < this.myEndings.length; ++i) {
                if (!name.endsWith(this.myEndings[i])) continue;
                return true;
            }
        }
        return false;
    }

    private String endingList() {
        StringBuffer rtnMe = new StringBuffer(200);
        rtnMe.append(this.myEndings[0]);
        for (int i = 1; i < this.myEndings.length; ++i) {
            rtnMe.append(", ");
            rtnMe.append(this.myEndings[i]);
        }
        return rtnMe.toString();
    }

    public String toString() {
        return "Keeping only files ending with: " + this.endingList();
    }
}

