/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.playlist;

import javax.swing.JSlider;
import org.gerhardb.lib.playlist.Scroller;
import org.gerhardb.lib.playlist.ScrollerChangeEvent;
import org.gerhardb.lib.playlist.ScrollerListener;

public class ScrollerSlider
extends JSlider
implements ScrollerListener {
    Scroller myScroller;

    public ScrollerSlider(int newOrientation, Scroller scroller) {
        super(newOrientation, 0, 100, 0);
        this.myScroller = scroller;
        super.setModel(this.myScroller);
        this.setSlider();
        this.myScroller.addScrollerListener(this);
    }

    public void scrollerChanged(ScrollerChangeEvent ce) {
        if (!this.myScroller.getValueIsAdjusting()) {
            this.setSlider();
        }
    }

    private void setSlider() {
        super.setValue(this.myScroller.getValue());
        int count = this.getModel().getMaximum();
        if (count < 0) {
            return;
        }
        super.setMinimum(0);
        super.setMaximum(this.myScroller.getMaximum());
        int minorTick = 1;
        int majorTick = 1;
        if (count > 1 && count <= 10) {
            minorTick = 1;
            majorTick = 1;
        } else if (count > 10 && count <= 100) {
            minorTick = 1;
            majorTick = 5;
        } else if (count > 100 && count <= 300) {
            minorTick = 5;
            majorTick = 10;
        } else if (count > 300 && count <= 1000) {
            minorTick = 10;
            majorTick = 50;
        } else if (count > 1000) {
            minorTick = count / 100;
            majorTick = count / 20;
        }
        super.setMinorTickSpacing(minorTick);
        super.setMajorTickSpacing(majorTick);
        if (minorTick == 1 || majorTick == 1) {
            super.setSnapToTicks(true);
        } else {
            super.setSnapToTicks(false);
        }
        super.setLabelTable(super.createStandardLabels(majorTick));
        super.setPaintTicks(true);
        super.setPaintLabels(true);
        super.setEnabled(true);
    }
}

