/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.print;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.print.Doc;
import javax.print.DocFlavor;
import javax.print.SimpleDoc;
import org.gerhardb.lib.image.ImageChangeUtil;
import org.gerhardb.lib.print.MediaFormat;
import org.gerhardb.lib.print.MediaPageable;
import org.gerhardb.lib.print.PBO;
import org.gerhardb.lib.print.PrintUtils;
import org.gerhardb.lib.util.startup.AppStarter;

public abstract class PrintableBase
implements MediaPageable,
Pageable,
Printable {
    public static final String PAGE_INDEX = "<#>";
    public static final String PAGE_COUNT = "<##>";
    public static final String DEFAULT_FOOTER = "<#> " + AppStarter.getString("of") + " " + "<##>";
    private static final float QUALITY = 1.0f;
    private static final int DEFAULT_DPI = 72;
    private static final int DEFAULT_WIDTH_DPI = 612;
    private static final int DEFAULT_HEIGHT_DPI = 792;
    private static final int DEFAULT_MARGIN_SPACE_DPI = 6;
    private static final float DEFAULT_STROKE = 1.0f;
    static final float[] dash1 = new float[]{10.0f};
    protected PBO myPBO;
    protected double centerX;
    protected double centerY;
    protected double myLeftMargin;
    protected double myRightMargin;
    protected double myTopMargin;
    protected double myBottomMargin;
    protected double myTopPictureMargin;
    protected double myBottomPictureMargin;
    int myMarginSpace = 6;
    protected int myPriorPageIndex = -1;
    protected int myNumberOfPages = -1;
    int maxPictureWidth;
    int maxPictureHeight;
    protected BasicStroke myStroke;
    protected BasicStroke myDashed;
    protected float fontTheta;
    protected FontRenderContext myFontRenderContext;
    protected Graphics2D myBuffGraphics;
    private BufferedImage myBuffImage;
    private MediaFormat myPriorMediaFormat;
    private MediaFormat myMediaFormat = new MediaFormat();
    private PageFormat myPageablePageFormat;

    public void imprint(PrintableBase that) {
        that.myNumberOfPages = this.myNumberOfPages;
        that.myMediaFormat = this.myMediaFormat;
        that.myPageablePageFormat = this.myPageablePageFormat;
    }

    public PrintableBase(PBO pbo) {
        this.init(pbo);
    }

    public PrintableBase(final String header) {
        PBO pbo = new PBO(){

            public String getHeader(int pageIndex) {
                return PrintableBase.this.convert(header, pageIndex);
            }

            public String getHeaderLeft(int pageIndex) {
                return "";
            }

            public String getHeaderRight(int pageIndex) {
                return "";
            }

            public String getFooter(int pageIndex) {
                return PrintableBase.this.convert(DEFAULT_FOOTER, pageIndex);
            }

            public String getFooterLeft(int pageIndex) {
                return "Printed by JIBS";
            }

            public String getFooterRight(int pageIndex) {
                return "www.jibs.us";
            }

            public int getHeaderFontSize() {
                return 10;
            }

            public int getFooterFontSize() {
                return 10;
            }

            public String getHeaderFontFamily() {
                return null;
            }

            public String getFooterFontFamily() {
                return null;
            }

            public boolean showLines() {
                return true;
            }

            public Color getTextColor() {
                return Color.BLACK;
            }

            public Color getBackgroundColor() {
                return Color.WHITE;
            }
        };
        this.init(pbo);
    }

    private void init(PBO pbo) {
        this.myPBO = pbo;
    }

    public void flushBuffer() {
        this.myBuffImage = null;
    }

    public int getNumberOfPages() {
        return this.myNumberOfPages;
    }

    public Printable getPrintable(int pageIndex) {
        return this;
    }

    public PageFormat getPageFormat(int pageIndex) {
        if (this.myPageablePageFormat == null) {
            this.myPageablePageFormat = this.myMediaFormat.getPageFormat();
        }
        return this.myPageablePageFormat;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (!(graphics instanceof Graphics2D)) {
            throw new PrinterException("Graphics2D required");
        }
        MediaFormat mf = new MediaFormat(pageFormat);
        if (this.doPrinting((Graphics2D)graphics, mf, pageIndex, true)) {
            return 0;
        }
        return 1;
    }

    public Doc getDoc(MediaFormat mediaFormat, int pageIndex) throws IOException {
        mediaFormat = mediaFormat.convertToPrintable();
        BufferedImage buff = null;
        int dpiWidth = (int)mediaFormat.getDpiPageWidth();
        int dpiHeight = (int)mediaFormat.getDpiPageHeight();
        try {
            buff = new BufferedImage(dpiWidth, dpiHeight, 1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IOException(ex.getMessage());
        }
        Graphics2D g2 = buff.createGraphics();
        try {
            if (!this.doPrinting(g2, mediaFormat, pageIndex, false)) {
                throw new IOException("Unable to print page " + pageIndex);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IOException(ex.getMessage());
        }
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpeg");
        ImageWriter writer = iter.next();
        ImageWriteParam iwp = writer.getDefaultWriteParam();
        iwp.setCompressionMode(2);
        iwp.setCompressionQuality(1.0f);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageOutputStream ios = ImageIO.createImageOutputStream(baos);
        writer.setOutput(ios);
        IIOImage newImage = new IIOImage(buff, null, null);
        writer.write(null, newImage, iwp);
        writer.dispose();
        byte[] bytes = baos.toByteArray();
        return new SimpleDoc(bytes, DocFlavor.BYTE_ARRAY.JPEG, null);
    }

    private boolean doPrinting(Graphics2D g2, MediaFormat mediaFormat, int pageIndex, boolean buffer) throws PrinterException {
        if (pageIndex >= this.myNumberOfPages) {
            return false;
        }
        this.myMediaFormat = mediaFormat;
        this.myMarginSpace = this.scaleDPI(6);
        this.myStroke = new BasicStroke(this.scaleDPI(1.0f));
        this.myDashed = new BasicStroke(this.scaleDPI(1.0f), 0, 0, 10.0f, dash1, 0.0f);
        if (buffer) {
            if (this.bufferingNeeded(pageIndex) || this.myBuffImage == null) {
                this.myBuffImage = new BufferedImage((int)mediaFormat.getDpiPageWidth(), (int)mediaFormat.getDpiPageHeight(), 6);
                this.myBuffGraphics = this.myBuffImage.createGraphics();
                this.printApage(pageIndex);
            }
            g2.drawImage(this.myBuffImage, null, 0, 0);
        } else {
            this.myBuffGraphics = g2;
            this.printApage(pageIndex);
        }
        this.myPriorMediaFormat = mediaFormat;
        return true;
    }

    public void setPageFormat(PageFormat pf) {
        this.myPageablePageFormat = pf;
        this.myMediaFormat = new MediaFormat(this.myPageablePageFormat);
    }

    public String convert(String text, int pageIndex) {
        text = text.replaceAll(PAGE_INDEX, Integer.toString(pageIndex + 1));
        text = text.replaceAll(PAGE_COUNT, Integer.toString(this.myNumberOfPages));
        return text;
    }

    protected MediaFormat getMediaFormat() {
        return this.myMediaFormat;
    }

    public int scaleDPI(int dpi) {
        return PrintUtils.scaleDPI(72, this.myMediaFormat.getDPI(), dpi);
    }

    protected float scaleDPI(float dpi) {
        return PrintUtils.scaleDPI(72, this.myMediaFormat.getDPI(), dpi);
    }

    public abstract PrintableBase makeCopy();

    protected abstract void drawPage(int var1) throws PrinterException;

    protected Font getFont(String fontFamily, int size, float theta) {
        Font rtnMe = null;
        int fontSize = (int)((float)size * theta);
        rtnMe = fontFamily != null ? new Font(fontFamily, 0, fontSize) : this.myBuffGraphics.getFont().deriveFont(fontSize);
        return rtnMe;
    }

    private boolean bufferingNeeded(int pageIndex) {
        boolean rtnMe = false;
        if (this.myPriorPageIndex != pageIndex) {
            rtnMe = true;
        } else if (this.myPriorMediaFormat == null) {
            rtnMe = true;
        } else if (!this.myPriorMediaFormat.equals(this.myMediaFormat)) {
            rtnMe = true;
        }
        this.myPriorMediaFormat = this.myMediaFormat;
        return rtnMe;
    }

    private void printApage(int pageIndex) throws PrinterException {
        this.myPriorPageIndex = pageIndex;
        this.fontTheta = ImageChangeUtil.calcTheta(612, 792, this.myMediaFormat.getDpiPageWidth(), this.myMediaFormat.getDpiPageHeight());
        this.myLeftMargin = this.myMediaFormat.getDpiPrintableX();
        this.myRightMargin = this.myLeftMargin + this.myMediaFormat.getDpiPrintableWidth();
        this.centerX = this.myLeftMargin + this.myMediaFormat.getDpiPrintableWidth() / 2.0;
        this.myTopMargin = this.myMediaFormat.getDpiPrintableY();
        this.myBottomMargin = this.myTopMargin + this.myMediaFormat.getDpiPrintableHeight();
        this.centerY = this.myTopMargin + this.myMediaFormat.getDpiPrintableHeight() / 2.0;
        this.myFontRenderContext = this.myBuffGraphics.getFontRenderContext();
        this.myBuffGraphics.setPaint(this.myPBO.getBackgroundColor());
        this.myBuffGraphics.fillRect(0, 0, (int)this.myMediaFormat.getDpiPageWidth(), (int)this.myMediaFormat.getDpiPageHeight());
        this.myBuffGraphics.setPaint(this.myPBO.getTextColor());
        this.myBuffGraphics.setStroke(this.myStroke);
        this.drawHeader(pageIndex);
        this.drawFooter(pageIndex);
        this.maxPictureHeight = (int)(this.myBottomPictureMargin - this.myTopPictureMargin);
        this.maxPictureWidth = (int)this.myMediaFormat.getDpiPrintableWidth();
        this.drawPage(pageIndex);
    }

    private void drawHeader(int pageIndex) {
        Font headerFont = this.getFont(this.myPBO.getHeaderFontFamily(), this.myPBO.getHeaderFontSize(), this.fontTheta);
        TextLayout text = new TextLayout("Pgy", headerFont, this.myFontRenderContext);
        float headerHeight = text.getAscent() + text.getDescent();
        double bottomOfText = this.myTopMargin + (double)headerHeight;
        if (this.myPBO.showLines()) {
            this.myBuffGraphics.draw(new Line2D.Double(this.myLeftMargin, bottomOfText, this.myRightMargin, bottomOfText));
        }
        this.myTopPictureMargin = bottomOfText + (double)this.myMarginSpace;
        int textX = (int)(this.myTopMargin + (double)text.getAscent());
        String printString = this.myPBO.getHeaderLeft(pageIndex);
        if (printString != null && printString.trim().length() > 0) {
            text = new TextLayout(printString, headerFont, this.myFontRenderContext);
            text.draw(this.myBuffGraphics, (int)this.myLeftMargin, textX);
        }
        if ((printString = this.myPBO.getHeaderRight(pageIndex) + "  ").trim().length() > 0) {
            text = new TextLayout(printString, headerFont, this.myFontRenderContext);
            text.draw(this.myBuffGraphics, (int)(this.myRightMargin - text.getBounds().getWidth()), textX);
        }
        if ((printString = this.myPBO.getHeader(pageIndex)) != null && printString.trim().length() > 0) {
            text = new TextLayout(printString, headerFont, this.myFontRenderContext);
            float headerWidth = (float)text.getBounds().getWidth();
            int textY = (int)(this.myMediaFormat.getDpiPrintableX() + (this.myMediaFormat.getDpiPrintableWidth() - (double)headerWidth) / 2.0);
            text.draw(this.myBuffGraphics, textY, textX);
        }
    }

    private void drawFooter(int pageIndex) {
        Font footerFont = this.getFont(this.myPBO.getFooterFontFamily(), this.myPBO.getFooterFontSize(), this.fontTheta);
        TextLayout text = new TextLayout("Pgy", footerFont, this.myFontRenderContext);
        float footerHeight = text.getAscent() + text.getDescent();
        double topOfText = this.myBottomMargin - (double)footerHeight;
        if (this.myPBO.showLines()) {
            this.myBuffGraphics.draw(new Line2D.Double(this.myLeftMargin, topOfText, this.myRightMargin, topOfText));
        }
        this.myBottomPictureMargin = topOfText - (double)this.myMarginSpace + 1.0;
        int textX = (int)(this.myBottomMargin - (double)text.getDescent());
        String printString = this.myPBO.getFooterLeft(pageIndex);
        if (printString != null && printString.trim().length() > 0) {
            text = new TextLayout(printString, footerFont, this.myFontRenderContext);
            text.draw(this.myBuffGraphics, (int)this.myLeftMargin, textX);
        }
        if ((printString = this.myPBO.getFooterRight(pageIndex)) != null && printString.trim().length() > 0) {
            text = new TextLayout(printString, footerFont, this.myFontRenderContext);
            text.draw(this.myBuffGraphics, (int)(this.myRightMargin - text.getBounds().getWidth()), textX);
        }
        if ((printString = this.myPBO.getFooter(pageIndex)) != null && printString.trim().length() > 0) {
            text = new TextLayout(printString, footerFont, this.myFontRenderContext);
            float footerWidth = (float)text.getBounds().getWidth();
            int textY = (int)(this.myMediaFormat.getDpiPrintableX() + (this.myMediaFormat.getDpiPrintableWidth() - (double)footerWidth) / 2.0);
            text.draw(this.myBuffGraphics, textY, textX);
        }
    }
}

