/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.util.app;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URLDecoder;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.prefs.Preferences;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.ServiceUI;
import javax.print.SimpleDoc;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashDocAttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import org.gerhardb.jibs.Jibs;
import org.gerhardb.lib.image.ImageFactory;
import org.gerhardb.lib.print.PrintableText;
import org.gerhardb.lib.swing.SwingUtils;
import org.gerhardb.lib.util.Icons;
import org.gerhardb.lib.util.app.AboutBox;
import org.gerhardb.lib.util.app.InfoPlugins;
import org.gerhardb.lib.util.startup.AppPluginStartup;
import org.gerhardb.lib.util.startup.AppStarter;

public class Info
extends JFrame {
    private static int MEGABYTE = 0x100000;
    private static String EOL = "<br>\n";
    private static String TAB = "     ";
    private JEditorPane myEditorPane = new JEditorPane();
    Manifest myManifest = AboutBox.readManifest();

    public Info(JFrame frame, InfoPlugins plugins) {
        this.setIconImage(Icons.icon(26).getImage());
        Dimension size = new Dimension(700, 400);
        this.setSize(size);
        this.setTitle("JIBS Report");
        this.myEditorPane.setEditable(false);
        this.myEditorPane.setDisabledTextColor(Color.black);
        this.myEditorPane.setEditorKit(JEditorPane.createEditorKitForContentType("text/html"));
        String jibsVersion = AboutBox.getJibsVersion(this.myManifest);
        StringBuffer sb = new StringBuffer();
        sb.append("<html><body><center><strong><big><big>JIBS Report</big><br>" + new Date() + "<br>Version: " + jibsVersion + "</big></strong></center>");
        this.category(sb, "Image Support");
        this.imageReport(sb);
        this.category(sb, "Startup Properties");
        this.startupProperties(sb);
        this.category(sb, "Manifest");
        this.manifest(sb);
        this.category(sb, "Runtime");
        this.runtimeReport(sb);
        this.category(sb, "Internationalization");
        this.localizationReport(sb);
        this.category(sb, "Printers");
        this.printerListReport(sb);
        this.category(sb, "Graphics");
        this.graphicsReport(sb, frame);
        this.category(sb, "Viewer");
        plugins.info(sb);
        this.category(sb, "System");
        this.systemReport(sb);
        this.category(sb, "Thread Groups");
        this.threadGroupReport(Thread.currentThread().getThreadGroup(), sb);
        sb.append("</body></html>");
        this.myEditorPane.setText(sb.toString());
        this.myEditorPane.setCaretPosition(0);
        JScrollPane center = new JScrollPane(this.myEditorPane, 20, 31);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)center, "Center");
        this.setJMenuBar(this.makeMenus());
        SwingUtils.centerOnScreen(this);
        super.setVisible(true);
    }

    JMenuBar makeMenus() {
        JMenu fileMenu = new JMenu("File");
        JMenu editMenu = new JMenu("Edit");
        JMenuItem closeMenu = new JMenuItem("Close");
        closeMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                Info.this.dispose();
            }
        });
        JMenuItem saveMenu = new JMenuItem("Save As...");
        saveMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                new PrintableText(Info.this.myEditorPane).file();
            }
        });
        JMenuItem printPreviewMenu = new JMenuItem(Jibs.getString("print.preview") + "...");
        printPreviewMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                PrintableText pt = new PrintableText(Info.this.myEditorPane);
                pt.previewHTML(Info.this);
            }
        });
        JMenuItem printImageMenu = new JMenuItem("Print...", 80);
        printImageMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                new PrintableText(Info.this.myEditorPane).printContent();
            }
        });
        JMenuItem printTextMenu = new JMenuItem("Print Text...", 84);
        printTextMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                Info.this.printWithService();
            }
        });
        JMenuItem copyMenu = new JMenuItem("Copy All");
        copyMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                new PrintableText(Info.this.myEditorPane).copy();
            }
        });
        fileMenu.add(saveMenu);
        fileMenu.add(printPreviewMenu);
        fileMenu.add(printImageMenu);
        fileMenu.add(new JSeparator());
        fileMenu.add(closeMenu);
        editMenu.add(copyMenu);
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(fileMenu);
        menuBar.add(editMenu);
        return menuBar;
    }

    public void printWithService() {
        PrintableText printable = new PrintableText(this.myEditorPane);
        DocFlavor.SERVICE_FORMATTED flavor = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
        HashPrintRequestAttributeSet pras = new HashPrintRequestAttributeSet();
        PrintService[] allServices = PrintServiceLookup.lookupPrintServices(flavor, pras);
        if (allServices.length == 0) {
            System.out.println("No print services found");
            return;
        }
        PrintService defaultService = PrintServiceLookup.lookupDefaultPrintService();
        PrintService service = ServiceUI.printDialog(null, 200, 200, allServices, defaultService, flavor, pras);
        if (service == null) {
            System.out.println("User cancelled print");
            return;
        }
        DocPrintJob job = service.createPrintJob();
        HashDocAttributeSet das = new HashDocAttributeSet();
        SimpleDoc doc = new SimpleDoc(printable, flavor, das);
        try {
            job.print(doc, pras);
        }
        catch (PrintException pe) {
            pe.printStackTrace();
        }
    }

    void category(StringBuffer sb, String title) {
        sb.append("<br><hr><center><strong><big>");
        sb.append(title);
        sb.append("</big></strong></center><hr>");
    }

    void localizationReport(StringBuffer sb) {
        Locale locale = Locale.getDefault();
        sb.append("Display Country: " + locale.getDisplayCountry() + EOL);
        sb.append("Display Language: " + locale.getDisplayLanguage() + EOL);
        sb.append("Display Name: " + locale.getDisplayName() + EOL);
        sb.append("Display Variant: " + locale.getDisplayVariant() + EOL);
        sb.append("ISO3 Country: " + locale.getISO3Country() + EOL);
        sb.append("ISO3 Language: " + locale.getISO3Language() + EOL);
        sb.append("Country: " + locale.getCountry() + EOL);
        sb.append("Language: " + locale.getLanguage() + EOL);
        sb.append("Variant: " + locale.getVariant() + EOL);
        sb.append("Locale: " + locale.toString() + EOL);
    }

    void startupProperties(StringBuffer sb) {
        sb.append("Started: " + AppStarter.TIME_STARTED + EOL);
        sb.append("Jibs Starup Directory: " + AppStarter.getStartupDirectory() + EOL);
        if (AppStarter.isThumbdrive()) {
            sb.append("Thumbdrive Option USED" + EOL);
        } else {
            sb.append("Thumbdrive Option NOT used" + EOL);
        }
        sb.append("Java Prefs: " + Preferences.userRoot().getClass() + EOL);
        sb.append("Pref File: " + System.getProperty("jibs.props") + EOL);
        sb.append("Run Commmand: " + AppPluginStartup.getRunCommand() + EOL);
    }

    void manifest(StringBuffer sb) {
        Manifest manifest = AboutBox.readManifest();
        if (manifest != null) {
            Attributes attr = manifest.getMainAttributes();
            sb.append("Specification Title: " + attr.getValue(Attributes.Name.SPECIFICATION_TITLE) + EOL);
            sb.append("Specification Version: " + attr.getValue(Attributes.Name.SPECIFICATION_VERSION) + EOL);
            sb.append("Specification Vendor: " + attr.getValue(Attributes.Name.SPECIFICATION_VENDOR) + EOL);
            sb.append("Implementation Vendor: " + attr.getValue(Attributes.Name.IMPLEMENTATION_VENDOR) + EOL);
            sb.append("Implementation Vendor ID: " + attr.getValue(Attributes.Name.IMPLEMENTATION_VENDOR_ID) + EOL);
            sb.append("Implementation Title: " + attr.getValue(Attributes.Name.IMPLEMENTATION_TITLE) + EOL);
            sb.append("Implementation Version: " + attr.getValue(Attributes.Name.IMPLEMENTATION_VERSION) + EOL);
            sb.append("Implementation URL: " + attr.getValue(Attributes.Name.IMPLEMENTATION_URL) + EOL);
            sb.append("Main Class: " + attr.getValue(Attributes.Name.MAIN_CLASS) + EOL);
            sb.append("Built by: " + attr.getValue("Built-By") + EOL);
        }
    }

    void runtimeReport(StringBuffer sb) {
        Runtime rt = Runtime.getRuntime();
        sb.append("Java: ");
        sb.append(System.getProperty("java.version"));
        sb.append(EOL);
        sb.append("Available Processors: ");
        sb.append(rt.availableProcessors());
        sb.append(EOL);
        sb.append("Free Memory: ").append((int)rt.freeMemory() / MEGABYTE);
        sb.append(" Megabytes");
        sb.append(EOL);
        sb.append("Total Memory: ").append((int)rt.totalMemory() / MEGABYTE);
        sb.append(" Megabytes");
        sb.append(EOL);
        sb.append("Max Memory (set by -Xmx): ");
        sb.append((int)rt.maxMemory() / MEGABYTE);
        sb.append(" Megabytes");
        sb.append(EOL);
        sb.append("Preferences Class: ");
        sb.append(Preferences.userRoot().getClass().toString());
        sb.append(EOL);
        sb.append("Property File Used: ");
        sb.append(System.getProperty("jibs.props"));
        sb.append(EOL);
        sb.append("Startup Directory: ");
        sb.append(AppStarter.getStartupDirectory().getAbsolutePath());
        sb.append(EOL);
        sb.append("Protection Domain: ");
        try {
            sb.append(URLDecoder.decode(Info.class.getProtectionDomain().getCodeSource().getLocation().getPath(), "UTF-8"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        sb.append(EOL);
        if (AppStarter.isThumbdrive()) {
            sb.append("Thumbdrive Option Selected");
        } else {
            sb.append("No Thumbdrive Option");
        }
        sb.append(EOL);
    }

    void systemReport(StringBuffer sb) {
        sb.append("System Properties:\n");
        this.propertyReport(System.getProperties(), sb);
    }

    void threadGroupReport(ThreadGroup group, StringBuffer buff) {
        int i;
        if (buff == null) {
            return;
        }
        if (group == null) {
            buff.append("No thread group");
            return;
        }
        int threadSize = group.activeCount();
        Thread[] threads = new Thread[threadSize];
        group.enumerate(threads);
        int groupSize = group.activeGroupCount();
        ThreadGroup[] groups = new ThreadGroup[groupSize];
        group.enumerate(groups);
        buff.append("Thead Group: ").append(group.getName()).append(EOL);
        buff.append("Date: ").append(new Date()).append(EOL);
        buff.append("Parent: ").append(group.getParent()).append(EOL);
        buff.append("Thead Count: ").append(threadSize).append(EOL);
        buff.append("Group Count: ").append(groupSize).append(EOL);
        buff.append(EOL);
        buff.append("Theads:\n");
        buff.append("<ol>\n");
        for (i = 0; i < threadSize; ++i) {
            Thread aThread = threads[i];
            if (aThread == null) continue;
            buff.append("<li>").append(aThread.getName()).append("</li>\n");
        }
        buff.append("</ol>\n");
        buff.append("Thead Groups:\n");
        buff.append("<ol>\n");
        for (i = 0; i < groupSize; ++i) {
            ThreadGroup aGroup = groups[i];
            if (aGroup == null) continue;
            buff.append("<li>");
            this.threadGroupReport(aGroup, buff);
            buff.append("</li>\n");
        }
        buff.append("</ol>\n");
    }

    void propertyReport(Properties showMe, StringBuffer sb) {
        Object[] items = showMe.entrySet().toArray();
        sb.append("<ol>\n");
        for (int i = 0; i < items.length; ++i) {
            Map.Entry entry = (Map.Entry)items[i];
            sb.append("<li>\n");
            sb.append(entry.getKey()).append("=").append(entry.getValue());
            sb.append("</li>\n");
        }
        sb.append("</ol>\n");
    }

    void printerListReport(StringBuffer sb) {
        PrintService[] theServices = PrintServiceLookup.lookupPrintServices(null, null);
        for (int i = 0; i < theServices.length; ++i) {
            sb.append("Print Service #");
            sb.append(i);
            sb.append(": ");
            sb.append(theServices[i].getName());
            sb.append(EOL);
        }
    }

    void imageReport(StringBuffer sb) {
        String[] plugins = ImageFactory.getImageFactory().getImagePluginsListing();
        for (int i = 0; i < plugins.length; ++i) {
            sb.append(plugins[i] + EOL);
        }
        sb.append(EOL);
        String[] endings = ImageFactory.getImageFactory().getFilter().getEndings();
        sb.append(Jibs.getString("Info.1"));
        for (int i = 0; i < endings.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(endings[i]);
        }
        sb.append(EOL);
        String[] pluginsNot = ImageFactory.getImageFactory().getImagePluginsNotLoadedListing();
        sb.append(EOL);
        if (pluginsNot.length == 0) {
            sb.append("All available plug-ins were loaded. ");
        } else {
            sb.append("Plug-ins which were not loaded: ");
            for (int i = 0; i < pluginsNot.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(pluginsNot[i]);
            }
        }
        sb.append(EOL);
    }

    void graphicsReport(StringBuffer sb, JFrame frame) {
        sb.append("Displayed JIBS frame size: " + frame.getWidth() + "W " + frame.getHeight() + "H     " + EOL);
        sb.append("Displayed JIBS frame upper left hand corner: " + frame.getX() + "X " + frame.getY() + "Y     " + EOL);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        sb.append("GraphicsEnvironment: " + ge + EOL);
        sb.append("Default Screen Device: " + ge.getDefaultScreenDevice() + EOL);
        GraphicsDevice[] sd = ge.getScreenDevices();
        for (int i = 0; i < sd.length; ++i) {
            sb.append("Graphics Device #" + i + ": " + sd[i] + "<br>");
            if (sd[i].isFullScreenSupported()) {
                sb.append(TAB + "FullScreenSupported: yes" + EOL);
            } else {
                sb.append(TAB + "FullScreenSupported: no" + EOL);
            }
            if (sd[i].isDisplayChangeSupported()) {
                sb.append(TAB + "DisplayChangeSupported: yes" + EOL);
            } else {
                sb.append(TAB + "DisplayChangeSupported: no" + EOL);
            }
            DisplayMode ddm = sd[i].getDisplayMode();
            sb.append(TAB + "Default Display Mode: width " + ddm.getWidth() + "   height " + ddm.getHeight() + "   bits " + ddm.getBitDepth() + "   refresh " + ddm.getRefreshRate() + EOL);
        }
    }

    public static void main(String[] args) {
        PrintService[] theServices = PrintServiceLookup.lookupPrintServices(null, null);
        for (int i = 0; i < theServices.length; ++i) {
            System.out.println("Print Service #" + i + ": " + theServices[i].getName());
            if (!theServices[i].getName().equals("Lexmark 5400 Series")) continue;
            PrintService aService = theServices[i];
            Class<?>[] classes = aService.getSupportedAttributeCategories();
            for (int j = 0; j < classes.length; ++j) {
                System.out.println("Class #" + j + ": " + classes[j].getName());
                if (!classes[j].getName().equals("javax.print.attribute.standard.PrinterResolution")) continue;
                System.out.println(aService.getDefaultAttributeValue(classes[j]));
            }
            Attribute[] attributes = aService.getAttributes().toArray();
            for (int j = 0; j < attributes.length; ++j) {
                System.out.println("Attribute #" + j + ": " + attributes[j].getName() + "     " + attributes[j].getClass());
            }
        }
    }
}

