/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.types;

import java.util.Enumeration;
import org.exolab.castor.builder.SourceGenerator;
import org.exolab.castor.builder.types.XSPatternBase;
import org.exolab.castor.builder.types.XSType;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JType;

public final class XSShort
extends XSPatternBase {
    Short maxInclusive = null;
    Short maxExclusive = null;
    Short minInclusive = null;
    Short minExclusive = null;
    private static JType jType = JType.Short;
    private boolean _asWrapper = false;

    public XSShort() {
        this(SourceGenerator.usePrimitiveWrapper());
    }

    public XSShort(boolean bl) {
        super((short)37);
        this._asWrapper = bl;
        jType = bl ? new JClass("java.lang.Short") : JType.Short;
    }

    public JType getJType() {
        return jType;
    }

    public Short getMaxExclusive() {
        return this.maxExclusive;
    }

    public Short getMaxInclusive() {
        return this.maxInclusive;
    }

    public Short getMinExclusive() {
        return this.minExclusive;
    }

    public Short getMinInclusive() {
        return this.minInclusive;
    }

    public boolean hasMaximum() {
        return this.maxInclusive != null || this.maxExclusive != null;
    }

    public boolean hasMinimum() {
        return this.minInclusive != null || this.minExclusive != null;
    }

    public void setMaxExclusive(short s) {
        this.maxExclusive = new Short(s);
        this.maxInclusive = null;
    }

    public void setMaxExclusive(Short s) {
        this.maxExclusive = s;
        this.maxInclusive = null;
    }

    public void setMaxInclusive(short s) {
        this.maxInclusive = new Short(s);
        this.maxExclusive = null;
    }

    public void setMaxInclusive(Short s) {
        this.maxInclusive = s;
        this.maxExclusive = null;
    }

    public void setMinExclusive(short s) {
        this.minExclusive = new Short(s);
        this.minInclusive = null;
    }

    public void setMinExclusive(Short s) {
        this.minExclusive = s;
        this.minInclusive = null;
    }

    public void setMinInclusive(short s) {
        this.minInclusive = new Short(s);
        this.minExclusive = null;
    }

    public void setMinInclusive(Short s) {
        this.minInclusive = s;
        this.minExclusive = null;
    }

    public void setFacets(SimpleType simpleType) {
        Enumeration enumeration = XSType.getFacets(simpleType);
        while (enumeration.hasMoreElements()) {
            Facet facet = (Facet)enumeration.nextElement();
            String string = facet.getName();
            if ("maxExclusive".equals(string)) {
                this.setMaxExclusive(facet.toShort());
                continue;
            }
            if ("maxInclusive".equals(string)) {
                this.setMaxInclusive(facet.toShort());
                continue;
            }
            if ("minExclusive".equals(string)) {
                this.setMinExclusive(facet.toShort());
                continue;
            }
            if ("minInclusive".equals(string)) {
                this.setMinInclusive(facet.toShort());
                continue;
            }
            if (!"pattern".equals(string)) continue;
            this.setPattern(facet.getValue());
        }
    }

    public String createToJavaObjectCode(String string) {
        if (SourceGenerator.usePrimitiveWrapper()) {
            return super.createToJavaObjectCode(string);
        }
        StringBuffer stringBuffer = new StringBuffer("new Short(");
        stringBuffer.append(string);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public String createFromJavaObjectCode(String string) {
        StringBuffer stringBuffer = new StringBuffer("((Short)");
        stringBuffer.append(string);
        stringBuffer.append(")");
        if (!this._asWrapper) {
            stringBuffer.append(".shortValue()");
        }
        return stringBuffer.toString();
    }

    public void validationCode(JSourceCode jSourceCode, String string, String string2) {
        Object object;
        if (jSourceCode == null) {
            jSourceCode = new JSourceCode();
        }
        jSourceCode.add("ShortValidator typeValidator = new ShortValidator();");
        if (this.hasMinimum()) {
            object = this.getMinExclusive();
            if (object != null) {
                jSourceCode.add("typeValidator.setMinExclusive(");
            } else {
                object = this.getMinInclusive();
                jSourceCode.add("typeValidator.setMinInclusive(");
            }
            jSourceCode.append("(short)");
            jSourceCode.append(((Short)object).toString());
            jSourceCode.append(");");
        }
        if (this.hasMaximum()) {
            object = this.getMaxExclusive();
            if (object != null) {
                jSourceCode.add("typeValidator.setMaxExclusive(");
            } else {
                object = this.getMaxInclusive();
                jSourceCode.add("typeValidator.setMaxInclusive(");
            }
            jSourceCode.append("(short)");
            jSourceCode.append(((Short)object).toString());
            jSourceCode.append(");");
        }
        if (string != null) {
            Short.parseShort(string);
            jSourceCode.add("typeValidator.setFixed(");
            jSourceCode.append("(short)");
            jSourceCode.append(string);
            jSourceCode.append(");");
        }
        if ((object = this.getPattern()) != null) {
            jSourceCode.add("typeValidator.setPattern(\"");
            jSourceCode.append(XSType.escapePattern((String)object));
            jSourceCode.append("\");");
        }
        jSourceCode.add(string2 + ".setValidator(typeValidator);");
    }
}

