/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.dsml;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import org.exolab.castor.dsml.Consumer;
import org.exolab.castor.dsml.ImportDescriptor;
import org.exolab.castor.dsml.ImportExportException;
import org.exolab.castor.dsml.SearchDescriptor;
import org.exolab.castor.util.Configuration;
import org.exolab.castor.util.LocalConfiguration;
import org.xml.sax.DocumentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public abstract class Exporter {
    private Configuration _config = LocalConfiguration.getInstance();
    private SearchDescriptor _searchDesc;
    private ImportDescriptor _importDesc;

    public void export(OutputStream outputStream, boolean bl, boolean bl2) throws ImportExportException {
        try {
            this.export(this._config.getSerializer(outputStream), bl, bl2);
        }
        catch (IOException iOException) {
            throw new ImportExportException(iOException);
        }
    }

    public void export(Writer writer, boolean bl, boolean bl2) throws ImportExportException {
        try {
            this.export(this._config.getSerializer(writer), bl, bl2);
        }
        catch (IOException iOException) {
            throw new ImportExportException(iOException);
        }
    }

    public abstract void export(DocumentHandler var1, boolean var2, boolean var3) throws ImportExportException;

    public void setSearchDescriptor(SearchDescriptor searchDescriptor) {
        this._searchDesc = searchDescriptor;
    }

    public SearchDescriptor getSearchDescriptor() {
        return this._searchDesc;
    }

    public void setImportDescriptor(ImportDescriptor importDescriptor) {
        this._importDesc = importDescriptor;
    }

    public ImportDescriptor getImportDescriptor() {
        return this._importDesc;
    }

    public void readSearchDescriptor(InputStream inputStream) throws IOException, SAXException {
        this.readSearchDescriptor(this._config.getParser(), new InputSource(inputStream));
    }

    public void readSearchDescriptor(Reader reader) throws IOException, SAXException {
        this.readSearchDescriptor(this._config.getParser(), new InputSource(reader));
    }

    protected void readSearchDescriptor(Parser parser, InputSource inputSource) throws IOException, SAXException {
        SearchDescriptor searchDescriptor = new SearchDescriptor();
        parser.setDocumentHandler(searchDescriptor);
        parser.parse(inputSource);
        this.setSearchDescriptor(searchDescriptor);
    }

    protected abstract Consumer createConsumer();
}

