/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.dsml.mozilla;

import java.util.Enumeration;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;
import org.exolab.castor.dsml.Consumer;
import org.exolab.castor.dsml.ImportDescriptor;
import org.exolab.castor.dsml.ImportExportException;
import org.exolab.castor.dsml.Importer;
import org.exolab.castor.dsml.mozilla.MozillaConsumer;

public class MozillaImporter
extends Importer {
    private LDAPConnection _conn;

    public MozillaImporter(LDAPConnection lDAPConnection) {
        this._conn = lDAPConnection;
    }

    protected Consumer createConsumer() {
        return new MozillaConsumer();
    }

    public void importEntry(LDAPEntry lDAPEntry, int n) throws LDAPException {
        if (lDAPEntry.getAttributeSet() == null || lDAPEntry.getAttributeSet().size() == 0) {
            if ((n & 1) != 0) {
                try {
                    this._conn.read(lDAPEntry.getDN());
                    this._conn.delete(lDAPEntry.getDN());
                    this.notify(lDAPEntry.getDN(), 3);
                }
                catch (LDAPException lDAPException) {
                    if (lDAPException.getLDAPResultCode() != 32) {
                        throw lDAPException;
                    }
                    this.notify(lDAPEntry.getDN(), 0);
                }
            } else {
                this.notify(lDAPEntry.getDN(), 0);
            }
        } else {
            try {
                LDAPAttribute lDAPAttribute;
                LDAPEntry lDAPEntry2 = this._conn.read(lDAPEntry.getDN());
                LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
                LDAPAttributeSet lDAPAttributeSet = lDAPEntry.getAttributeSet();
                int n2 = 0;
                while (n2 < lDAPAttributeSet.size()) {
                    lDAPAttribute = lDAPAttributeSet.elementAt(n2);
                    if (lDAPEntry2.getAttributeSet().getAttribute(lDAPAttribute.getName()) != null) {
                        if ((n & 8) == 0) {
                            if (lDAPAttribute.size() > 0) {
                                lDAPModificationSet.add(2, lDAPAttribute);
                            } else {
                                lDAPModificationSet.add(1, lDAPAttribute);
                            }
                        }
                    } else if ((n & 0x10) == 0 && lDAPAttribute.size() > 0) {
                        lDAPModificationSet.add(0, lDAPAttribute);
                    }
                    ++n2;
                }
                if ((n & 2) != 0) {
                    Enumeration enumeration = lDAPEntry2.getAttributeSet().getAttributes();
                    while (enumeration.hasMoreElements()) {
                        lDAPAttribute = (LDAPAttribute)enumeration.nextElement();
                        if (lDAPEntry.getAttribute(lDAPAttribute.getName()) != null) continue;
                        lDAPModificationSet.add(1, lDAPAttribute);
                    }
                }
                if (lDAPModificationSet.size() > 0) {
                    this._conn.modify(lDAPEntry.getDN(), lDAPModificationSet);
                    this.notify(lDAPEntry.getDN(), 2);
                } else {
                    this.notify(lDAPEntry.getDN(), 0);
                }
            }
            catch (LDAPException lDAPException) {
                if (lDAPException.getLDAPResultCode() != 32) {
                    throw lDAPException;
                }
                if ((n & 4) == 0) {
                    this._conn.add(lDAPEntry);
                    this.notify(lDAPEntry.getDN(), 1);
                }
                this.notify(lDAPEntry.getDN(), 0);
            }
        }
    }

    public void importEntries(Enumeration enumeration) throws ImportExportException {
        if (this.getImportDescriptor() == null) {
            this.setImportDescriptor(new ImportDescriptor());
        }
        try {
            while (enumeration.hasMoreElements()) {
                LDAPEntry lDAPEntry = (LDAPEntry)enumeration.nextElement();
                this.importEntry(lDAPEntry, this.getImportDescriptor().getPolicy(lDAPEntry.getDN()));
            }
        }
        catch (LDAPException lDAPException) {
            throw new ImportExportException((Exception)((Object)lDAPException));
        }
    }
}

