/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.drivers;

import java.net.InetAddress;
import java.sql.Connection;
import java.text.DecimalFormat;
import java.util.Properties;
import java.util.StringTokenizer;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.persist.spi.KeyGenerator;
import org.exolab.castor.persist.spi.PersistenceFactory;
import org.exolab.castor.util.Messages;

public final class UUIDKeyGenerator
implements KeyGenerator {
    private final int _sqlType;
    private final PersistenceFactory _factory;
    private DecimalFormat _df = new DecimalFormat();
    private String _sHost = null;
    private static long _staticCounter = 0L;

    public UUIDKeyGenerator(PersistenceFactory persistenceFactory, int n) throws MappingException {
        this._factory = persistenceFactory;
        this._sqlType = n;
        if (n != 1 && n != 12 && n != -1) {
            throw new MappingException(Messages.format("mapping.keyGenSQLType", this.getClass().getName(), new Integer(n)));
        }
    }

    public Object generateKey(Connection connection, String string, String string2, Properties properties) throws PersistenceException {
        String string3 = null;
        try {
            if (this._sHost == null) {
                this._sHost = InetAddress.getLocalHost().getHostAddress();
            }
            StringTokenizer stringTokenizer = new StringTokenizer(this._sHost, ".");
            this._df.applyPattern("000");
            while (stringTokenizer.hasMoreTokens()) {
                string3 = string3 == null ? this._df.format(new Integer(stringTokenizer.nextToken())) : string3 + this._df.format(new Integer(stringTokenizer.nextToken()));
            }
            this._df.applyPattern("0000000000000");
            string3 = string3 + this._df.format(System.currentTimeMillis());
            if (_staticCounter >= 99999L) {
                _staticCounter = 0L;
            }
            this._df.applyPattern("00000");
            string3 = string3 + this._df.format(++_staticCounter);
        }
        catch (Exception exception) {
            throw new PersistenceException(Messages.format("persist.keyGenSQL", exception.toString()), exception);
        }
        if (string3 == null) {
            throw new PersistenceException(Messages.format("persist.keyGenOverflow", this.getClass().getName()));
        }
        return string3;
    }

    public final byte getStyle() {
        return -1;
    }

    public final String patchSQL(String string, String string2) throws MappingException {
        return string;
    }

    public boolean isInSameConnection() {
        return true;
    }
}

