/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.engine;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.QueryException;
import org.exolab.castor.jdo.QueryResults;
import org.exolab.castor.jdo.engine.DatabaseImpl;
import org.exolab.castor.jdo.engine.DatabaseRegistry;
import org.exolab.castor.persist.spi.QueryExpression;

public class SimpleQueryExecutor {
    private DatabaseImpl _dbImpl;
    private Connection _conn = null;
    private PreparedStatement _stmt = null;
    private ResultSet _rset = null;

    public SimpleQueryExecutor(DatabaseImpl databaseImpl) {
        this._dbImpl = databaseImpl;
    }

    public QueryResults execute(QueryExpression queryExpression, Object[] objectArray) throws QueryException {
        try {
            this._conn = DatabaseRegistry.createConnection(this._dbImpl.getLockEngine());
            this._stmt = this._conn.prepareStatement(queryExpression.getStatement(false));
            if (objectArray != null) {
                int n = 0;
                while (n < objectArray.length) {
                    this._stmt.setObject(n + 1, objectArray[n]);
                    ++n;
                }
            }
            this._rset = this._stmt.executeQuery();
            return new SimpleQueryResults();
        }
        catch (SQLException sQLException) {
            if (this._rset != null) {
                try {
                    this._rset.close();
                }
                catch (SQLException sQLException2) {
                    // empty catch block
                }
            }
            if (this._stmt != null) {
                try {
                    this._stmt.close();
                }
                catch (SQLException sQLException3) {
                    // empty catch block
                }
            }
            if (this._conn != null) {
                try {
                    this._conn.close();
                }
                catch (SQLException sQLException4) {
                    // empty catch block
                }
            }
            this._rset = null;
            this._stmt = null;
            this._conn = null;
            throw new QueryException(sQLException.toString());
        }
    }

    public class SimpleQueryResults
    implements QueryResults {
        private boolean _hasMore = false;

        public SimpleQueryResults() {
            try {
                this._hasMore = SimpleQueryExecutor.this._rset.next();
            }
            catch (SQLException sQLException) {
                this._hasMore = false;
            }
        }

        public boolean absolute(int n) throws PersistenceException {
            boolean bl = false;
            try {
                if (SimpleQueryExecutor.this._rset != null) {
                    bl = SimpleQueryExecutor.this._rset.absolute(n);
                }
            }
            catch (SQLException sQLException) {
                throw new PersistenceException(sQLException.getMessage());
            }
            return bl;
        }

        public int size() throws PersistenceException {
            int n = 1;
            int n2 = 0;
            try {
                if (SimpleQueryExecutor.this._rset != null) {
                    n = SimpleQueryExecutor.this._rset.getRow();
                    n2 = SimpleQueryExecutor.this._rset.last() ? SimpleQueryExecutor.this._rset.getRow() : 0;
                    if (n > 0) {
                        SimpleQueryExecutor.this._rset.absolute(n);
                    } else {
                        SimpleQueryExecutor.this._rset.beforeFirst();
                    }
                }
            }
            catch (SQLException sQLException) {
                throw new PersistenceException(sQLException.getMessage());
            }
            return n2;
        }

        public boolean hasMoreElements() {
            return this._hasMore;
        }

        public boolean hasMore() throws PersistenceException {
            return this._hasMore;
        }

        public Object nextElement() throws NoSuchElementException {
            try {
                return this.next(true);
            }
            catch (PersistenceException persistenceException) {
                return null;
            }
        }

        public Object next() throws PersistenceException, NoSuchElementException {
            return this.next(false);
        }

        private Object next(boolean bl) throws PersistenceException, NoSuchElementException {
            Object object;
            block3: {
                object = null;
                if (!this._hasMore) {
                    throw new NoSuchElementException();
                }
                try {
                    object = SimpleQueryExecutor.this._rset.getObject(1);
                    this._hasMore = SimpleQueryExecutor.this._rset.next();
                }
                catch (SQLException sQLException) {
                    if (bl) break block3;
                    throw new PersistenceException(sQLException.toString());
                }
            }
            return object;
        }

        public void close() {
            if (SimpleQueryExecutor.this._rset != null) {
                try {
                    SimpleQueryExecutor.this._rset.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            if (SimpleQueryExecutor.this._stmt != null) {
                try {
                    SimpleQueryExecutor.this._stmt.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            if (SimpleQueryExecutor.this._conn != null) {
                try {
                    SimpleQueryExecutor.this._conn.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            SimpleQueryExecutor.this._rset = null;
            SimpleQueryExecutor.this._stmt = null;
            SimpleQueryExecutor.this._conn = null;
        }

        protected void finalize() throws Throwable {
            this.close();
        }
    }
}

