/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.persist;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import org.exolab.castor.jdo.ClassNotPersistenceCapableException;
import org.exolab.castor.jdo.DuplicateIdentityException;
import org.exolab.castor.jdo.LockNotGrantedException;
import org.exolab.castor.jdo.ObjectDeletedException;
import org.exolab.castor.jdo.ObjectModifiedException;
import org.exolab.castor.jdo.ObjectNotFoundException;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.mapping.AccessMode;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.MappingResolver;
import org.exolab.castor.mapping.loader.MappingLoader;
import org.exolab.castor.persist.ClassMolder;
import org.exolab.castor.persist.LRU;
import org.exolab.castor.persist.OID;
import org.exolab.castor.persist.ObjectDeletedWaitingForLockException;
import org.exolab.castor.persist.ObjectLock;
import org.exolab.castor.persist.QueryResults;
import org.exolab.castor.persist.TransactionContext;
import org.exolab.castor.persist.spi.LogInterceptor;
import org.exolab.castor.persist.spi.Persistence;
import org.exolab.castor.persist.spi.PersistenceFactory;
import org.exolab.castor.util.Messages;

public final class LockEngine {
    private HashMap _typeInfo = new HashMap();
    private HashMap _xaTx = new HashMap();
    private PersistenceFactory _factory;
    private LogInterceptor _logInterceptor;

    LockEngine(MappingResolver mappingResolver, PersistenceFactory persistenceFactory, LogInterceptor logInterceptor) throws MappingException {
        try {
            ClassMolder classMolder;
            Iterator iterator;
            Vector vector = ClassMolder.resolve((MappingLoader)mappingResolver, this, persistenceFactory, logInterceptor);
            this._typeInfo = new HashMap();
            Enumeration enumeration = vector.elements();
            HashSet<ClassMolder> hashSet = new HashSet<ClassMolder>();
            HashSet hashSet2 = new HashSet();
            while (enumeration.hasMoreElements()) {
                hashSet2.add(enumeration.nextElement());
            }
            int n = 0;
            do {
                n = hashSet2.size();
                iterator = hashSet2.iterator();
                while (iterator.hasNext()) {
                    Object object;
                    classMolder = (ClassMolder)iterator.next();
                    ClassMolder classMolder2 = classMolder.getExtends();
                    if (classMolder2 == null) {
                        object = LRU.create(classMolder.getCacheType(), classMolder.getCacheParam());
                        TypeInfo typeInfo = new TypeInfo(classMolder, new HashMap(), (LRU)object);
                        this._typeInfo.put(classMolder.getName(), typeInfo);
                        iterator.remove();
                        hashSet.add(classMolder);
                        continue;
                    }
                    if (!hashSet.contains(classMolder.getExtends())) continue;
                    object = (TypeInfo)this._typeInfo.get(classMolder2.getName());
                    this._typeInfo.put(classMolder.getName(), new TypeInfo(classMolder, (TypeInfo)object));
                    iterator.remove();
                    hashSet.add(classMolder);
                }
            } while (hashSet2.size() > 0 && n != hashSet2.size());
            if (hashSet2.size() > 0) {
                iterator = hashSet2.iterator();
                while (iterator.hasNext()) {
                    classMolder = (ClassMolder)iterator.next();
                    this._logInterceptor.message("The base class, " + classMolder.getExtends().getName() + ", of the extends class ," + classMolder.getName() + " can not be resolved! ");
                }
                throw new MappingException("Some base class can not be resolved!");
            }
            this._logInterceptor = logInterceptor;
            this._factory = persistenceFactory;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new MappingException("Declared Class not found!");
        }
    }

    public ClassMolder getClassMolder(Class clazz) {
        TypeInfo typeInfo = (TypeInfo)this._typeInfo.get(clazz.getName());
        if (typeInfo != null && !typeInfo.molder.isDependent()) {
            return typeInfo.molder;
        }
        return null;
    }

    public Persistence getPersistence(Class clazz) {
        ClassMolder classMolder = this.getClassMolder(clazz);
        if (classMolder != null) {
            return classMolder.getPersistence();
        }
        return null;
    }

    public OID load(TransactionContext transactionContext, OID oID, Object object, AccessMode accessMode, int n) throws ObjectNotFoundException, LockNotGrantedException, PersistenceException, ClassNotPersistenceCapableException, ObjectDeletedWaitingForLockException {
        return this.load(transactionContext, oID, object, accessMode, n, null);
    }

    public OID load(TransactionContext transactionContext, OID oID, Object object, AccessMode accessMode, int n, QueryResults queryResults) throws ObjectNotFoundException, LockNotGrantedException, PersistenceException, ClassNotPersistenceCapableException, ObjectDeletedWaitingForLockException {
        TypeInfo typeInfo = (TypeInfo)this._typeInfo.get(oID.getName());
        if (typeInfo == null) {
            throw new ClassNotPersistenceCapableException(Messages.format("persist.classNotPersistenceCapable", oID.getName()));
        }
        ClassMolder classMolder = oID.getMolder();
        AccessMode accessMode2 = classMolder.getAccessMode(accessMode);
        boolean bl = false;
        ObjectLock objectLock = null;
        try {
            block8: {
                try {
                    short s = accessMode2 == AccessMode.Exclusive || accessMode2 == AccessMode.DbLocked ? (short)2 : 1;
                    objectLock = typeInfo.acquire(oID, transactionContext, s, n);
                    OID oID2 = objectLock.getOID();
                    Object object2 = typeInfo.molder.load(transactionContext, oID2, objectLock, object, accessMode, queryResults);
                    bl = true;
                    oID2.setStamp(object2);
                    if (oID2 != null) {
                        oID = oID2;
                    }
                    if (this._logInterceptor == null) break block8;
                    this._logInterceptor.loading(typeInfo.molder.getName(), oID.getIdentity());
                }
                catch (ObjectDeletedWaitingForLockException objectDeletedWaitingForLockException) {
                    throw new ObjectNotFoundException(Messages.format("persist.objectNotFound", oID.getName(), oID.getIdentity()));
                }
            }
            Object var18_16 = null;
            if (objectLock != null) {
                objectLock.confirm(transactionContext, bl);
            }
        }
        catch (Throwable throwable) {
            Object var18_17 = null;
            if (objectLock != null) {
                objectLock.confirm(transactionContext, bl);
            }
            throw throwable;
        }
        return oID;
    }

    public void markCreate(TransactionContext transactionContext, OID oID, Object object) throws PersistenceException, LockNotGrantedException {
        TypeInfo typeInfo = (TypeInfo)this._typeInfo.get(oID.getName());
        if (typeInfo == null) {
            throw new ClassNotPersistenceCapableException(Messages.format("persist.classNotPersistenceCapable", oID.getName()));
        }
        typeInfo.molder.markCreate(transactionContext, oID, null, object);
    }

    public OID create(TransactionContext transactionContext, OID oID, Object object) throws DuplicateIdentityException, PersistenceException, ClassNotPersistenceCapableException {
        TypeInfo typeInfo = (TypeInfo)this._typeInfo.get(object.getClass().getName());
        if (typeInfo == null) {
            throw new ClassNotPersistenceCapableException(Messages.format("persist.classNotPersistenceCapable", object.getClass().getName()));
        }
        boolean bl = true;
        ObjectLock objectLock = null;
        if (oID.getIdentity() != null) {
            objectLock = null;
            boolean bl2 = false;
            try {
                try {
                    objectLock = typeInfo.acquire(oID, transactionContext, (short)3, 0);
                    if (this._logInterceptor != null) {
                        this._logInterceptor.creating(typeInfo.molder.getName(), oID.getIdentity());
                    }
                    oID = objectLock.getOID();
                    typeInfo.molder.create(transactionContext, oID, objectLock, object);
                    bl2 = true;
                    oID.setDbLock(true);
                    OID oID2 = oID;
                    Object var14_13 = null;
                    if (objectLock != null) {
                        objectLock.confirm(transactionContext, bl2);
                    }
                    return oID2;
                }
                catch (LockNotGrantedException lockNotGrantedException) {
                    throw new DuplicateIdentityException(Messages.format("persist.duplicateIdentity", object.getClass().getName(), oID.getIdentity()));
                }
                catch (DuplicateIdentityException duplicateIdentityException) {
                    throw duplicateIdentityException;
                }
            }
            catch (Throwable throwable) {
                Object var14_14 = null;
                if (objectLock != null) {
                    objectLock.confirm(transactionContext, bl2);
                }
                throw throwable;
            }
        }
        boolean bl3 = false;
        try {
            try {
                if (this._logInterceptor != null) {
                    this._logInterceptor.creating(typeInfo.molder.getName(), oID.getIdentity());
                }
                objectLock = typeInfo.acquire(oID, transactionContext, (short)3, 0);
                oID = objectLock.getOID();
                Object object2 = typeInfo.molder.create(transactionContext, oID, objectLock, object);
                bl3 = true;
                oID.setDbLock(true);
                OID oID3 = new OID(oID.getLockEngine(), oID.getMolder(), oID.getDepends(), object2);
                typeInfo.rename(oID, oID3, transactionContext);
                OID oID4 = oID3;
                Object var16_19 = null;
                if (objectLock != null) {
                    objectLock.confirm(transactionContext, bl3);
                }
                return oID4;
            }
            catch (LockNotGrantedException lockNotGrantedException) {
                lockNotGrantedException.printStackTrace();
                throw new PersistenceException(Messages.format("persist.nested", "Key Generator Failure. Duplicated Identity is generated!"));
            }
        }
        catch (Throwable throwable) {
            block16: {
                Object var16_20 = null;
                if (objectLock == null) break block16;
                objectLock.confirm(transactionContext, bl3);
            }
            throw throwable;
        }
    }

    public void delete(TransactionContext transactionContext, OID oID, Object object) throws PersistenceException {
        TypeInfo typeInfo = (TypeInfo)this._typeInfo.get(oID.getName());
        try {
            ObjectLock objectLock = typeInfo.assure(oID, transactionContext, true);
            if (this._logInterceptor != null) {
                this._logInterceptor.removing(typeInfo.molder.getName(), oID.getIdentity());
            }
            typeInfo.molder.delete(transactionContext, oID);
        }
        catch (LockNotGrantedException lockNotGrantedException) {
            throw new IllegalStateException(Messages.format("persist.internal", "Attempt to delete object for which no lock was acquired"));
        }
    }

    public void markDelete(TransactionContext transactionContext, OID oID, Object object, int n) throws PersistenceException, LockNotGrantedException {
        TypeInfo typeInfo = (TypeInfo)this._typeInfo.get(oID.getName());
        ObjectLock objectLock = typeInfo.upgrade(oID, transactionContext, n);
        typeInfo.molder.markDelete(transactionContext, oID, objectLock, object);
    }

    public boolean update(TransactionContext transactionContext, OID oID, Object object, AccessMode accessMode, int n) throws ObjectNotFoundException, LockNotGrantedException, ObjectModifiedException, PersistenceException, ClassNotPersistenceCapableException, ObjectDeletedWaitingForLockException {
        TypeInfo typeInfo = (TypeInfo)this._typeInfo.get(oID.getName());
        if (typeInfo == null) {
            throw new ClassNotPersistenceCapableException(Messages.format("persist.classNotPersistenceCapable", oID.getName()));
        }
        boolean bl = false;
        ObjectLock objectLock = null;
        try {
            try {
                objectLock = typeInfo.acquire(oID, transactionContext, (short)4, n);
                oID = objectLock.getOID();
                boolean bl2 = typeInfo.molder.update(transactionContext, oID, objectLock, object, accessMode);
                bl = !bl2;
                boolean bl3 = bl2;
                Object var13_13 = null;
                if (objectLock != null) {
                    objectLock.confirm(transactionContext, bl);
                }
                return bl3;
            }
            catch (ObjectModifiedException objectModifiedException) {
                throw objectModifiedException;
            }
            catch (ObjectDeletedWaitingForLockException objectDeletedWaitingForLockException) {
                throw new ObjectNotFoundException(Messages.format("persist.objectNotFound", oID.getName(), oID.getIdentity()));
            }
        }
        catch (Throwable throwable) {
            block7: {
                Object var13_14 = null;
                if (objectLock == null) break block7;
                objectLock.confirm(transactionContext, bl);
            }
            throw throwable;
        }
    }

    public OID preStore(TransactionContext transactionContext, OID oID, Object object, int n) throws LockNotGrantedException, PersistenceException {
        boolean bl;
        ObjectLock objectLock = null;
        TypeInfo typeInfo = (TypeInfo)this._typeInfo.get(object.getClass().getName());
        oID = new OID(this, typeInfo.molder, oID.getIdentity());
        try {
            objectLock = typeInfo.assure(oID, transactionContext, false);
            oID = objectLock.getOID();
            bl = typeInfo.molder.preStore(transactionContext, oID, objectLock, object, n);
        }
        catch (LockNotGrantedException lockNotGrantedException) {
            throw lockNotGrantedException;
        }
        catch (ObjectModifiedException objectModifiedException) {
            objectLock.invalidate(transactionContext);
            throw objectModifiedException;
        }
        catch (ObjectDeletedException objectDeletedException) {
            objectLock.delete(transactionContext);
            throw objectDeletedException;
        }
        if (bl) {
            return oID;
        }
        return null;
    }

    public void store(TransactionContext transactionContext, OID oID, Object object) throws LockNotGrantedException, ObjectDeletedException, ObjectModifiedException, DuplicateIdentityException, PersistenceException {
        ObjectLock objectLock = null;
        TypeInfo typeInfo = (TypeInfo)this._typeInfo.get(oID.getName());
        try {
            objectLock = typeInfo.assure(oID, transactionContext, false);
            if (this._logInterceptor != null) {
                this._logInterceptor.storing(typeInfo.molder.getName(), oID.getIdentity());
            }
            typeInfo.molder.store(transactionContext, oID, objectLock, object);
        }
        catch (ObjectModifiedException objectModifiedException) {
            objectLock.invalidate(transactionContext);
            throw objectModifiedException;
        }
        catch (DuplicateIdentityException duplicateIdentityException) {
            throw duplicateIdentityException;
        }
        catch (LockNotGrantedException lockNotGrantedException) {
            throw lockNotGrantedException;
        }
        catch (PersistenceException persistenceException) {
            objectLock.invalidate(transactionContext);
            throw persistenceException;
        }
    }

    public void writeLock(TransactionContext transactionContext, OID oID, int n) throws ObjectDeletedException, LockNotGrantedException, PersistenceException {
        TypeInfo typeInfo = (TypeInfo)this._typeInfo.get(oID.getName());
        try {
            typeInfo.upgrade(oID, transactionContext, n);
        }
        catch (IllegalStateException illegalStateException) {
            throw illegalStateException;
        }
        catch (ObjectDeletedWaitingForLockException objectDeletedWaitingForLockException) {
            throw new IllegalStateException("Object deleted waiting for lock?????????");
        }
        catch (LockNotGrantedException lockNotGrantedException) {
            throw lockNotGrantedException;
        }
    }

    public void softLock(TransactionContext transactionContext, OID oID, int n) throws LockNotGrantedException {
        TypeInfo typeInfo = (TypeInfo)this._typeInfo.get(oID.getName());
        typeInfo.upgrade(oID, transactionContext, n);
    }

    public void revertObject(TransactionContext transactionContext, OID oID, Object object) throws PersistenceException {
        TypeInfo typeInfo = (TypeInfo)this._typeInfo.get(oID.getName());
        try {
            ObjectLock objectLock = typeInfo.assure(oID, transactionContext, false);
            typeInfo.molder.revertObject(transactionContext, oID, objectLock, object);
        }
        catch (LockNotGrantedException lockNotGrantedException) {
            throw new IllegalStateException("Write Lock expected!");
        }
        catch (PersistenceException persistenceException) {
            throw persistenceException;
        }
    }

    public void updateCache(TransactionContext transactionContext, OID oID, Object object) {
        TypeInfo typeInfo = (TypeInfo)this._typeInfo.get(oID.getName());
        try {
            ObjectLock objectLock = typeInfo.assure(oID, transactionContext, true);
            typeInfo.molder.updateCache(transactionContext, oID, objectLock, object);
        }
        catch (LockNotGrantedException lockNotGrantedException) {
            throw new IllegalStateException("Write Lock expected!");
        }
        catch (PersistenceException persistenceException) {
            typeInfo.delete(oID, transactionContext);
        }
    }

    public void releaseLock(TransactionContext transactionContext, OID oID) {
        TypeInfo typeInfo = (TypeInfo)this._typeInfo.get(oID.getName());
        ObjectLock objectLock = typeInfo.release(oID, transactionContext);
        objectLock.getOID().setDbLock(false);
    }

    public void forgetObject(TransactionContext transactionContext, OID oID) {
        TypeInfo typeInfo = (TypeInfo)this._typeInfo.get(oID.getName());
        try {
            typeInfo.assure(oID, transactionContext, true);
            typeInfo.delete(oID, transactionContext);
            typeInfo.release(oID, transactionContext);
        }
        catch (LockNotGrantedException lockNotGrantedException) {
            if (this._logInterceptor != null) {
                this._logInterceptor.message(Messages.format("persist.internal", "forgetObject: " + lockNotGrantedException.toString()));
            }
            throw new IllegalStateException(lockNotGrantedException.toString());
        }
    }

    public HashMap getXATransactions() {
        return this._xaTx;
    }

    private class TypeInfo {
        private final ClassMolder molder;
        private final String name;
        private final HashMap locks;
        private final LRU cache;

        private TypeInfo(ClassMolder classMolder, HashMap hashMap, LRU lRU) {
            this.name = classMolder.getName();
            this.molder = classMolder;
            this.locks = hashMap;
            this.cache = lRU;
        }

        private TypeInfo(ClassMolder classMolder, TypeInfo typeInfo) {
            this(classMolder, typeInfo.locks, typeInfo.cache);
        }

        private ObjectLock acquire(OID oID, TransactionContext transactionContext, short s, int n) throws ObjectDeletedWaitingForLockException, LockNotGrantedException, ObjectDeletedException {
            HashMap hashMap;
            Object object;
            ObjectLock objectLock = null;
            boolean bl = false;
            boolean bl2 = true;
            HashMap hashMap2 = this.locks;
            synchronized (hashMap2) {
                objectLock = (ObjectLock)this.locks.get(oID);
                if (objectLock == null && (objectLock = (ObjectLock)this.cache.remove(oID)) != null) {
                    object = objectLock.getOID();
                    if (oID.getName().equals(((OID)object).getName())) {
                        objectLock.setOID(oID);
                        this.locks.put(oID, objectLock);
                    } else {
                        objectLock = null;
                    }
                }
                if (objectLock == null) {
                    bl = true;
                    objectLock = new ObjectLock(oID);
                    this.locks.put(oID, objectLock);
                } else {
                    oID = objectLock.getOID();
                }
                objectLock.enter();
            }
            try {
                switch (s) {
                    case 1: {
                        objectLock.acquireLoadLock(transactionContext, false, n);
                        break;
                    }
                    case 2: {
                        objectLock.acquireLoadLock(transactionContext, true, n);
                        break;
                    }
                    case 3: {
                        objectLock.acquireCreateLock(transactionContext);
                        break;
                    }
                    case 4: {
                        objectLock.acquireUpdateLock(transactionContext, n);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("lockType " + s + " is undefined!");
                    }
                }
                bl2 = false;
                object = objectLock;
                Object var12_11 = null;
                hashMap = this.locks;
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                HashMap hashMap3 = this.locks;
                synchronized (hashMap3) {
                    objectLock.leave();
                    if (bl2 && objectLock.isDisposable()) {
                        this.locks.remove(oID);
                        this.cache.put(oID, objectLock);
                    }
                }
                throw throwable;
            }
            synchronized (hashMap) {
                objectLock.leave();
                if (bl2 && objectLock.isDisposable()) {
                    this.locks.remove(oID);
                    this.cache.put(oID, objectLock);
                }
            }
            return object;
        }

        private ObjectLock upgrade(OID oID, TransactionContext transactionContext, int n) throws ObjectDeletedWaitingForLockException, LockNotGrantedException {
            HashMap hashMap;
            ObjectLock objectLock;
            ObjectLock objectLock2 = null;
            HashMap hashMap2 = this.locks;
            synchronized (hashMap2) {
                objectLock2 = (ObjectLock)this.locks.get(oID);
                if (objectLock2 == null) {
                    throw new ObjectDeletedWaitingForLockException("Lock entry not found. Deleted?");
                }
                if (!objectLock2.hasLock(transactionContext, false)) {
                    throw new IllegalStateException("Transaction does not hold the any lock on " + oID + "!");
                }
                oID = objectLock2.getOID();
                objectLock2.enter();
            }
            try {
                objectLock2.upgrade(transactionContext, n);
                objectLock = objectLock2;
                Object var8_8 = null;
                hashMap = this.locks;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                HashMap hashMap3 = this.locks;
                synchronized (hashMap3) {
                    objectLock2.leave();
                }
                throw throwable;
            }
            synchronized (hashMap) {
                objectLock2.leave();
            }
            return objectLock;
        }

        private ObjectLock assure(OID oID, TransactionContext transactionContext, boolean bl) throws ObjectDeletedWaitingForLockException, LockNotGrantedException {
            HashMap hashMap = this.locks;
            synchronized (hashMap) {
                ObjectLock objectLock = (ObjectLock)this.locks.get(oID);
                if (objectLock == null) {
                    throw new IllegalStateException("Lock, " + oID + ", doesn't exist or no lock!");
                }
                if (!objectLock.hasLock(transactionContext, bl)) {
                    throw new IllegalStateException("Transaction " + transactionContext + " does not hold the " + (bl ? "write" : "read") + " lock: " + objectLock + "!");
                }
                ObjectLock objectLock2 = objectLock;
                return objectLock2;
            }
        }

        private ObjectLock rename(OID oID, OID oID2, TransactionContext transactionContext) throws LockNotGrantedException {
            HashMap hashMap = this.locks;
            synchronized (hashMap) {
                ObjectLock objectLock = (ObjectLock)this.locks.get(oID);
                ObjectLock objectLock2 = (ObjectLock)this.locks.get(oID2);
                if (oID == oID2) {
                    throw new LockNotGrantedException("Locks are the same");
                }
                if (objectLock == null) {
                    throw new LockNotGrantedException("Lock doesn't exsit!");
                }
                if (!objectLock.isExclusivelyOwned(transactionContext)) {
                    throw new LockNotGrantedException("Lock to be renamed is not own exclusively by transaction!");
                }
                if (objectLock.isEntered()) {
                    throw new LockNotGrantedException("Lock to be renamed is being acquired by another transaction!");
                }
                if (objectLock2 != null) {
                    throw new LockNotGrantedException("Lock is already existed for the new oid.");
                }
                objectLock = (ObjectLock)this.locks.remove(oID);
                objectLock.setOID(oID2);
                this.locks.put(oID2, objectLock);
                oID2.setDbLock(oID.isDbLock());
                oID2.setStamp(oID.getStamp());
                ObjectLock objectLock3 = objectLock2;
                return objectLock3;
            }
        }

        private ObjectLock delete(OID oID, TransactionContext transactionContext) {
            HashMap hashMap;
            ObjectLock objectLock;
            ObjectLock objectLock2;
            HashMap hashMap2 = this.locks;
            synchronized (hashMap2) {
                objectLock2 = (ObjectLock)this.locks.get(oID);
                if (objectLock2 == null) {
                    throw new IllegalStateException("No lock to destory!");
                }
                objectLock2.enter();
            }
            try {
                objectLock2.delete(transactionContext);
                objectLock = objectLock2;
                Object var7_7 = null;
                hashMap = this.locks;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                HashMap hashMap3 = this.locks;
                synchronized (hashMap3) {
                    objectLock2.leave();
                    if (objectLock2.isDisposable()) {
                        this.locks.remove(oID);
                    }
                }
                throw throwable;
            }
            synchronized (hashMap) {
                objectLock2.leave();
                if (objectLock2.isDisposable()) {
                    this.locks.remove(oID);
                }
            }
            return objectLock;
        }

        private ObjectLock release(OID oID, TransactionContext transactionContext) {
            HashMap hashMap;
            ObjectLock objectLock;
            boolean bl = true;
            ObjectLock objectLock2 = null;
            HashMap hashMap2 = this.locks;
            synchronized (hashMap2) {
                objectLock2 = (ObjectLock)this.locks.get(oID);
                if (objectLock2 == null) {
                    throw new IllegalStateException("No lock to release! " + oID + " for transaction " + transactionContext);
                }
                objectLock2.enter();
            }
            try {
                objectLock2.release(transactionContext);
                bl = false;
                objectLock = objectLock2;
                Object var8_8 = null;
                hashMap = this.locks;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                HashMap hashMap3 = this.locks;
                synchronized (hashMap3) {
                    objectLock2.leave();
                    if (objectLock2.isDisposable()) {
                        this.cache.put(oID, objectLock2);
                        this.locks.remove(oID);
                    }
                }
                throw throwable;
            }
            synchronized (hashMap) {
                objectLock2.leave();
                if (objectLock2.isDisposable()) {
                    this.cache.put(oID, objectLock2);
                    this.locks.remove(oID);
                }
            }
            return objectLock;
        }
    }
}

