/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.util;

import java.io.Serializable;
import java.lang.reflect.Array;

public class List
implements Cloneable,
Serializable {
    private int DEFAULT_SIZE;
    private Object[] elements;
    private int initialSize;
    private int elementCount;

    public List() {
        this.initialSize = this.DEFAULT_SIZE = 11;
        this.elementCount = 0;
        this.elements = new Object[this.DEFAULT_SIZE];
    }

    public List(int n) {
        this.initialSize = this.DEFAULT_SIZE = 11;
        this.elementCount = 0;
        this.initialSize = n;
        this.elements = new Object[n];
    }

    public boolean add(Object object) {
        if (this.elementCount == this.elements.length) {
            this.increaseSize();
        }
        this.elements[this.elementCount++] = object;
        return true;
    }

    public boolean add(int n, Object object) throws IndexOutOfBoundsException {
        if (n < 0 || n > this.elementCount) {
            throw new IndexOutOfBoundsException();
        }
        if (this.elementCount == this.elements.length) {
            this.increaseSize();
        }
        if (n == this.elementCount) {
            this.elements[this.elementCount++] = object;
        } else {
            this.shiftUp(n);
            this.elements[n] = object;
            ++this.elementCount;
        }
        return true;
    }

    public void clear() {
        int n = 0;
        while (n < this.elementCount) {
            this.elements[n] = null;
            ++n;
        }
        this.elementCount = 0;
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return object;
    }

    public boolean contains(Object object) {
        return this.indexOf(object) >= 0;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof List)) {
            return false;
        }
        List list = (List)object;
        if (list.size() != this.size()) {
            return false;
        }
        int n = 0;
        while (n < this.size()) {
            Object object2 = this.get(n);
            Object object3 = list.get(n);
            if (!(object2 == null ? object3 == null : object2.equals(object3))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public Object get(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n >= this.elementCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.elements[n];
    }

    public int hashCode() {
        int n = 1;
        int n2 = 0;
        while (n2 < this.elementCount) {
            Object object = this.elements[n2];
            n = 31 * n + (object == null ? 0 : object.hashCode());
            ++n2;
        }
        return n;
    }

    public int indexOf(Object object) {
        if (object == null) {
            int n = 0;
            while (n < this.elementCount) {
                if (this.elements[n] == null) {
                    return n;
                }
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.elementCount) {
                if (object.equals(this.elements[n])) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public int lastIndexOf(Object object) {
        if (object == null) {
            int n = this.elementCount - 1;
            while (n >= 0) {
                if (this.elements[n] == null) {
                    return n;
                }
                --n;
            }
        } else {
            int n = this.elementCount - 1;
            while (n >= 0) {
                if (object.equals(this.elements[n])) {
                    return n;
                }
                --n;
            }
        }
        return -1;
    }

    public Object remove(int n) {
        if (n < 0 || n > this.elementCount) {
            return null;
        }
        Object object = this.elements[n];
        this.shiftDown(n + 1);
        --this.elementCount;
        return object;
    }

    public boolean remove(Object object) {
        int n = this.indexOf(object);
        if (n <= -1) {
            return false;
        }
        this.remove(n);
        return true;
    }

    public void trimToSize() {
        Object[] objectArray = this.elements;
        this.elements = new Object[this.elementCount];
        System.arraycopy(objectArray, 0, this.elements, 0, this.elementCount);
        objectArray = null;
    }

    public Object set(int n, Object object) throws IndexOutOfBoundsException {
        if (n < 0 || n > this.elementCount) {
            throw new IndexOutOfBoundsException();
        }
        Object object2 = null;
        if (n == this.elementCount) {
            this.add(object);
        } else {
            object2 = this.elements[n];
            this.elements[n] = object;
        }
        return object2;
    }

    public int size() {
        return this.elementCount;
    }

    public List subList(int n, int n2) {
        if (n < 0 || n2 > this.size() || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        List list = new List(n2 - n);
        int n3 = n;
        while (n3 < n2) {
            list.add(this.elements[n3]);
            ++n3;
        }
        return list;
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.elementCount];
        System.arraycopy(this.elements, 0, objectArray, 0, this.elementCount);
        return objectArray;
    }

    public Object[] toArray(Object[] objectArray) {
        return this.toArray(objectArray, 0);
    }

    public Object[] toArray(Object[] objectArray, int n) {
        Object[] objectArray2 = null;
        if (objectArray.length >= this.elementCount) {
            objectArray2 = objectArray;
        } else {
            Class<?> clazz = objectArray.getClass();
            objectArray2 = (Object[])Array.newInstance(clazz, this.elementCount);
        }
        System.arraycopy(this.elements, 0, objectArray2, n, this.elementCount);
        return objectArray2;
    }

    private void increaseSize() {
        Object[] objectArray = this.elements;
        int n = objectArray.length > 0 ? objectArray.length : 1;
        this.elements = new Object[n * 3 / 2 + 1];
        System.arraycopy(objectArray, 0, this.elements, 0, objectArray.length);
        objectArray = null;
    }

    private void shiftDown(int n) {
        if (n <= 0 || n >= this.elementCount) {
            return;
        }
        System.arraycopy(this.elements, n, this.elements, n - 1, this.elementCount - n);
        this.elements[this.elementCount - 1] = null;
    }

    private void shiftUp(int n) {
        if (n == this.elementCount) {
            return;
        }
        if (this.elementCount == this.elements.length) {
            this.increaseSize();
        }
        System.arraycopy(this.elements, n, this.elements, n + 1, this.elementCount - n);
    }
}

