/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.util;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Date;

public class Logger
extends PrintWriter {
    private static final String Prefix = "Castor";
    private static PrintWriter _system = new Logger(System.out).setPrefix("Castor");
    private boolean _logTime = false;
    private String _prefix = null;
    private boolean _newLine = true;

    public Logger(OutputStream outputStream) {
        super(outputStream, true);
    }

    public Logger(Writer writer) {
        super(writer, true);
    }

    public static PrintWriter getSystemLogger() {
        return _system;
    }

    public static void setSystemLogger(PrintWriter printWriter) {
        if (printWriter == null) {
            throw new NullPointerException("Argument 'system' is null");
        }
        _system = printWriter;
    }

    public Logger setPrefix(String string) {
        this._prefix = string != null && string.length() > 0 ? "[" + string + "] " : "";
        return this;
    }

    public Logger setLogTime(boolean bl) {
        this._logTime = bl;
        return this;
    }

    public void println() {
        super.println();
        this._newLine = true;
    }

    public void println(boolean bl) {
        this.prefixLine();
        super.print(bl);
        super.println();
        this._newLine = true;
    }

    public void print(boolean bl) {
        this.prefixLine();
        super.print(bl);
    }

    public void println(char c) {
        this.prefixLine();
        super.print(c);
        super.println();
        this._newLine = true;
    }

    public void print(char c) {
        this.prefixLine();
        super.print(c);
        this._newLine = c == '\n';
    }

    public void println(int n) {
        this.prefixLine();
        super.print(n);
        super.println();
        this._newLine = true;
    }

    public void print(int n) {
        this.prefixLine();
        super.print(n);
    }

    public void println(long l) {
        this.prefixLine();
        super.print(l);
        super.println();
        this._newLine = true;
    }

    public void print(long l) {
        this.prefixLine();
        super.print(l);
    }

    public void println(float f) {
        this.prefixLine();
        super.print(f);
        super.println();
        this._newLine = true;
    }

    public void print(float f) {
        this.prefixLine();
        super.print(f);
    }

    public void println(double d) {
        this.prefixLine();
        super.print(d);
        super.println();
        this._newLine = true;
    }

    public void print(double d) {
        this.prefixLine();
        super.print(d);
    }

    public void println(char[] cArray) {
        this.print(cArray);
        super.println();
        this._newLine = true;
    }

    public void print(char[] cArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < cArray.length) {
            if (cArray[n2] == '\n') {
                this.prefixLine();
                super.write(cArray, n, n2 - n);
                super.println();
                this._newLine = true;
                n = n2 + 1;
            }
            ++n2;
        }
        if (n2 > n) {
            this.prefixLine();
            super.write(cArray, n, n2 - n);
            this._newLine = false;
        }
    }

    public void println(String string) {
        this.print(string);
        super.println();
        this._newLine = true;
    }

    public void print(String string) {
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            if (string.charAt(n2) == '\n') {
                this.prefixLine();
                super.write(string, n, n2 - n);
                super.println();
                this._newLine = true;
                n = n2 + 1;
            }
            ++n2;
        }
        if (n2 > n) {
            this.prefixLine();
            super.write(string, n, n2 - n);
            this._newLine = false;
        }
    }

    public void println(Object object) {
        this.println(String.valueOf(object));
    }

    public void print(Object object) {
        this.prefixLine();
        this.println(String.valueOf(object));
    }

    protected final void prefixLine() {
        if (this._newLine) {
            if (this._logTime) {
                this.write(new Date().toString());
                this.write(32);
            }
            if (this._prefix != null) {
                this.write(this._prefix);
            }
        }
    }
}

