/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import org.exolab.castor.xml.AttributeSet;
import org.exolab.castor.xml.Namespaces;
import org.exolab.castor.xml.XMLException;
import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Form;
import org.exolab.castor.xml.schema.IdentityConstraint;
import org.exolab.castor.xml.schema.Resolver;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SchemaException;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.reader.AnnotationUnmarshaller;
import org.exolab.castor.xml.schema.reader.CharacterUnmarshaller;
import org.exolab.castor.xml.schema.reader.ComplexTypeUnmarshaller;
import org.exolab.castor.xml.schema.reader.ComponentReader;
import org.exolab.castor.xml.schema.reader.IdentityConstraintUnmarshaller;
import org.exolab.castor.xml.schema.reader.SimpleTypeUnmarshaller;

public class ElementUnmarshaller
extends ComponentReader {
    private static final String MAX_OCCURS_WILDCARD = "unbounded";
    private ComponentReader unmarshaller;
    private int depth = 0;
    private ElementDecl _element = null;
    private CharacterUnmarshaller charUnmarshaller = null;
    private Schema _schema = null;
    private boolean foundAnnotation = false;
    private boolean foundIdentityConstraint = false;
    private boolean foundSimpleType = false;
    private boolean foundComplexType = false;

    public ElementUnmarshaller(Schema schema, AttributeSet attributeSet, Resolver resolver) {
        this.setResolver(resolver);
        this._schema = schema;
        this._element = new ElementDecl(schema);
        String string = null;
        string = attributeSet.getValue("ref");
        if (string != null) {
            this._element.setReference(string);
        }
        this._element.setName(attributeSet.getValue("name"));
        string = attributeSet.getValue("abstract");
        if (string != null) {
            this._element.setAbstract(new Boolean(string));
        }
        this._element.setBlock(attributeSet.getValue("block"));
        string = attributeSet.getValue("default");
        if (string != null) {
            if (this._element.getFixedValue() != null) {
                throw new IllegalArgumentException("'default' and 'fixed' must not both be present.");
            }
            this._element.setDefaultValue(string);
        }
        this._element.setFinal(attributeSet.getValue("final"));
        string = attributeSet.getValue("fixed");
        if (string != null) {
            if (this._element.getDefaultValue() != null) {
                throw new IllegalArgumentException("'default' and 'fixed' must not both be present.");
            }
            this._element.setFixedValue(string);
        }
        if ((string = attributeSet.getValue("form")) != null) {
            this._element.setForm(Form.valueOf(string));
        }
        this._element.setId(attributeSet.getValue("id"));
        string = attributeSet.getValue("substitutionGroup");
        this._element.setSubstitutionGroup(string);
        string = attributeSet.getValue("type");
        if (string != null) {
            this._element.setTypeReference(string);
        }
        if ((string = attributeSet.getValue("nillable")) != null) {
            if (string.equals("true")) {
                this._element.setNillable(true);
            } else if (!string.equals("false")) {
                String string2 = "Invalid value for the 'nillable' attribute of an element definition: " + string;
                throw new IllegalArgumentException(string2);
            }
        }
        string = attributeSet.getValue("minOccurs");
        int n = 1;
        if (string != null) {
            n = ComponentReader.toInt(string);
            this._element.setMinOccurs(n);
        }
        if ((string = attributeSet.getValue("maxOccurs")) != null) {
            if (MAX_OCCURS_WILDCARD.equals(string)) {
                string = "-1";
            }
            int n2 = ComponentReader.toInt(string);
            this._element.setMaxOccurs(n2);
        } else if (n > 0) {
            this._element.setMaxOccurs(n);
        } else {
            this._element.setMaxOccurs(1);
        }
        this.charUnmarshaller = new CharacterUnmarshaller();
    }

    public String elementName() {
        return "element";
    }

    public ElementDecl getElement() {
        return this._element;
    }

    public Object getObject() {
        return this._element;
    }

    public void startElement(String string, String string2, AttributeSet attributeSet, Namespaces namespaces) throws XMLException {
        if (this.unmarshaller != null) {
            this.unmarshaller.startElement(string, string2, attributeSet, namespaces);
            ++this.depth;
            return;
        }
        if ("annotation".equals(string)) {
            if (this.foundSimpleType || this.foundIdentityConstraint || this.foundComplexType) {
                this.error("An annotation may only appear as the first child of an element definition.");
            }
            if (this.foundAnnotation) {
                this.error("Only one (1) 'annotation' is allowed as a child of element definitions.");
            }
            this.foundAnnotation = true;
            this.unmarshaller = new AnnotationUnmarshaller(attributeSet);
        } else if ("complexType".equals(string)) {
            if (this.foundComplexType) {
                this.error("Only one (1) 'complexType' may appear in an element definition.");
            }
            if (this.foundSimpleType) {
                this.error("Both 'simpleType' and 'complexType' cannot appear in the same element definition.");
            }
            if (this.foundIdentityConstraint) {
                this.error("A 'complexType' must appear before 'key', 'keyref' and 'unique' elements.");
            }
            this.foundComplexType = true;
            this.unmarshaller = new ComplexTypeUnmarshaller(this._schema, attributeSet, this.getResolver());
        } else if ("simpleType".equals(string)) {
            if (this.foundSimpleType) {
                this.error("Only one (1) 'simpleType' may appear in an element definition.");
            }
            if (this.foundComplexType) {
                this.error("Both 'simpleType' and 'complexType' cannot appear in the same element definition.");
            }
            if (this.foundIdentityConstraint) {
                this.error("A 'simpleType' must appear before 'key', 'keyref' and 'unique' elements.");
            }
            this.foundSimpleType = true;
            this.unmarshaller = new SimpleTypeUnmarshaller(this._schema, attributeSet);
        } else if ("key".equals(string) || "keyref".equals(string) || "unique".equals(string)) {
            this.foundIdentityConstraint = true;
            this.unmarshaller = new IdentityConstraintUnmarshaller(string, attributeSet);
        } else {
            this.illegalElement(string);
        }
        this.unmarshaller.setResolver(this.getResolver());
        this.unmarshaller.setDocumentLocator(this.getDocumentLocator());
    }

    public void endElement(String string, String string2) throws XMLException {
        if (this.unmarshaller != null && this.depth > 0) {
            this.unmarshaller.endElement(string, string2);
            --this.depth;
            return;
        }
        if (this.unmarshaller != null && this.charUnmarshaller != this.unmarshaller && !string.equals(this.unmarshaller.elementName())) {
            String string3 = "missing end element for ";
            string3 = string3 + this.unmarshaller.elementName();
            throw new SchemaException(string3);
        }
        this.unmarshaller.finish();
        if ("annotation".equals(string)) {
            Annotation annotation = (Annotation)this.unmarshaller.getObject();
            this._element.addAnnotation(annotation);
        } else if ("complexType".equals(string)) {
            ComplexType complexType = ((ComplexTypeUnmarshaller)this.unmarshaller).getComplexType();
            this._element.setType(complexType);
        } else if ("simpleType".equals(string)) {
            SimpleType simpleType = ((SimpleTypeUnmarshaller)this.unmarshaller).getSimpleType();
            this._element.setType(simpleType);
        } else if ("key".equals(string) || "keyref".equals(string) || "unique".equals(string)) {
            IdentityConstraint identityConstraint = (IdentityConstraint)this.unmarshaller.getObject();
            this._element.addIdentityConstraint(identityConstraint);
        }
        this.unmarshaller = null;
    }

    public void characters(char[] cArray, int n, int n2) throws XMLException {
        if (this.unmarshaller != null) {
            this.unmarshaller.characters(cArray, n, n2);
        }
    }
}

