/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import org.exolab.castor.xml.AttributeSet;
import org.exolab.castor.xml.Namespaces;
import org.exolab.castor.xml.XMLException;
import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.Resolver;
import org.exolab.castor.xml.schema.reader.AnnotationUnmarshaller;
import org.exolab.castor.xml.schema.reader.ComponentReader;
import org.exolab.castor.xml.schema.reader.ExtensionUnmarshaller;
import org.exolab.castor.xml.schema.reader.SimpleContentRestrictionUnmarshaller;

public class SimpleContentUnmarshaller
extends ComponentReader {
    private ComponentReader unmarshaller;
    private int depth = 0;
    private ComplexType _complexType = null;
    private boolean foundAnnotation = false;
    private boolean foundExtension = false;
    private boolean foundRestriction = false;

    public SimpleContentUnmarshaller(ComplexType complexType, AttributeSet attributeSet, Resolver resolver) throws XMLException {
        this._complexType = complexType;
        this.setResolver(resolver);
    }

    public String elementName() {
        return "simpleContent";
    }

    public Object getObject() {
        return null;
    }

    public void startElement(String string, String string2, AttributeSet attributeSet, Namespaces namespaces) throws XMLException {
        if (this.unmarshaller != null) {
            this.unmarshaller.startElement(string, string2, attributeSet, namespaces);
            ++this.depth;
            return;
        }
        if ("extension".equals(string)) {
            if (this.foundExtension) {
                this.error("Only (1) 'extension' element may appear as a child of 'simpleContent' elements.");
            }
            if (this.foundRestriction) {
                this.error("Both 'extension' and 'restriction' elements may not appear as children of the same simpleContent definition.");
            }
            this.foundExtension = true;
            this.unmarshaller = new ExtensionUnmarshaller(this._complexType, attributeSet, this.getResolver());
        } else if ("restriction".equals(string)) {
            if (this.foundRestriction) {
                this.error("Only (1) 'restriction' element may appear as a child of 'simpleContent' elements.");
            }
            if (this.foundExtension) {
                this.error("Both 'extension' and 'restriction' elements may not appear as children of the same simpleContent definition.");
            }
            this.foundRestriction = true;
            this.unmarshaller = new SimpleContentRestrictionUnmarshaller(this._complexType, attributeSet, this.getResolver());
        } else if (string.equals("annotation")) {
            if (this.foundAnnotation) {
                this.error("Only (1) 'annotation' element may appear as a child of 'simpleContent' elements.");
            }
            if (this.foundRestriction || this.foundExtension) {
                this.error("An 'annotation' may only appear as the first child of a 'simpleContent' element.");
            }
            this.foundAnnotation = true;
            this.unmarshaller = new AnnotationUnmarshaller(attributeSet);
        } else {
            this.illegalElement(string);
        }
        this.unmarshaller.setDocumentLocator(this.getDocumentLocator());
    }

    public void endElement(String string, String string2) throws XMLException {
        if (this.unmarshaller != null && this.depth > 0) {
            this.unmarshaller.endElement(string, string2);
            --this.depth;
            return;
        }
        this.unmarshaller.finish();
        if ("annotation".equals(string)) {
            Annotation annotation = ((AnnotationUnmarshaller)this.unmarshaller).getAnnotation();
            this._complexType.addAnnotation(annotation);
        }
        this.unmarshaller = null;
    }

    public void characters(char[] cArray, int n, int n2) throws XMLException {
        if (this.unmarshaller != null) {
            this.unmarshaller.characters(cArray, n, n2);
        }
    }
}

