/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import java.util.StringTokenizer;
import org.exolab.castor.xml.AttributeSet;
import org.exolab.castor.xml.Namespaces;
import org.exolab.castor.xml.XMLException;
import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.AttributeGroup;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.Resolver;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SchemaException;
import org.exolab.castor.xml.schema.SchemaNames;
import org.exolab.castor.xml.schema.Wildcard;
import org.exolab.castor.xml.schema.reader.AnnotationUnmarshaller;
import org.exolab.castor.xml.schema.reader.ComponentReader;

public class WildcardUnmarshaller
extends ComponentReader {
    private static final String MAX_OCCURS_WILDCARD = "unbounded";
    private ComponentReader unmarshaller;
    private int depth = 0;
    private Wildcard _wildcard = null;
    private Schema _schema = null;
    private String _element = "any";

    public WildcardUnmarshaller(ComplexType complexType, Schema schema, String string, AttributeSet attributeSet, Resolver resolver) {
        this._wildcard = new Wildcard(complexType);
        this.init(schema, string, attributeSet, resolver);
    }

    public WildcardUnmarshaller(Group group, Schema schema, String string, AttributeSet attributeSet, Resolver resolver) {
        this._wildcard = new Wildcard(group);
        this.init(schema, string, attributeSet, resolver);
    }

    public WildcardUnmarshaller(AttributeGroup attributeGroup, Schema schema, String string, AttributeSet attributeSet, Resolver resolver) {
        this._wildcard = new Wildcard(attributeGroup);
        this.init(schema, string, attributeSet, resolver);
    }

    public void init(Schema schema, String string, AttributeSet attributeSet, Resolver resolver) {
        this.setResolver(resolver);
        this._schema = schema;
        this._element = string;
        String string2 = null;
        if ("anyAttribute".equals(string)) {
            this._wildcard.setAttributeWildcard();
        }
        this._element = string;
        string2 = attributeSet.getValue("namespace");
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (stringTokenizer.countTokens() > 1 && ("##any".equals(string3) || "##other".equals(string3))) {
                    throw new IllegalArgumentException(string3 + " is not valid when multiple namespaces are listed.");
                }
                if (SchemaNames.isNamespaceName(string3)) {
                    this._wildcard.addNamespace(string3);
                    continue;
                }
                String string4 = "Invalid 'namespace' value: " + string3;
                throw new IllegalArgumentException(string4);
            }
        } else {
            this._wildcard.addNamespace("any");
        }
        string2 = attributeSet.getValue("maxOccurs");
        if (string2 != null) {
            if (this._wildcard.isAttributeWildcard()) {
                throw new IllegalStateException("'maxOccurs' is prohibited on a <anyAttribute> element.");
            }
            if (MAX_OCCURS_WILDCARD.equals(string2)) {
                string2 = "-1";
            }
            int n = ComponentReader.toInt(string2);
            this._wildcard.setMaxOccurs(n);
        }
        if ((string2 = attributeSet.getValue("minOccurs")) != null) {
            if (this._wildcard.isAttributeWildcard()) {
                throw new IllegalStateException("'minOccurs' is prohibited on a <anyAttribute> element.");
            }
            this._wildcard.setMinOccurs(ComponentReader.toInt(string2));
        }
        if ((string2 = attributeSet.getValue("processContents")) != null) {
            try {
                this._wildcard.setProcessContents(string2);
            }
            catch (SchemaException schemaException) {
                throw new IllegalArgumentException(schemaException.getMessage());
            }
        }
        this._wildcard.setId(attributeSet.getValue("id"));
    }

    public String elementName() {
        return this._element;
    }

    public Wildcard getWildcard() {
        return this._wildcard;
    }

    public Object getObject() {
        return this.getWildcard();
    }

    public void startElement(String string, String string2, AttributeSet attributeSet, Namespaces namespaces) throws XMLException {
        if (this.unmarshaller != null) {
            this.unmarshaller.startElement(string, string2, attributeSet, namespaces);
            ++this.depth;
            return;
        }
        if (!"annotation".equals(string)) {
            StringBuffer stringBuffer = new StringBuffer("illegal element <");
            stringBuffer.append(string);
            stringBuffer.append("> found in <");
            stringBuffer.append(this._element);
            stringBuffer.append(">");
            throw new SchemaException(stringBuffer.toString());
        }
        this.unmarshaller = new AnnotationUnmarshaller(attributeSet);
    }

    public void endElement(String string, String string2) throws XMLException {
        if (this.unmarshaller != null && this.depth > 0) {
            this.unmarshaller.endElement(string, string2);
            --this.depth;
            return;
        }
        if (this.unmarshaller != null && !string.equals(this.unmarshaller.elementName())) {
            String string3 = "missing end element for ";
            string3 = string3 + this.unmarshaller.elementName();
            throw new SchemaException(string3);
        }
        this.unmarshaller.finish();
        if (string == "annotation") {
            this._schema.addAnnotation((Annotation)this.unmarshaller.getObject());
        }
        this.unmarshaller = null;
    }

    public void characters(char[] cArray, int n, int n2) throws XMLException {
        if (this.unmarshaller != null) {
            this.unmarshaller.characters(cArray, n, n2);
        }
    }
}

