/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.util;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.exolab.castor.xml.Namespaces;
import org.exolab.castor.xml.schema.Annotated;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.ContentType;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.Order;
import org.exolab.castor.xml.schema.Particle;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SchemaException;
import org.exolab.castor.xml.schema.XMLType;
import org.exolab.castor.xml.schema.util.DatatypeHandler;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class XMLInstance2SchemaHandler
implements DocumentHandler,
ErrorHandler {
    private static final String XMLNS = "xmlns";
    private static final String DEFAULT_PREFIX = "xsd";
    private Locator _locator = null;
    private Schema _schema = null;
    private Stack _siStack = null;
    private String _nsPrefix = null;
    private Order _defaultGroupOrder = Order.seq;

    public XMLInstance2SchemaHandler() {
        this(null);
    }

    public XMLInstance2SchemaHandler(Schema schema) {
        this._siStack = new Stack();
        this._schema = schema;
        if (this._schema == null) {
            this._schema = new Schema();
            this._schema.addNamespace(DEFAULT_PREFIX, "http://www.w3.org/2001/XMLSchema");
            this._nsPrefix = DEFAULT_PREFIX;
        } else {
            this._nsPrefix = null;
            Hashtable hashtable = this._schema.getNamespaces();
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (!hashtable.get(string).equals("http://www.w3.org/2001/XMLSchema")) continue;
                this._nsPrefix = string;
                break;
            }
            if (this._nsPrefix == null) {
                this._schema.addNamespace(DEFAULT_PREFIX, "http://www.w3.org/2001/XMLSchema");
                this._nsPrefix = DEFAULT_PREFIX;
            }
        }
    }

    public Schema getSchema() {
        return this._schema;
    }

    protected void setDefaultGroupOrder(Order order) {
        this._defaultGroupOrder = order;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this._siStack.isEmpty()) {
            return;
        }
        StateInfo stateInfo = (StateInfo)this._siStack.peek();
        if (stateInfo.buffer == null) {
            stateInfo.buffer = new StringBuffer();
        }
        stateInfo.buffer.append(cArray, n, n2);
        if (stateInfo.complex) {
            stateInfo.mixed = true;
        }
    }

    public void endDocument() throws SAXException {
    }

    public void endElement(String string) throws SAXException {
        Annotated annotated;
        Object object;
        int n = string.indexOf(58);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        StateInfo stateInfo = (StateInfo)this._siStack.pop();
        if (stateInfo.element.getType() == null && stateInfo.buffer != null) {
            object = this._nsPrefix + ':' + DatatypeHandler.guessType(stateInfo.buffer.toString());
            stateInfo.element.setTypeReference((String)object);
            if (stateInfo.attributes.size() > 0) {
                ComplexType complexType = new ComplexType(this._schema);
                complexType.setContentType(ContentType.mixed);
                stateInfo.element.setType(complexType);
                annotated = new Group();
                ((Group)annotated).setOrder(this._defaultGroupOrder);
                try {
                    complexType.addGroup((Group)annotated);
                    int n2 = 0;
                    while (n2 < stateInfo.attributes.size()) {
                        AttributeDecl attributeDecl = (AttributeDecl)stateInfo.attributes.elementAt(n2);
                        complexType.addAttributeDecl(attributeDecl);
                        ++n2;
                    }
                }
                catch (SchemaException schemaException) {
                    throw new SAXException(schemaException);
                }
            }
        } else {
            object = (ComplexType)stateInfo.element.getType();
            if (object != null) {
                try {
                    int n3 = 0;
                    while (n3 < stateInfo.attributes.size()) {
                        annotated = (AttributeDecl)stateInfo.attributes.elementAt(n3);
                        ((ComplexType)object).addAttributeDecl((AttributeDecl)annotated);
                        ++n3;
                    }
                }
                catch (SchemaException schemaException) {
                    throw new SAXException(schemaException);
                }
            }
        }
        if (!this._siStack.isEmpty()) {
            object = (StateInfo)this._siStack.peek();
            ComplexType complexType = (ComplexType)((StateInfo)object).element.getType();
            annotated = null;
            if (complexType == null) {
                ((StateInfo)object).complex = true;
                complexType = new ComplexType(this._schema);
                ((StateInfo)object).element.setType(complexType);
                annotated = new Group();
                ((Group)annotated).setOrder(this._defaultGroupOrder);
                try {
                    complexType.addGroup((Group)annotated);
                    ((Group)annotated).addElementDecl(stateInfo.element);
                }
                catch (SchemaException schemaException) {
                    throw new SAXException(schemaException);
                }
            }
            annotated = (Group)complexType.getParticle(0);
            ElementDecl elementDecl = ((Group)annotated).getElementDecl(string);
            boolean bl = false;
            if (elementDecl != null) {
                if (stateInfo.complex) {
                    try {
                        this.merge(elementDecl, stateInfo.element);
                    }
                    catch (SchemaException schemaException) {
                        throw new SAXException(schemaException);
                    }
                }
                elementDecl.setMaxOccurs(Particle.UNBOUNDED);
                bl = true;
            } else {
                try {
                    ((Group)annotated).addElementDecl(stateInfo.element);
                }
                catch (SchemaException schemaException) {
                    throw new SAXException(schemaException);
                }
            }
            if (bl && ((Group)annotated).getOrder() == Order.seq) {
                boolean bl2 = false;
                boolean bl3 = false;
                int n4 = 0;
                while (n4 < ((Group)annotated).getParticleCount()) {
                    if (bl2) {
                        bl3 = true;
                        break;
                    }
                    if (elementDecl == ((Group)annotated).getParticle(n4)) {
                        bl2 = true;
                    }
                    ++n4;
                }
                if (bl3) {
                    ((Group)annotated).setOrder(Order.all);
                }
            }
        } else {
            try {
                this._schema.addElementDecl(stateInfo.element);
            }
            catch (SchemaException schemaException) {
                throw new SAXException(schemaException);
            }
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public void processingInstruction(String string, String string2) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
        this._locator = locator;
    }

    public void startDocument() throws SAXException {
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        int n = string.indexOf(58);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        StateInfo stateInfo = null;
        boolean bl = false;
        if (!this._siStack.isEmpty()) {
            stateInfo = (StateInfo)this._siStack.peek();
            stateInfo.complex = true;
        } else {
            bl = true;
        }
        stateInfo = new StateInfo();
        stateInfo.topLevel = bl;
        this._siStack.push(stateInfo);
        stateInfo.element = new ElementDecl(this._schema, string);
        int n2 = 0;
        while (n2 < attributeList.getLength()) {
            String string2 = attributeList.getName(n2);
            if (!string2.equals(XMLNS)) {
                String string3 = "";
                n = string2.indexOf(58);
                if (n >= 0) {
                    string3 = string2.substring(0, n);
                    string2 = string2.substring(n + 1);
                }
                if (!string3.equals(XMLNS)) {
                    AttributeDecl attributeDecl = new AttributeDecl(this._schema, string2);
                    String string4 = this._nsPrefix + ':' + DatatypeHandler.guessType(attributeList.getValue(n2));
                    attributeDecl.setSimpleTypeReference(string4);
                    stateInfo.attributes.addElement(attributeDecl);
                }
            }
            ++n2;
        }
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    private static boolean isWhiteSpace(char[] cArray, int n, int n2) {
        int n3 = n + n2;
        int n4 = n;
        while (n4 < n3) {
            char c = cArray[n4];
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    break;
                }
                default: {
                    return false;
                }
            }
            ++n4;
        }
        return true;
    }

    private void merge(ElementDecl elementDecl, ElementDecl elementDecl2) throws SchemaException {
        Annotated annotated;
        Object object;
        Annotated annotated2;
        Group group;
        Annotated annotated3;
        Object object2;
        Object object3 = elementDecl.getType();
        Object object4 = elementDecl2.getType();
        if (object3 == null) {
            if (object4 == null) {
                return;
            }
            if (((XMLType)object4).isSimpleType()) {
                elementDecl.setType((XMLType)object4);
            } else {
                object2 = new ComplexType(this._schema);
                annotated3 = new Group();
                ((Group)annotated3).setOrder(this._defaultGroupOrder);
                ((ComplexType)object2).addGroup((Group)annotated3);
                elementDecl.setType((XMLType)object2);
                object3 = object2;
            }
        } else if (object4 == null) {
            if (((XMLType)object3).isSimpleType()) {
                elementDecl2.setType((XMLType)object3);
            } else {
                object2 = new ComplexType(this._schema);
                annotated3 = new Group();
                ((Group)annotated3).setOrder(this._defaultGroupOrder);
                ((ComplexType)object2).addGroup((Group)annotated3);
                elementDecl2.setType((XMLType)object2);
                object4 = object2;
            }
        }
        if (((XMLType)object3).isSimpleType() && ((XMLType)object4).isSimpleType()) {
            if (!((XMLType)object3).getName().equals(((XMLType)object4).getName())) {
                object2 = this._nsPrefix + ':' + DatatypeHandler.whichType(((XMLType)object3).getName(), ((XMLType)object4).getName());
                elementDecl.setType(null);
                elementDecl.setTypeReference((String)object2);
            }
            return;
        }
        if (((XMLType)object3).isSimpleType()) {
            object2 = new ComplexType(this._schema);
            elementDecl.setType((XMLType)object2);
            annotated3 = new Group();
            ((Group)annotated3).setOrder(this._defaultGroupOrder);
            ((ComplexType)object2).addGroup((Group)annotated3);
            ((ComplexType)object2).setContentType(ContentType.mixed);
            object3 = object2;
        } else if (((XMLType)object4).isSimpleType()) {
            object2 = new ComplexType(this._schema);
            elementDecl2.setType((XMLType)object2);
            annotated3 = new Group();
            ((Group)annotated3).setOrder(this._defaultGroupOrder);
            ((ComplexType)object2).addGroup((Group)annotated3);
            ((ComplexType)object2).setContentType(ContentType.mixed);
            object4 = object2;
        }
        object2 = (ComplexType)object3;
        annotated3 = (ComplexType)object4;
        Group group2 = (Group)((ComplexType)object2).getParticle(0);
        if (group2 == null) {
            group2 = new Group();
            group2.setOrder(this._defaultGroupOrder);
            ((ComplexType)object2).addGroup(group2);
        }
        if ((group = (Group)((ComplexType)annotated3).getParticle(0)) == null) {
            group = new Group();
            group.setOrder(this._defaultGroupOrder);
            ((ComplexType)annotated3).addGroup(group);
        }
        Enumeration enumeration = group.enumerate();
        while (enumeration.hasMoreElements()) {
            annotated2 = (Particle)enumeration.nextElement();
            if (annotated2.getStructureType() != 8) continue;
            object = (ElementDecl)annotated2;
            annotated = group2.getElementDecl(((ElementDecl)object).getName());
            if (annotated == null) {
                group2.addElementDecl((ElementDecl)object);
                ((Particle)object).setMinOccurs(0);
                continue;
            }
            this.merge((ElementDecl)annotated, (ElementDecl)object);
        }
        enumeration = ((ComplexType)annotated3).getAttributeDecls();
        while (enumeration.hasMoreElements()) {
            String string;
            annotated2 = (AttributeDecl)enumeration.nextElement();
            object = ((AttributeDecl)annotated2).getName();
            annotated = ((ComplexType)object2).getAttributeDecl((String)object);
            if (annotated == null) {
                ((AttributeDecl)annotated2).setUse("optional");
                ((ComplexType)object2).addAttributeDecl((AttributeDecl)annotated2);
                continue;
            }
            String string2 = ((AttributeDecl)annotated).getSimpleType().getName();
            if (string2.equals(string = ((AttributeDecl)annotated2).getSimpleType().getName())) continue;
            String string3 = this._nsPrefix + ':' + DatatypeHandler.whichType(string2, string);
            ((AttributeDecl)annotated).setSimpleTypeReference(string3);
        }
        enumeration = group2.enumerate();
        while (enumeration.hasMoreElements()) {
            annotated2 = (Particle)enumeration.nextElement();
            if (annotated2.getStructureType() != 8 || group.getElementDecl(((ElementDecl)(object = (ElementDecl)annotated2)).getName()) != null) continue;
            ((Particle)object).setMinOccurs(0);
        }
    }

    class StateInfo {
        Namespaces namespaces = null;
        ElementDecl element = null;
        Vector attributes = new Vector();
        StringBuffer buffer = null;
        boolean mixed = false;
        boolean complex = false;
        boolean topLevel = false;
    }
}

