/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.validators;

import org.exolab.castor.xml.TypeValidator;
import org.exolab.castor.xml.ValidationContext;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.validators.PatternValidator;

public class StringValidator
extends PatternValidator
implements TypeValidator {
    private static final String PRESERVE = "preserve";
    private static final String REPLACE = "replace";
    private static final String COLLAPSE = "collapse";
    private String fixed = null;
    private boolean required = false;
    private int _length = 0;
    private int minLength = 0;
    private int maxLength = -1;
    private String _whiteSpace = "preserve";

    public void setFixed(String string) {
        this.fixed = string;
    }

    public void setFixedValue(String string) {
        this.setFixed(string);
    }

    public void setMaxLength(int n) {
        this.maxLength = n;
    }

    public void setMinLength(int n) {
        this.minLength = n;
    }

    public void setLength(int n) {
        this._length = n;
        this.setMaxLength(n);
        this.setMinLength(n);
    }

    public void setRequired(boolean bl) {
        this.required = bl;
    }

    public void setWhiteSpace(String string) {
        if (string.equals(PRESERVE)) {
            this._whiteSpace = string;
        } else if (string.equals(REPLACE)) {
            this._whiteSpace = string;
        } else if (string.equals(COLLAPSE)) {
            this._whiteSpace = string;
        } else {
            System.out.println("Warning : " + string + " is a bad entry for the whiteSpace value");
            this._whiteSpace = string;
        }
    }

    public String normalize(String string) {
        if (string == null) {
            return null;
        }
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            switch (cArray[n2]) {
                case '\t': 
                case '\n': 
                case '\r': {
                    cArray[n2] = 32;
                    break;
                }
            }
            ++n2;
        }
        if (this._whiteSpace.equals(COLLAPSE)) {
            char[] cArray2 = new char[cArray.length];
            int n3 = 0;
            int n4 = 0;
            while (n4 < n - 1) {
                if (cArray[n4] == ' ') {
                    cArray2[n3] = cArray[n4];
                    ++n3;
                    ++n4;
                    while (n4 < n - 1 && cArray[n4] == ' ') {
                        ++n4;
                    }
                    continue;
                }
                cArray2[n3] = cArray[n4];
                ++n3;
                ++n4;
            }
            if (cArray[n4] != ' ') {
                cArray2[n3] = cArray[n4];
            }
            n = ++n3;
            cArray = cArray2;
        }
        return new String(cArray, 0, n);
    }

    public void validate(String string, ValidationContext validationContext) throws ValidationException {
        if (string == null) {
            if (this.required) {
                String string2 = "this is a required field and cannot be null.";
                throw new ValidationException(string2);
            }
        } else {
            if (this.fixed != null && !this.fixed.equals(string)) {
                String string3 = "strings of this type must be equal to the fixed value of " + this.fixed;
                throw new ValidationException(string3);
            }
            int n = string.length();
            if (this._length > 0 && n != this._length) {
                String string4 = "strings of this type must have a length of " + this._length;
                throw new ValidationException(string4);
            }
            if (this.minLength > 0 && n < this.minLength) {
                String string5 = "strings of this type must have a minimum length of " + this.minLength;
                throw new ValidationException(string5);
            }
            if (this.maxLength >= 0 && n > this.maxLength) {
                String string6 = "strings of this type must have a maximum length of " + this.maxLength;
                throw new ValidationException(string6);
            }
            if (this.hasPattern()) {
                super.validate(string, validationContext);
            }
            if (!this._whiteSpace.equals(PRESERVE)) {
                this.normalize(string);
            }
        }
    }

    public void validate(Object object, ValidationContext validationContext) throws ValidationException {
        if (object == null) {
            if (this.required) {
                String string = "this is a required field and cannot be null.";
                throw new ValidationException(string);
            }
        } else {
            this.validate(object.toString(), validationContext);
        }
    }
}

