/*
 * Decompiled with CFR 0.152.
 */
package fi.iki.jka;

import fi.iki.jka.JPhoto;
import fi.iki.jka.JPhotoCollection;
import fi.iki.jka.JPhotoPanel;
import fi.iki.jka.JPhotoTransferHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JPhotoList
extends JList {
    public static final int THUMB_WIDTH = 165;
    public static final int THUMB_HEIGHT = 165;
    JPhotoCollection photos = null;
    int dragbegin = -1;
    Dimension viewBounds;
    boolean fullView = false;
    JPhotoPanel cellRenderer = new JPhotoPanel();

    public JPhotoList(JPhotoCollection photos, int width) {
        super(photos);
        this.photos = photos;
        this.setCellRenderer(this.cellRenderer);
        this.setFixedCellWidth(165);
        this.setFixedCellHeight(165);
        this.setForeground(photos.getForegroundColor());
        this.setBackground(photos.getBackgroundColor());
        this.setLayoutOrientation(2);
        Dimension dim = new Dimension(width, 165 * this.getModel().getSize());
        this.setVisibleBounds(dim);
        this.setSelectedIndex(0);
    }

    public JPhotoCollection getPhotoModel() {
        return this.photos;
    }

    public void setPhotoModel(JPhotoCollection newPhotos) {
        this.photos = newPhotos;
        super.setModel(newPhotos);
    }

    public int moveSelection(int delta) {
        int sel = this.getSelectedIndex();
        int max = this.photos.getSize() - 1;
        if ((sel += delta) < 0) {
            sel = max;
        }
        if (sel > max) {
            sel = 0;
        }
        this.setSelectedIndex(sel);
        this.ensureIndexIsVisible(sel);
        return sel;
    }

    public void setForeground(Color fg) {
        if (this.cellRenderer != null) {
            this.cellRenderer.setForeground(fg);
        }
        super.setForeground(fg);
    }

    public void setBackground(Color bg) {
        if (this.cellRenderer != null) {
            this.cellRenderer.setBackground(bg);
        }
        super.setBackground(bg);
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.viewBounds;
    }

    public void setVisibleBounds(Dimension dim) {
        if (dim.width == 0) {
            return;
        }
        this.viewBounds = dim;
        this.recalculateVisibleRows();
    }

    public void recalculateVisibleRows() {
        int total = this.getModel().getSize();
        int rows = 1;
        if (this.fullView) {
            this.setFixedCellWidth(this.viewBounds.width);
            this.setFixedCellHeight(this.viewBounds.height);
            rows = total;
        } else if (total > 0) {
            int visibleRows;
            this.setFixedCellWidth(165);
            this.setFixedCellHeight(165);
            int visibleColumns = this.viewBounds.width / this.getFixedCellWidth();
            if (visibleColumns <= 0) {
                visibleColumns = 1;
            }
            if ((visibleRows = this.viewBounds.height / this.getFixedCellHeight()) <= 0) {
                visibleRows = 1;
            }
            rows = total / visibleColumns + (total % visibleColumns > 0 ? 1 : 0);
        }
        if (rows != this.getVisibleRowCount()) {
            this.setVisibleRowCount(rows);
        }
        this.ensureIndexIsVisible(this.getSelectedIndex());
    }

    public void setDragBegin(int val) {
        this.dragbegin = val;
    }

    public int getDragBegin() {
        return this.dragbegin;
    }

    public void toggleFullView() {
        this.fullView = !this.fullView;
        this.cellRenderer.setFullView(this.fullView);
        this.recalculateVisibleRows();
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Thumbs");
        frame.setDefaultCloseOperation(3);
        Container contentPane = frame.getContentPane();
        frame.setSize(200, 700);
        JFrame picFrame = new JFrame("Selected");
        Container picPane = picFrame.getContentPane();
        JPhotoPanel selected = new JPhotoPanel(true);
        picPane.add(selected);
        picFrame.setSize(700, 700);
        picFrame.setLocation(250, 0);
        JPhotoList list = new JPhotoList(new JPhotoCollection(args), 200);
        list.setTransferHandler(new JPhotoTransferHandler(list));
        list.setDragEnabled(true);
        selected.setPhoto((JPhoto)list.getSelectedValue());
        JScrollPane scrollPane = new JScrollPane(list);
        contentPane.add((Component)scrollPane, "Center");
        list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
            }
        });
        frame.show();
    }
}

