/*
 * Decompiled with CFR 0.152.
 */
package com.drew.lang.test;

import com.drew.lang.CompoundException;
import java.io.IOException;
import java.io.PrintWriter;
import junit.framework.TestCase;

public class CompoundExceptionTest
extends TestCase {
    public CompoundExceptionTest(String string) {
        super(string);
    }

    public void testUnnestedGetMessage() throws Exception {
        try {
            throw new CompoundException("message");
        }
        catch (CompoundException compoundException) {
            CompoundExceptionTest.assertEquals((String)"message", (String)compoundException.getMessage());
            return;
        }
    }

    public void testNestedGetMessage() throws Exception {
        try {
            try {
                throw new IOException("io");
            }
            catch (IOException iOException) {
                throw new CompoundException("compound", iOException);
            }
        }
        catch (CompoundException compoundException) {
            CompoundExceptionTest.assertEquals((String)"compound", (String)compoundException.getMessage());
            CompoundExceptionTest.assertEquals((String)"io", (String)compoundException.getInnerException().getMessage());
            return;
        }
    }

    public void testNoInnerException() throws Exception {
        try {
            throw new CompoundException("message", null);
        }
        catch (CompoundException compoundException) {
            try {
                compoundException.printStackTrace();
                compoundException.printStackTrace(System.err);
                compoundException.printStackTrace(new PrintWriter(System.err));
            }
            catch (Exception exception) {
                CompoundExceptionTest.fail((String)"Exception during printStackTrace for CompoundException with no inner exception");
            }
            return;
        }
    }
}

