/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif.test;

import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.imaging.jpeg.JpegSegmentReader;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.ExifDirectory;
import java.io.File;
import junit.framework.TestCase;

public class ExifDirectoryTest
extends TestCase {
    static /* synthetic */ Class class$com$drew$metadata$exif$ExifDirectory;

    public ExifDirectoryTest(String string) {
        super(string);
    }

    public void testGetDirectoryName() throws Exception {
        Metadata metadata = new Metadata();
        Directory directory = metadata.getDirectory(class$com$drew$metadata$exif$ExifDirectory == null ? (class$com$drew$metadata$exif$ExifDirectory = ExifDirectoryTest.class$("com.drew.metadata.exif.ExifDirectory")) : class$com$drew$metadata$exif$ExifDirectory);
        ExifDirectoryTest.assertEquals((String)"Exif", (String)directory.getName());
    }

    public void testGetThumbnailData() throws Exception {
        File file = new File("src/com/drew/metadata/exif/test/withExif.jpg");
        Metadata metadata = JpegMetadataReader.readMetadata(file);
        ExifDirectory exifDirectory = (ExifDirectory)metadata.getDirectory(class$com$drew$metadata$exif$ExifDirectory == null ? (class$com$drew$metadata$exif$ExifDirectory = ExifDirectoryTest.class$("com.drew.metadata.exif.ExifDirectory")) : class$com$drew$metadata$exif$ExifDirectory);
        ExifDirectoryTest.assertTrue((boolean)exifDirectory.containsTag(61441));
        byte[] byArray = exifDirectory.getThumbnailData();
        try {
            new JpegSegmentReader(byArray);
        }
        catch (JpegProcessingException jpegProcessingException) {
            ExifDirectoryTest.fail((String)"Unable to construct JpegSegmentReader from thumbnail data");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWriteThumbnail() throws Exception {
        File file = new File("src/com/drew/metadata/exif/test/manuallyAddedThumbnail.jpg");
        Metadata metadata = JpegMetadataReader.readMetadata(file);
        ExifDirectory exifDirectory = (ExifDirectory)metadata.getDirectory(class$com$drew$metadata$exif$ExifDirectory == null ? (class$com$drew$metadata$exif$ExifDirectory = ExifDirectoryTest.class$("com.drew.metadata.exif.ExifDirectory")) : class$com$drew$metadata$exif$ExifDirectory);
        ExifDirectoryTest.assertTrue((boolean)exifDirectory.containsTag(61441));
        File file2 = File.createTempFile("thumbnail", ".jpg");
        try {
            exifDirectory.writeThumbnail(file2.getAbsolutePath());
            ExifDirectoryTest.assertTrue((boolean)new File(file2.getAbsolutePath()).exists());
        }
        finally {
            file2.delete();
        }
    }

    public void testContainsThumbnail() {
        ExifDirectory exifDirectory = new ExifDirectory();
        ExifDirectoryTest.assertTrue((!exifDirectory.containsThumbnail() ? 1 : 0) != 0);
        exifDirectory.setObject(61441, "foo");
        ExifDirectoryTest.assertTrue((boolean)exifDirectory.containsThumbnail());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

