/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif.test;

import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.exif.NikonType3MakernoteDescriptor;
import com.drew.metadata.exif.NikonType3MakernoteDirectory;
import java.io.File;
import junit.framework.TestCase;

public class NikonType3MakernoteTest
extends TestCase {
    private NikonType3MakernoteDirectory _nikonDirectory;
    private NikonType3MakernoteDescriptor _descriptor;
    static /* synthetic */ Class class$com$drew$metadata$exif$NikonType3MakernoteDirectory;

    public NikonType3MakernoteTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        File file = new File("src/com/drew/metadata/exif/test/nikonMakernoteType3.jpg");
        Metadata metadata = JpegMetadataReader.readMetadata(file);
        this._nikonDirectory = (NikonType3MakernoteDirectory)metadata.getDirectory(class$com$drew$metadata$exif$NikonType3MakernoteDirectory == null ? (class$com$drew$metadata$exif$NikonType3MakernoteDirectory = NikonType3MakernoteTest.class$("com.drew.metadata.exif.NikonType3MakernoteDirectory")) : class$com$drew$metadata$exif$NikonType3MakernoteDirectory);
        this._descriptor = new NikonType3MakernoteDescriptor(this._nikonDirectory);
    }

    public void testNikonMakernote_MatchesKnownValues() throws Exception {
        NikonType3MakernoteTest.assertEquals((String)"0200", (String)this._nikonDirectory.getString(1));
        NikonType3MakernoteTest.assertEquals((String)"0 320", (String)this._nikonDirectory.getString(2));
        NikonType3MakernoteTest.assertEquals((String)"0 320", (String)this._nikonDirectory.getString(19));
        NikonType3MakernoteTest.assertEquals((String)"FLASH       ", (String)this._nikonDirectory.getString(5));
        NikonType3MakernoteTest.assertEquals((String)"AUTO  ", (String)this._nikonDirectory.getString(6));
        NikonType3MakernoteTest.assertEquals((String)"AF-C  ", (String)this._nikonDirectory.getString(7));
        NikonType3MakernoteTest.assertEquals((String)"NORMAL      ", (String)this._nikonDirectory.getString(8));
        NikonType3MakernoteTest.assertEquals((String)"0", (String)this._nikonDirectory.getString(11));
        NikonType3MakernoteTest.assertEquals((String)"914", (String)this._nikonDirectory.getString(17));
        NikonType3MakernoteTest.assertEquals((String)"AUTO    ", (String)this._nikonDirectory.getString(129));
        NikonType3MakernoteTest.assertEquals((String)"6", (String)this._nikonDirectory.getString(131));
        NikonType3MakernoteTest.assertEquals((String)"240/10 850/10 35/10 45/10", (String)this._nikonDirectory.getString(132));
        NikonType3MakernoteTest.assertEquals((String)"0", (String)this._nikonDirectory.getString(135));
        NikonType3MakernoteTest.assertEquals((String)"1", (String)this._nikonDirectory.getString(137));
        NikonType3MakernoteTest.assertEquals((String)"0", (String)this._nikonDirectory.getString(138));
        NikonType3MakernoteTest.assertEquals((String)"MODE1   ", (String)this._nikonDirectory.getString(141));
        NikonType3MakernoteTest.assertEquals((String)"NATURAL    ", (String)this._nikonDirectory.getString(144));
        NikonType3MakernoteTest.assertEquals((String)"0", (String)this._nikonDirectory.getString(146));
        NikonType3MakernoteTest.assertEquals((String)"OFF ", (String)this._nikonDirectory.getString(149));
        NikonType3MakernoteTest.assertEquals((String)"78/10 78/10", (String)this._nikonDirectory.getString(154));
    }

    public void testGetLensDescription() throws MetadataException {
        NikonType3MakernoteTest.assertEquals((String)"24-85mm f/3.5-4.5", (String)this._descriptor.getDescription(132));
        NikonType3MakernoteTest.assertEquals((String)"24-85mm f/3.5-4.5", (String)this._descriptor.getLensDescription());
    }

    public void testGetHueAdjustmentDescription() throws MetadataException {
        NikonType3MakernoteTest.assertEquals((String)"0 degrees", (String)this._descriptor.getDescription(146));
        NikonType3MakernoteTest.assertEquals((String)"0 degrees", (String)this._descriptor.getHueAdjustmentDescription());
    }

    public void testGetColorModeDescription() throws Exception {
        NikonType3MakernoteTest.assertEquals((String)"Mode I (sRGB)", (String)this._descriptor.getDescription(141));
        NikonType3MakernoteTest.assertEquals((String)"Mode I (sRGB)", (String)this._descriptor.getColorModeDescription());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

