/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.jpeg.test;

import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.metadata.Metadata;
import com.drew.metadata.jpeg.JpegComponent;
import com.drew.metadata.jpeg.JpegDirectory;
import com.drew.metadata.jpeg.JpegReader;
import java.io.File;
import java.io.FileNotFoundException;
import junit.framework.TestCase;

public class JpegReaderTest
extends TestCase {
    private JpegDirectory _directory;
    static /* synthetic */ Class class$com$drew$metadata$jpeg$JpegDirectory;

    public JpegReaderTest(String string) {
        super(string);
    }

    public void setUp() throws JpegProcessingException, FileNotFoundException {
        File file = new File("src/com/drew/metadata/jpeg/test/simple.jpg");
        JpegReader jpegReader = new JpegReader(file);
        Metadata metadata = jpegReader.extract();
        JpegReaderTest.assertTrue((boolean)metadata.containsDirectory(class$com$drew$metadata$jpeg$JpegDirectory == null ? (class$com$drew$metadata$jpeg$JpegDirectory = JpegReaderTest.class$("com.drew.metadata.jpeg.JpegDirectory")) : class$com$drew$metadata$jpeg$JpegDirectory));
        this._directory = (JpegDirectory)metadata.getDirectory(class$com$drew$metadata$jpeg$JpegDirectory == null ? (class$com$drew$metadata$jpeg$JpegDirectory = JpegReaderTest.class$("com.drew.metadata.jpeg.JpegDirectory")) : class$com$drew$metadata$jpeg$JpegDirectory);
    }

    public void testExtract_Width() throws Exception {
        JpegReaderTest.assertEquals((int)800, (int)this._directory.getInt(3));
    }

    public void testExtract_Height() throws Exception {
        JpegReaderTest.assertEquals((int)600, (int)this._directory.getInt(1));
    }

    public void testExtract_DataPrecision() throws Exception {
        JpegReaderTest.assertEquals((int)8, (int)this._directory.getInt(0));
    }

    public void testExtract_NumberOfComponents() throws Exception {
        JpegReaderTest.assertEquals((int)3, (int)this._directory.getInt(5));
    }

    public void testComponentData1() throws Exception {
        JpegComponent jpegComponent = (JpegComponent)this._directory.getObject(6);
        JpegReaderTest.assertEquals((String)"Y", (String)jpegComponent.getComponentName());
        JpegReaderTest.assertEquals((int)1, (int)jpegComponent.getComponentId());
        JpegReaderTest.assertEquals((int)0, (int)jpegComponent.getQuantizationTableNumber());
        JpegReaderTest.assertEquals((int)2, (int)jpegComponent.getHorizontalSamplingFactor());
        JpegReaderTest.assertEquals((int)2, (int)jpegComponent.getVerticalSamplingFactor());
    }

    public void testComponentData2() throws Exception {
        JpegComponent jpegComponent = (JpegComponent)this._directory.getObject(7);
        JpegReaderTest.assertEquals((String)"Cb", (String)jpegComponent.getComponentName());
        JpegReaderTest.assertEquals((int)2, (int)jpegComponent.getComponentId());
        JpegReaderTest.assertEquals((int)1, (int)jpegComponent.getQuantizationTableNumber());
        JpegReaderTest.assertEquals((int)1, (int)jpegComponent.getHorizontalSamplingFactor());
        JpegReaderTest.assertEquals((int)1, (int)jpegComponent.getVerticalSamplingFactor());
        JpegReaderTest.assertEquals((String)"Cb component: Quantization table 1, Sampling factors 1 horiz/1 vert", (String)this._directory.getDescription(7));
    }

    public void testComponentData3() throws Exception {
        JpegComponent jpegComponent = (JpegComponent)this._directory.getObject(8);
        JpegReaderTest.assertEquals((String)"Cr", (String)jpegComponent.getComponentName());
        JpegReaderTest.assertEquals((int)3, (int)jpegComponent.getComponentId());
        JpegReaderTest.assertEquals((int)1, (int)jpegComponent.getQuantizationTableNumber());
        JpegReaderTest.assertEquals((int)1, (int)jpegComponent.getHorizontalSamplingFactor());
        JpegReaderTest.assertEquals((int)1, (int)jpegComponent.getVerticalSamplingFactor());
        JpegReaderTest.assertEquals((String)"Cr component: Quantization table 1, Sampling factors 1 horiz/1 vert", (String)this._directory.getDescription(8));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

