/*
 * Decompiled with CFR 0.152.
 */
package pm.gui;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collections;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import pm.gui.PM_CutPictureUI;
import pm.gui.PM_WindowMain;
import pm.gui.PM_WindowSlideshow;
import pm.picture.PM_Picture;
import pm.utilities.PM_Action;
import pm.utilities.PM_Interface;
import pm.utilities.PM_Listener;
import pm.utilities.PM_MSG;
import pm.utilities.PM_UtilsGrafik;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PM_CutPicture
extends PM_CutPictureUI
implements PM_Interface {
    private AffineTransform affineTransform = new AffineTransform();
    private AffineTransform inverseAffineTransform = new AffineTransform();
    private Rectangle2D deviceRectCut = new Rectangle2D.Double();
    private Rectangle2D deviceRectOtherSize = new Rectangle2D.Double();
    private Rectangle2D deviceRectMax = new Rectangle2D.Double();
    private PM_WindowMain windowMain = null;
    private JPanel picturePanel = null;
    private JPanel lowerAendernPanel = null;

    public PM_CutPicture(PM_WindowMain pM_WindowMain, final JDialog jDialog) {
        this.windowMain = pM_WindowMain;
        this.dialog = jDialog;
        ActionListener actionListener = new ActionListener(){

            public final void actionPerformed(ActionEvent actionEvent) {
                if (PM_CutPicture.this.buttonUebernehmen.isEnabled()) {
                    PM_CutPicture.this.warnung();
                    return;
                }
                jDialog.dispose();
            }
        };
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0, true);
        jDialog.getRootPane().registerKeyboardAction(actionListener, keyStroke, 1);
        this.picturePanel = this.getPicturePanel();
        this.lowerAendernPanel = this.getLowerAendernPanel();
        this.addMouseListener(new MyMouseAdapter());
        this.setLayout(new BorderLayout());
        this.add((Component)this.picturePanel, "Center");
        this.add((Component)this.lowerAendernPanel, "South");
        PM_Listener pM_Listener = new PM_Listener(){

            public void actionPerformed(PM_Action pM_Action) {
                PM_CutPicture.this.setMsg();
            }
        };
        PM_MSG.addChangeListener(pM_Listener);
        this.setMsg();
    }

    private void setMsg() {
        this.buttonAusschneiden.setText(PM_MSG.getMsg("modIntCut"));
        this.buttonUebernehmen.setText(PM_MSG.getMsg("modIntApply"));
        this.buttonAbbrechen.setText(PM_MSG.getMsg("modIntQuit"));
        this.buttonDrehen.setText(PM_MSG.getMsg("modIntRotate"));
        this.buttonLoeschen.setText(PM_MSG.getMsg("modIntDelete"));
        this.qLabel.setText(PM_MSG.getMsg("category14"));
    }

    public boolean start(PM_Picture pM_Picture, List<PM_Picture> list) {
        Dimension dimension = this.picturePanel.getSize();
        System.out.println("......   size Bild = " + dimension);
        Dimension dimension2 = this.lowerAendernPanel.getSize();
        System.out.println("         size Unten = " + dimension2);
        if (pM_Picture == null) {
            return false;
        }
        this.picture = pM_Picture;
        this.pictureList = list;
        this.diashowAufrufen = false;
        this.doZeigenBild();
        return true;
    }

    public void keyPressedFkt(int n) {
        this.diashowAufrufen = true;
        this.dialog.dispose();
    }

    public boolean getDiaShowAufrufen() {
        return this.diashowAufrufen;
    }

    @Override
    protected boolean resizeDiagonal() {
        return !this.buttonAusschneiden.isEnabled();
    }

    @Override
    protected boolean resizeVertiHorizontal() {
        return !this.buttonAusschneiden.isEnabled();
    }

    @Override
    protected boolean move() {
        return !this.buttonAusschneiden.isEnabled();
    }

    @Override
    protected void drawRectangleResize(Graphics graphics) {
        double d;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Rectangle rectangle = PM_UtilsGrafik.rectangle2DToRectangle(this.getRectangleResize());
        double d2 = rectangle.getWidth() / rectangle.getHeight();
        if (!PM_UtilsGrafik.istSelbeDarstellung(d2, d = this.picture.getImageOriginalRatio())) {
            d2 = 1.0 / d2;
        }
        double d3 = Math.abs(d - d2);
        Stroke stroke = graphics2D.getStroke();
        if (d3 > 0.005) {
            graphics2D.setStroke(new BasicStroke(1.0f, 0, 2, 3.0f, new float[]{50.0f, 10.0f}, 4.0f));
        }
        graphics2D.setColor(Color.YELLOW);
        graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics2D.setStroke(stroke);
        graphics2D.setColor(Color.RED);
        double d4 = 0.0;
        if (d4 != 0.0) {
            Rectangle rectangle2 = PM_UtilsGrafik.rectangle2DToRectangle(this.getRectangleResizeOtherSize());
            graphics2D.drawRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        }
        graphics2D.setColor(Color.YELLOW);
    }

    @Override
    protected void setRectangleResized(Rectangle2D rectangle2D, AffineTransform affineTransform) {
        double d;
        this.deviceRectCut = rectangle2D;
        this.buttonUebernehmen.setEnabled(true);
        this.buttonAbbrechen.setEnabled(true);
        double d2 = 0.0;
        if (d2 == 0.0) {
            return;
        }
        double d3 = this.deviceRectCut.getX();
        double d4 = this.deviceRectCut.getY();
        double d5 = this.deviceRectCut.getWidth();
        double d6 = d5 / (d = this.deviceRectCut.getHeight());
        if (!PM_UtilsGrafik.istSelbeDarstellung(d6, d2)) {
            d2 = 1.0 / d2;
        }
        this.deviceRectOtherSize = new Rectangle2D.Double(d3, d4, d5, d / d2);
    }

    @Override
    protected Rectangle2D getRectangleResize() {
        return this.deviceRectCut;
    }

    @Override
    protected Rectangle2D getRectangleResizeOtherSize() {
        return this.deviceRectOtherSize;
    }

    @Override
    protected Rectangle2D getRectangleMax() {
        return this.deviceRectMax;
    }

    public PM_Picture getPicture() {
        return this.picture;
    }

    @Override
    protected void doAussschneiden() {
        if (this.deviceRectCut.getWidth() == 0.0 || this.deviceRectCut.getWidth() == 0.0) {
            Rectangle rectangle = new Rectangle(this.imageOriginal.getWidth(this), this.imageOriginal.getHeight(this));
            this.deviceRectCut = this.affineTransform.createTransformedShape(rectangle).getBounds();
            double d = this.deviceRectCut.getWidth() / this.deviceRectCut.getHeight();
            this.deviceRectCut = PM_UtilsGrafik.grow(this.deviceRectCut, new Point2D.Double(-100.0, -100.0 / d));
        }
        this.disableButtonsAusschneiden();
        this.buttonAbbrechen.setEnabled(true);
        this.buttonDrehen.setEnabled(true);
        this.buttonLoeschen.setEnabled(true);
        this.buttonUebernehmen.setEnabled(true);
        this.picturePanel.paintImmediately(PM_UtilsGrafik.rectangle2DToRectangle(this.deviceRectMax));
    }

    @Override
    protected void doUebernehmen() {
        Rectangle rectangle = this.inverseAffineTransform.createTransformedShape(this.deviceRectCut).getBounds();
        this.picture.meta.setCutRectangle(rectangle);
        this.windowMain.rereadPictureViewThumbnail(this.picture);
        this.disableButtonsAusschneiden();
        this.buttonAusschneiden.setEnabled(true);
        this.paintWindow();
    }

    @Override
    protected void doAbbrechen() {
        this.deviceRectCut = this.getOrigDeviceRectCut();
        this.disableButtonsAusschneiden();
        this.buttonAusschneiden.setEnabled(true);
        this.paintWindow();
    }

    @Override
    protected void doDrehen() {
        this.deviceRectCut = PM_UtilsGrafik.rotateRoundMiddlePoint(this.deviceRectCut);
        this.disableButtonsAusschneiden();
        this.buttonUebernehmen.setEnabled(true);
        this.buttonAbbrechen.setEnabled(true);
        this.buttonDrehen.setEnabled(true);
        this.buttonLoeschen.setEnabled(true);
        this.paintWindow();
    }

    @Override
    protected void doLoeschenCutRectangle() {
        this.picture.meta.setCutRectangle(new Rectangle());
        this.windowMain.rereadPictureViewThumbnail(this.picture);
        this.deviceRectCut = this.getOrigDeviceRectCut();
        this.disableButtonsAusschneiden();
        this.buttonAusschneiden.setEnabled(true);
        this.paintWindow();
    }

    private void doZeigenBild() {
        this.readImageOriginal(true);
        this.setLowerPanel();
        this.paintWindow();
    }

    private void paintWindow() {
        this.picturePanel.repaint();
        this.lowerAendernPanel.repaint();
    }

    @Override
    protected void doZeigenNextBild() {
        if (this.buttonUebernehmen.isEnabled()) {
            this.warnung();
            return;
        }
        int n = this.pictureList.indexOf(this.picture);
        if (n == -1 || n + 2 >= this.pictureList.size()) {
            return;
        }
        this.picture = (PM_Picture)this.pictureList.get(n + 1);
        this.readImageOriginal(true);
        this.setLowerPanel();
        this.paintWindow();
    }

    @Override
    protected void doZeigenPreviousBild() {
        if (this.buttonUebernehmen.isEnabled()) {
            this.warnung();
            return;
        }
        int n = this.pictureList.indexOf(this.picture);
        if (n <= 0) {
            JOptionPane.showConfirmDialog(this, "Keine weiteren Bilder", "Ende", -1, 1);
            return;
        }
        this.picture = (PM_Picture)this.pictureList.get(n - 1);
        this.readImageOriginal(false);
        this.setLowerPanel();
        this.paintWindow();
    }

    private void readImageOriginal(boolean bl) {
        Cursor cursor = this.getCursor();
        this.setCursor(new Cursor(3));
        List<PM_Picture> list = Collections.singletonList(this.picture);
        List<PM_Picture> list2 = PM_WindowSlideshow.getPrefetchList(this.picture, this.pictureList, bl);
        PM_Picture.readImageOriginal(list, list2);
        this.imageOriginal = this.picture.getImageOriginal();
        this.disableButtonsAusschneiden();
        this.buttonAusschneiden.setEnabled(true);
        this.affineTransform = this.createAffineTransform();
        try {
            this.inverseAffineTransform = this.affineTransform.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            this.inverseAffineTransform = new AffineTransform();
        }
        this.deviceRectCut = this.getOrigDeviceRectCut();
        this.deviceRectMax = this.affineTransform.createTransformedShape(new Rectangle(this.picture.meta.getImageSize())).getBounds();
        this.setCursor(cursor);
    }

    private Rectangle getOrigDeviceRectCut() {
        Rectangle rectangle = null;
        if (this.picture.meta.hasCutRectangle()) {
            rectangle = this.picture.meta.getCutRectangle();
            rectangle = this.affineTransform.createTransformedShape(rectangle).getBounds();
        } else {
            rectangle = new Rectangle();
        }
        return rectangle;
    }

    private AffineTransform createAffineTransform() {
        Rectangle rectangle;
        Rectangle rectangle2 = new Rectangle(this.picturePanel.getWidth(), this.picturePanel.getHeight());
        int n = 0;
        int n2 = 0;
        int n3 = this.imageOriginal.getWidth(this);
        int n4 = this.imageOriginal.getHeight(this);
        switch (this.picture.meta.getRotation()) {
            case 90: {
                rectangle = new Rectangle(n4, n3);
                n = rectangle.width;
                n2 = 0;
                break;
            }
            case 180: {
                rectangle = new Rectangle(n4, n3);
                n = rectangle.height;
                n2 = rectangle.width;
                break;
            }
            case 270: {
                rectangle = new Rectangle(n4, n3);
                n = 0;
                n2 = rectangle.height;
                break;
            }
            default: {
                rectangle = new Rectangle(n3, n4);
                n = 0;
                n2 = 0;
            }
        }
        double d = 0.0;
        d = PM_UtilsGrafik.getRatio(rectangle) < PM_UtilsGrafik.getRatio(rectangle2) ? (double)rectangle2.height / (double)rectangle.height : (double)rectangle2.width / (double)rectangle.width;
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToTranslation(0.0, 0.0);
        affineTransform.scale(d, d);
        affineTransform.translate(n, n2);
        affineTransform.rotate((double)this.picture.meta.getRotation() * Math.PI / 180.0);
        return affineTransform;
    }

    private JPanel getPicturePanel() {
        JPanel jPanel = new JPanel(){
            private static final long serialVersionUID = 1L;

            public void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                Graphics2D graphics2D = (Graphics2D)graphics;
                if (PM_CutPicture.this.imageOriginal != null) {
                    graphics2D.setClip(PM_CutPicture.this.deviceRectMax);
                    graphics2D.drawImage(PM_CutPicture.this.imageOriginal, PM_CutPicture.this.affineTransform, this);
                    graphics2D.setColor(Color.YELLOW);
                    PM_CutPicture.this.drawRectangleResize(graphics, new Point(this.getX(), this.getY()));
                }
            }
        };
        jPanel.setBackground(Color.LIGHT_GRAY);
        return jPanel;
    }

    class MyMouseAdapter
    extends MouseAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 3) {
                PM_CutPicture.this.doZeigenNextBild();
                return;
            }
            if (mouseEvent.getButton() == 1) {
                PM_CutPicture.this.doZeigenPreviousBild();
                return;
            }
        }
    }

    class MyKeyAdapter
    extends KeyAdapter {
        MyKeyAdapter() {
        }

        public void keyPressed(KeyEvent keyEvent) {
        }
    }
}

