/*
 * Decompiled with CFR 0.152.
 */
package pm.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import pm.gui.PM_WindowExtern;
import pm.gui.PM_WindowExternalSetup;
import pm.gui.PM_WindowMain;
import pm.inout.PM_All_ExternalPrograms;
import pm.inout.PM_ExternalProgram;
import pm.picture.PM_Picture;
import pm.picture.PM_PictureExternalModify;
import pm.utilities.PM_Action;
import pm.utilities.PM_Interface;
import pm.utilities.PM_Listener;
import pm.utilities.PM_MSG;
import pm.utilities.PM_Utils;
import pm.utilities.PM_UtilsGrafik;

public class PM_ModifyExternal
extends PM_WindowExtern
implements PM_Interface {
    private JDialog dialog;
    private PM_Picture picture = null;
    private PM_PictureExternalModify pictureExternBearbeiten;
    private int qsChanged = 0;
    private boolean qsGeaendert = false;
    private JPanel picturePanel;
    private JComboBox cbProgrammName = null;
    private JTable table = new JTable();
    private Vector<String> header = new Vector();
    private DefaultTableModel tableModel;
    private byte[] messageDigestIn;
    private JTextField bildPfadName = null;
    private JTextField bildGroesse = null;
    private JTextField progPfadName = null;
    private Image imageToDisplay = null;
    private JRadioButton q1 = null;
    private JRadioButton q2 = null;
    private JRadioButton q3 = null;
    private JRadioButton q4 = null;
    private JTabbedPane tabbedPane;
    private JLabel labelProgramName;
    private JLabel labelProgramPath;
    private JLabel labelCat;
    private JLabel labelFileName;
    private JLabel labelPicSize;
    private JButton buttonStart;
    private JButton buttonDelete;
    private JButton buttonExit;
    private JButton buttonLoad;

    public PM_ModifyExternal(PM_WindowMain pM_WindowMain, JDialog jDialog) {
        this.dialog = jDialog;
        this.tabbedPane = new JTabbedPane(1);
        this.picturePanel = this.getPicturePanel();
        JSplitPane jSplitPane = new JSplitPane(1, this.getPanelStarten(), this.picturePanel);
        PM_WindowExternalSetup pM_WindowExternalSetup = new PM_WindowExternalSetup();
        PM_Listener pM_Listener = new PM_Listener(){

            public void actionPerformed(PM_Action pM_Action) {
                Object object = pM_Action.getObject();
                PM_ExternalProgram pM_ExternalProgram = null;
                if (object instanceof PM_ExternalProgram) {
                    pM_ExternalProgram = (PM_ExternalProgram)pM_Action.getObject();
                }
                PM_ModifyExternal.this.setzenProgrammNamen(pM_ExternalProgram);
            }
        };
        pM_WindowExternalSetup.addChangeListenerExterneProgramme(pM_Listener);
        this.tabbedPane.insertTab("Bild bearbeiten", null, jSplitPane, "", 0);
        this.tabbedPane.insertTab("Programm einrichten", null, pM_WindowExternalSetup, "", 1);
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPane, "Center");
        PM_Listener pM_Listener2 = new PM_Listener(){

            public void actionPerformed(PM_Action pM_Action) {
                PM_ModifyExternal.this.setMsg();
            }
        };
        PM_MSG.addChangeListener(pM_Listener2);
        this.setMsg();
    }

    private void setMsg() {
        this.tabbedPane.setTitleAt(0, PM_MSG.getMsg("modExtModifyPic"));
        this.tabbedPane.setTitleAt(1, PM_MSG.getMsg("modExtSetupProgram"));
        this.labelPicSize.setText(PM_MSG.getMsg("modExtLabelPicSize"));
        this.labelFileName.setText(PM_MSG.getMsg("modExtLabelFileName"));
        this.labelProgramName.setText(PM_MSG.getMsg("modExtProgramName"));
        this.labelProgramPath.setText(PM_MSG.getMsg("modExtProgramPath"));
        this.labelCat.setText(PM_MSG.getMsg("category14"));
        this.buttonStart.setText(PM_MSG.getMsg("modExtButtonStart"));
        this.buttonDelete.setText(PM_MSG.getMsg("delete"));
        this.buttonExit.setText(PM_MSG.getMsg("exit"));
        this.buttonLoad.setText(PM_MSG.getMsg("modExtButtonLoad"));
        this.header.set(0, PM_MSG.getMsg("modExtTabLoad"));
        this.header.set(1, PM_MSG.getMsg("modExtTabDate"));
        this.header.set(2, PM_MSG.getMsg("modExtTabBackUp"));
    }

    public boolean start(PM_Picture pM_Picture) {
        this.picture = pM_Picture;
        this.pictureExternBearbeiten = new PM_PictureExternalModify(pM_Picture);
        this.messageDigestIn = PM_Utils.getMessageDigest(pM_Picture.getFileOriginal());
        this.setzenInhaltTabelle();
        this.bildPfadName.setText(pM_Picture.getFileOriginal().getPath());
        this.setzenProgrammNamen(null);
        this.qsChanged = pM_Picture.meta.getCategory();
        this.qsGeaendert = false;
        switch (pM_Picture.meta.getCategory()) {
            case 1: {
                this.q1.setSelected(true);
                break;
            }
            case 2: {
                this.q2.setSelected(true);
                break;
            }
            case 3: {
                this.q3.setSelected(true);
                break;
            }
            case 4: {
                this.q4.setSelected(true);
            }
        }
        return true;
    }

    private void setzenProgrammNamen(PM_ExternalProgram pM_ExternalProgram) {
        Vector vector = PM_All_ExternalPrograms.getInstance().getAlleExternenProgramme();
        this.cbProgrammName.removeAllItems();
        for (int i = 0; i < vector.size(); ++i) {
            this.cbProgrammName.addItem(vector.elementAt(i));
        }
        if (pM_ExternalProgram != null) {
            this.cbProgrammName.setSelectedItem(pM_ExternalProgram);
        } else if (vector.size() > 0) {
            this.cbProgrammName.setSelectedIndex(0);
        }
    }

    private void setzenInhaltTabelle() {
        int n;
        Vector vector = new Vector();
        PM_PictureExternalModify.EinBild[] einBildArray = this.pictureExternBearbeiten.getFileList();
        for (n = 0; n < einBildArray.length; ++n) {
            PM_PictureExternalModify.EinBild einBild = einBildArray[n];
            Vector<String> vector2 = new Vector<String>();
            if (einBild.getGeladen()) {
                vector2.add(PM_MSG.getMsg("modExtLabelLoad"));
            } else {
                vector2.add("");
            }
            vector2.add(einBild.getDatumString());
            int n2 = einBild.getExtension();
            String string = "b" + Integer.toString(einBild.getExtension());
            if (n2 == 0) {
                string = string + "  (" + PM_MSG.getMsg("modExtLabelOriginal") + ")";
            }
            vector2.add(string);
            vector.add(vector2);
        }
        this.tableModel.setDataVector(vector, this.header);
        n = this.pictureExternBearbeiten.getIndexGeladen();
        if (n >= 0) {
            this.table.setRowSelectionInterval(n, n);
        }
        this.repaint();
    }

    private void doStarten() {
        int n = this.pictureExternBearbeiten.getIndexGeladen();
        if (n != this.table.getSelectedRow()) {
            JOptionPane.showConfirmDialog(this, PM_MSG.getMsg("modExtMsgNotLoaded"), "Error", -1, 1);
            return;
        }
        String string = this.progPfadName.getText();
        this.pictureExternBearbeiten.startBearbeitung();
        String string2 = this.picture.getFileOriginal().getPath();
        if (!PM_Utils.isLinux()) {
            string2 = "\"" + string2 + "\"";
        }
        this.startenProgramm(string, string2);
    }

    private void doLaden() {
        this.pictureExternBearbeiten.ladenBild(this.table.getSelectedRow());
        this.setzenInhaltTabelle();
    }

    private void doLoeschen() {
        String string = "";
        if (this.table.getSelectedRow() == 0) {
            string = PM_MSG.getMsg("modExtMsgNotDelete");
            JOptionPane.showConfirmDialog(this, string, "Fehler", -1, 1);
            return;
        }
        int n = this.pictureExternBearbeiten.getIndexGeladen();
        if (n == this.table.getSelectedRow()) {
            string = PM_MSG.getMsg("modExtMsgNotLoad");
            JOptionPane.showConfirmDialog(this, string, "Fehler", -1, 1);
            return;
        }
        string = PM_MSG.getMsg("modExtMsgBackUpDel");
        int n2 = JOptionPane.showConfirmDialog(this, string, "Sicherheitsabfrage", 0, 3);
        if (n2 == 1) {
            return;
        }
        this.pictureExternBearbeiten.loeschenBild(this.table.getSelectedRow());
        this.setzenInhaltTabelle();
    }

    private void doBeenden() {
        Object object;
        int n;
        int n2 = this.pictureExternBearbeiten.getIndexGeladen();
        if (n2 != this.table.getSelectedRow() && (n = JOptionPane.showConfirmDialog(this, object = PM_MSG.getMsg("modExtMsgNotLoaded"), "", 2, 3)) == 2) {
            return;
        }
        if (this.qsGeaendert) {
            this.picture.meta.setCategory(this.qsChanged);
        }
        if (MessageDigest.isEqual(this.messageDigestIn, (byte[])(object = (Object)PM_Utils.getMessageDigest(this.picture.getFileOriginal())))) {
            this.dialog.dispose();
            return;
        }
        this.picture.meta.setCutRectangle(new Rectangle());
        this.picture.meta.setRotation(0);
        Image image = this.getImage(this.picture.getFileOriginal().getPath());
        if (image != null) {
            this.picture.meta.setImageSize(PM_UtilsGrafik.getImageSize(image));
            File file = PM_Utils.getFileThumbnail(this.picture.getFileOriginal());
            Image image2 = PM_UtilsGrafik.makeThumbnail(image);
            PM_UtilsGrafik.writeThumbnail(file, image2);
            this.picture.setImageThumbnail(image2);
        }
        if (this.table.getSelectedRow() == 0) {
            this.picture.meta.setModified(false);
        } else {
            this.picture.meta.setModified(true);
        }
        PM_Picture.readImageOriginal(new ArrayList<PM_Picture>(), new ArrayList<PM_Picture>());
        this.dialog.dispose();
    }

    protected void processEnde() {
        boolean bl = this.pictureExternBearbeiten.endeBearbeitung();
        if (!bl) {
            return;
        }
        this.bildDarstellen(this.pictureExternBearbeiten.getIndexGeladen());
        this.setzenInhaltTabelle();
    }

    private JScrollPane getPanelStarten() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.header.add("geladen");
        this.header.add("Datum");
        this.header.add("Sicherung");
        this.table.setRowSelectionAllowed(true);
        this.table.setSelectionMode(0);
        this.table.setSelectionBackground(Color.GREEN);
        this.table.setRowSelectionAllowed(true);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.setPreferredSize(new Dimension(0, 250));
        this.tableModel = new DefaultTableModel(){

            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.table.setModel(this.tableModel);
        this.tableModel.setDataVector(new Vector(), this.header);
        TableColumn tableColumn = null;
        tableColumn = this.table.getColumnModel().getColumn(0);
        tableColumn.setMaxWidth(200);
        tableColumn.setPreferredWidth(80);
        tableColumn = this.table.getColumnModel().getColumn(1);
        tableColumn.setMaxWidth(200);
        tableColumn.setPreferredWidth(160);
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (PM_ModifyExternal.this.imageToDisplay != null) {
                    PM_ModifyExternal.this.imageToDisplay.flush();
                }
                if (PM_ModifyExternal.this.picture == null) {
                    return;
                }
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                if (listSelectionModel.isSelectionEmpty()) {
                    return;
                }
                int n = listSelectionModel.getMinSelectionIndex();
                if (!PM_ModifyExternal.this.pictureExternBearbeiten.hasEinBildAt(n)) {
                    return;
                }
                PM_ModifyExternal.this.bildDarstellen(n);
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0));
        this.labelProgramName = new JLabel("Programmname: ");
        jPanel2.add(this.labelProgramName);
        this.cbProgrammName = new JComboBox();
        jPanel2.add(this.cbProgrammName);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = PM_ModifyExternal.this.cbProgrammName.getSelectedItem();
                if (!(object instanceof PM_ExternalProgram)) {
                    return;
                }
                PM_ExternalProgram pM_ExternalProgram = (PM_ExternalProgram)object;
                PM_ModifyExternal.this.progPfadName.setText(pM_ExternalProgram.getPath());
            }
        };
        this.cbProgrammName.addActionListener(actionListener);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0));
        this.labelProgramPath = new JLabel("Programmpfad: ");
        jPanel3.add(this.labelProgramPath);
        this.progPfadName = new JTextField("    ");
        this.progPfadName.setColumns(30);
        jPanel3.add(this.progPfadName);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(0));
        this.labelFileName = new JLabel("Dateiname: ");
        jPanel4.add(this.labelFileName);
        this.bildPfadName = new JTextField("    ");
        this.bildPfadName.setColumns(30);
        jPanel4.add(this.bildPfadName);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(0));
        this.labelPicSize = new JLabel("Bildgroe\u00dfe: ");
        jPanel5.add(this.labelPicSize);
        this.bildGroesse = new JTextField("    ");
        jPanel5.add(this.bildGroesse);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new FlowLayout(0));
        this.buttonStart = new JButton("Bild bearbeiten");
        jPanel6.add(this.buttonStart);
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (PM_ModifyExternal.this.waitForProcessEnde()) {
                    return;
                }
                PM_ModifyExternal.this.doStarten();
            }
        };
        this.buttonStart.addActionListener(actionListener2);
        this.buttonLoad = new JButton("Sicherung laden");
        jPanel6.add(this.buttonLoad);
        ActionListener actionListener3 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (PM_ModifyExternal.this.waitForProcessEnde()) {
                    return;
                }
                PM_ModifyExternal.this.doLaden();
            }
        };
        this.buttonLoad.addActionListener(actionListener3);
        this.buttonDelete = new JButton("Sicherung l\u00f6schen");
        jPanel6.add(this.buttonDelete);
        ActionListener actionListener4 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (PM_ModifyExternal.this.waitForProcessEnde()) {
                    return;
                }
                PM_ModifyExternal.this.doLoeschen();
            }
        };
        this.buttonDelete.addActionListener(actionListener4);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new FlowLayout(0));
        this.buttonExit = new JButton("beenden");
        jPanel7.add(this.buttonExit);
        ActionListener actionListener5 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (PM_ModifyExternal.this.waitForProcessEnde()) {
                    return;
                }
                PM_ModifyExternal.this.doBeenden();
            }
        };
        this.buttonExit.addActionListener(actionListener5);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new FlowLayout(0));
        this.labelCat = new JLabel("Kategorie");
        jPanel8.add(this.labelCat);
        this.q1 = new JRadioButton();
        this.q2 = new JRadioButton();
        this.q3 = new JRadioButton();
        this.q4 = new JRadioButton();
        this.q1.setActionCommand("q1");
        this.q2.setActionCommand("q2");
        this.q3.setActionCommand("q3");
        this.q4.setActionCommand("q4");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.q1);
        buttonGroup.add(this.q2);
        buttonGroup.add(this.q3);
        buttonGroup.add(this.q4);
        jPanel8.add(this.q1);
        jPanel8.add(this.q2);
        jPanel8.add(this.q3);
        jPanel8.add(this.q4);
        MyRadioListener myRadioListener = new MyRadioListener();
        this.q1.addActionListener(myRadioListener);
        this.q2.addActionListener(myRadioListener);
        this.q3.addActionListener(myRadioListener);
        this.q4.addActionListener(myRadioListener);
        jPanel.add(jScrollPane);
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        jPanel.add(jPanel4);
        jPanel.add(jPanel5);
        jPanel.add(jPanel6);
        jPanel.add(jPanel7);
        jPanel.add(jPanel8);
        JPanel jPanel9 = new JPanel(new BorderLayout());
        jPanel9.add((Component)jPanel, "North");
        JScrollPane jScrollPane2 = new JScrollPane(jPanel9);
        return jScrollPane2;
    }

    private void bildDarstellen(int n) {
        PM_PictureExternalModify.EinBild einBild = this.pictureExternBearbeiten.getEinBildAt(n);
        File file = null;
        file = einBild.getFile();
        if (!file.exists()) {
            file = this.picture.getFileOriginal();
        }
        if (!file.exists()) {
            return;
        }
        this.imageToDisplay = this.getImage(file.getPath());
        String string = Integer.toString(this.imageToDisplay.getWidth(null)) + "x" + Integer.toString(this.imageToDisplay.getHeight(null)) + " Pixel";
        this.bildGroesse.setText(string);
        this.picturePanel.repaint();
    }

    private Image getImage(String string) {
        Image image = null;
        try {
            image = Toolkit.getDefaultToolkit().getImage(string);
            MediaTracker mediaTracker = new MediaTracker(new Container());
            mediaTracker.addImage(image, 0);
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        return image;
    }

    private JPanel getPicturePanel() {
        JPanel jPanel = new JPanel(){

            public void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                if (PM_ModifyExternal.this.imageToDisplay != null) {
                    int n = PM_ModifyExternal.this.picturePanel.getWidth();
                    double d = PM_UtilsGrafik.getRatio(PM_ModifyExternal.this.imageToDisplay);
                    int n2 = (int)((double)n / d);
                    graphics.drawImage(PM_ModifyExternal.this.imageToDisplay, 0, 0, n, n2, this);
                }
            }
        };
        return jPanel;
    }

    class MyRadioListener
    implements ActionListener {
        MyRadioListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (PM_ModifyExternal.this.picture == null) {
                return;
            }
            String string = actionEvent.getActionCommand().substring(1);
            PM_ModifyExternal.this.qsChanged = PM_Utils.stringToInt(string);
            PM_ModifyExternal.this.qsGeaendert = true;
        }
    }
}

