/*
 * Decompiled with CFR 0.152.
 */
package pm.gui;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.tree.DefaultMutableTreeNode;
import pm.gui.PM_FocusPanel;
import pm.gui.PM_IndexView;
import pm.gui.PM_PictureView;
import pm.gui.PM_WindowLeftThumbnails;
import pm.gui.PM_WindowMain;
import pm.picture.PM_Picture;
import pm.sequence.PM_Sequence;
import pm.sequence.PM_TreeWindow;
import pm.utilities.PM_Interface;

public abstract class PM_WindowBase
extends JPanel
implements PM_Interface {
    public static Color COLOR_SELECTED_BG = Color.ORANGE;
    public static Color COLOR_DESELECTED_BG = Color.GRAY;
    public static Color COLOR_BACKGROUND = new Color(255, 255, 150);
    public static Color COLOR_NUR_LESEN = Color.pink;
    public static Color COLOR_WARNING = new Color(255, 138, 138);
    public static Color COLOR_WARNING_FOCUS = Color.RED;
    public static Color COLOR_ENABLED = new Color(213, 213, 255);
    public static Color COLOR_ENABLED_SEL = new Color(156, 156, 255);
    public static Color COLOR_BG_PANEL = new Color(255, 255, 150);
    public static Color COLOR_BG_PANEL_SEL = Color.YELLOW;
    public static Color COLOR_BG_FOCUS = Color.ORANGE;
    protected PM_WindowMain windowMain;
    protected int tabIndex;
    private final PM_IndexView indexView;
    protected Component aktiverFocus = null;
    private List<PM_FocusPanel> focusCycleList = new ArrayList<PM_FocusPanel>();
    protected JScrollPane indexViewScrollPane = null;

    public PM_WindowBase(PM_WindowMain pM_WindowMain, int n, boolean bl) {
        this.windowMain = pM_WindowMain;
        this.tabIndex = n;
        if (bl) {
            this.indexView = new PM_IndexView(pM_WindowMain, this);
            this.indexViewScrollPane = this.indexView.getScrollPane();
        } else {
            this.indexView = null;
        }
    }

    public Component getAktiverFocus() {
        return this.aktiverFocus;
    }

    public void setAktiverFocus(Component component) {
        this.aktiverFocus = component;
    }

    public List getFocusCycleList() {
        return this.focusCycleList;
    }

    public void addFocusPanel(PM_FocusPanel pM_FocusPanel) {
        this.focusCycleList.add(pM_FocusPanel);
    }

    public boolean isWindowLeft() {
        return this instanceof PM_WindowLeftThumbnails;
    }

    public void getAllThumbs(PM_IndexView pM_IndexView) {
        if (this.getIndexView() == null) {
            return;
        }
        List<PM_Picture> list = pM_IndexView.getPictureListDarstellen();
        this.getIndexView().setAndPaintPictureList(list);
    }

    public boolean appendAllThumbs(PM_IndexView pM_IndexView) {
        if (this.getIndexView() == null) {
            return false;
        }
        List<PM_Picture> list = pM_IndexView.getPictureListDarstellen();
        return this.getIndexView().appendPictureList(list);
    }

    public void rereadAllThumbs() {
        if (this.getIndexView() == null) {
            return;
        }
        this.getIndexView().rereadAllThumbs();
    }

    public void removeAllThumbs() {
        if (this.getIndexView() == null) {
            return;
        }
        this.getIndexView().removeAllThumbs();
    }

    public void openPicture(PM_Picture pM_Picture) {
        if (this.getIndexView() == null) {
            return;
        }
        this.getIndexView().openPicture(pM_Picture);
    }

    public void closePicture(PM_Picture pM_Picture) {
        if (this.getIndexView() == null) {
            return;
        }
        this.getIndexView().closePicture(pM_Picture);
    }

    public boolean appendPicture(PM_PictureView pM_PictureView) {
        if (this.getIndexView() == null) {
            return false;
        }
        return this.getIndexView().addPicture(pM_PictureView.getPicture());
    }

    public boolean movePicture(PM_Picture pM_Picture, PM_Picture pM_Picture2) {
        if (this.getIndexView() == null) {
            return false;
        }
        return this.getIndexView().movePicture(pM_Picture, pM_Picture2);
    }

    public boolean insertPicture(PM_Picture pM_Picture, PM_Picture pM_Picture2) {
        if (this.getIndexView() == null) {
            return false;
        }
        return this.getIndexView().insertPicture(pM_Picture, pM_Picture2);
    }

    public PM_Picture getPictureSelected() {
        return null;
    }

    public void darstellungSequenz(PM_Sequence pM_Sequence, DefaultMutableTreeNode defaultMutableTreeNode) {
    }

    public void doubleClickOnTree(DefaultMutableTreeNode defaultMutableTreeNode, PM_TreeWindow pM_TreeWindow) {
    }

    public void doubleClickOnPictureView(PM_PictureView pM_PictureView) {
    }

    public void init() {
    }

    public abstract boolean requestToChange();

    public void tabChanged() {
    }

    public PM_IndexView getIndexView() {
        return this.indexView;
    }

    public PM_FocusPanel getFocusPanelWithFocusOwner() {
        Component component = this.windowMain.getFocusOwner();
        return this.getFocusPanelWithFocusOwner(component);
    }

    public PM_FocusPanel getFocusPanelWithFocusOwner(Component component) {
        if (component == null) {
            return null;
        }
        PM_FocusPanel[] pM_FocusPanelArray = this.getFocusPanels();
        for (int i = 0; i < pM_FocusPanelArray.length; ++i) {
            PM_FocusPanel pM_FocusPanel = pM_FocusPanelArray[i];
            if (pM_FocusPanel.getLastFocus() != component) continue;
            return pM_FocusPanel;
        }
        return null;
    }

    public PM_FocusPanel[] getFocusPanels() {
        Vector<PM_FocusPanel> vector = new Vector<PM_FocusPanel>();
        for (PM_FocusPanel pM_FocusPanel : this.focusCycleList) {
            vector.add(pM_FocusPanel);
        }
        return vector.toArray(new PM_FocusPanel[vector.size()]);
    }

    public void rereadPictureViewThumbnail(PM_Picture pM_Picture) {
        if (this.getIndexView() != null) {
            this.getIndexView().rereadPictureViewThumbnail(pM_Picture);
        }
    }

    public boolean requestToClose() {
        return true;
    }

    public boolean flush() {
        return true;
    }

    public void closeAlbum() {
    }

    public void close() {
    }

    public String toString() {
        return "WindowBase   = " + this.getName();
    }
}

