/*
 * Decompiled with CFR 0.152.
 */
package pm.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import pm.gui.PM_WindowMain;
import pm.utilities.PM_Action;
import pm.utilities.PM_Configuration;
import pm.utilities.PM_Interface;
import pm.utilities.PM_ListenerX;
import pm.utilities.PM_MSG;
import pm.utilities.PM_Utils;

public class PM_WindowDialogImport {
    private JDialog dialog;
    private JProgressBar progressBar = new JProgressBar(1, 5);
    private JLabel headerLabel;
    private JTextArea whatText;
    private JLabel fileLabel;
    private JButton continueButton;
    private JButton stopButton;
    private JTextArea infoText;
    private JCheckBox enableDouble;
    private Lock lock;
    private Condition condition;
    private PM_ListenerX listener;
    private boolean stop = false;
    private PM_Interface.Import imprt;
    private static File targetDir = null;
    private JTextField targetDirField;

    public PM_WindowDialogImport(PM_Interface.Import import_) {
        this.imprt = import_;
        this.lock = new ReentrantLock();
        this.condition = this.lock.newCondition();
        this.createDialogAndStart();
        this.listener = new PM_ListenerX(){

            public boolean actionPerformed(PM_Action pM_Action) {
                Object object = pM_Action.getObject();
                int n = pM_Action.getType();
                String string = pM_Action.getString();
                if (object == null) {
                    PM_WindowDialogImport.this.progressBar.setValue(PM_WindowDialogImport.this.progressBar.getValue() + 1);
                    PM_WindowDialogImport.this.fileLabel.setText(string);
                } else if (object.equals("max")) {
                    if (n >= 0) {
                        PM_WindowDialogImport.this.progressBar.setIndeterminate(false);
                        PM_WindowDialogImport.this.setProgressMax(n);
                    } else {
                        PM_WindowDialogImport.this.progressBar.setIndeterminate(true);
                    }
                    PM_WindowDialogImport.this.fileLabel.setText("");
                    if (string.length() > 0) {
                        PM_WindowDialogImport.this.infoText.append(string + "\n");
                    }
                }
                if (PM_WindowDialogImport.this.stop) {
                    PM_WindowDialogImport.this.stop = false;
                    return false;
                }
                return true;
            }
        };
    }

    public File getTargetDir() {
        if (targetDir == null) {
            targetDir = this.getDefaultTargetDir();
        }
        return targetDir;
    }

    public PM_ListenerX getListener() {
        return this.listener;
    }

    public Lock getLock() {
        return this.lock;
    }

    public void dispose() {
        if (this.dialog != null) {
            this.dialog.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean await() {
        this.lock.lock();
        try {
            this.condition.await();
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.lock.unlock();
        }
        return this.stop;
    }

    public void setProgressMax(int n) {
        this.progressBar.setMaximum(n);
        this.progressBar.setValue(0);
    }

    public void setProgressAddValue() {
        this.progressBar.setValue(this.progressBar.getValue() + 1);
    }

    public void setProgressSetValue(int n) {
        this.progressBar.setValue(n);
    }

    public void setEnableContinue(boolean bl) {
        this.continueButton.setEnabled(bl);
    }

    public void setEnableStop(boolean bl) {
        this.stopButton.setEnabled(bl);
    }

    public boolean isDoublePicSelected() {
        return this.enableDouble.isSelected();
    }

    public void setInfoDoublePic() {
        if (this.enableDouble.isSelected()) {
            this.infoText.append(PM_MSG.getMsg("importDiaDouble") + "\n");
        } else {
            this.infoText.append(PM_MSG.getMsg("importDiaNoDouble") + "\n");
        }
    }

    public void setEnableInfoDoublePic(boolean bl) {
        this.enableDouble.setEnabled(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDialogAndStart() {
        Thread thread = new Thread(){

            public void run() {
                PM_WindowDialogImport.this.dialog = PM_WindowDialogImport.this.getDialogPanel(PM_WindowDialogImport.this.imprt);
                PM_WindowDialogImport.this.continueButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        PM_WindowDialogImport.this.stop = false;
                        PM_WindowDialogImport.this.lock.lock();
                        PM_WindowDialogImport.this.condition.signal();
                        PM_WindowDialogImport.this.lock.unlock();
                    }
                });
                PM_WindowDialogImport.this.stopButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        PM_WindowDialogImport.this.stop = true;
                        PM_WindowDialogImport.this.lock.lock();
                        PM_WindowDialogImport.this.condition.signal();
                        PM_WindowDialogImport.this.lock.unlock();
                    }
                });
                int n = 300;
                int n2 = 200;
                Dimension dimension = PM_Utils.getScreenSize();
                int n3 = dimension.width / 2 - n / 2;
                int n4 = dimension.height / 2 - n2 / 2;
                PM_WindowDialogImport.this.dialog.setLocation(n3, n4);
                PM_WindowDialogImport.this.dialog.pack();
                PM_WindowDialogImport.this.lock.lock();
                PM_WindowDialogImport.this.condition.signal();
                PM_WindowDialogImport.this.lock.unlock();
                PM_WindowDialogImport.this.dialog.setVisible(true);
            }
        };
        this.lock.lock();
        thread.start();
        try {
            this.condition.await();
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.lock.unlock();
        }
    }

    private JDialog getDialogPanel(PM_Interface.Import import_) {
        int n = 500;
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(n, 40));
        this.headerLabel = new JLabel("           Photo Manager");
        Font font = this.headerLabel.getFont();
        Font font2 = new Font(font.getName(), 1, 20);
        this.headerLabel.setFont(font2);
        this.headerLabel.setPreferredSize(new Dimension(n, 40));
        jPanel.add((Component)this.headerLabel, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0));
        String string = import_ == PM_Interface.Import.EXTERN ? PM_MSG.getMsg("importDiaExternal") : (import_ == PM_Interface.Import.INTERN ? PM_MSG.getMsg("importDiaInternal") : "Start Photo-Manager");
        this.whatText = new JTextArea(string);
        this.whatText.setPreferredSize(new Dimension(n, 30));
        font = this.whatText.getFont();
        font2 = new Font(font.getName(), 1, font.getSize());
        this.whatText.setFont(font2);
        this.whatText.setBackground(jPanel.getBackground());
        jPanel2.add(this.whatText);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0));
        jPanel3.setPreferredSize(new Dimension(n, 35));
        this.fileLabel = new JLabel("            ");
        jPanel3.add(this.fileLabel);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(0));
        this.progressBar = new JProgressBar();
        this.progressBar.setPreferredSize(new Dimension(n, 20));
        jPanel4.add(this.progressBar);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(0));
        this.infoText = new JTextArea();
        JScrollPane jScrollPane = new JScrollPane(this.infoText);
        this.infoText.setPreferredSize(new Dimension(n, 120));
        jPanel5.add(jScrollPane);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new FlowLayout(0));
        this.enableDouble = new JCheckBox(PM_MSG.getMsg("importDiaEnableDouble"));
        jPanel6.add(this.enableDouble);
        this.enableDouble.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowDialogImport.this.setInfoDoublePic();
            }
        });
        if (targetDir == null) {
            targetDir = this.getDefaultTargetDir();
        }
        JPanel jPanel7 = new JPanel(new FlowLayout(0));
        jPanel7.add(new JLabel("Ziel-Verzeichnis: "));
        this.targetDirField = new JTextField(targetDir.getPath());
        this.targetDirField.setEnabled(false);
        this.targetDirField.setColumns(30);
        jPanel7.add(this.targetDirField);
        JButton jButton = new JButton("...");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                File file = PM_WindowDialogImport.this.chooseImportDir(targetDir.getPath());
                if (!PM_Utils.isUnderTLD(file)) {
                    JOptionPane.showConfirmDialog(null, PM_MSG.getMsg("importDiaNoTLD"), "ERROR", -1, 0);
                    return;
                }
                PM_WindowDialogImport.this.targetDirField.setText(file.getAbsolutePath());
                targetDir = file;
            }
        };
        jButton.addActionListener(actionListener);
        jButton.setEnabled(false);
        jPanel7.add(jButton);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new FlowLayout(2));
        this.continueButton = new JButton(PM_MSG.getMsg("continue"));
        this.stopButton = new JButton(PM_MSG.getMsg("exit"));
        jPanel8.add(this.continueButton);
        jPanel8.add(this.stopButton);
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new BoxLayout(jPanel9, 1));
        jPanel9.add(jPanel);
        jPanel9.add(jPanel2);
        jPanel9.add(jPanel3);
        jPanel9.add(jPanel4);
        jPanel9.add(jPanel5);
        if (import_ == PM_Interface.Import.INTERN) {
            jPanel9.add(jPanel6);
        } else if (import_ == PM_Interface.Import.EXTERN) {
            jPanel9.add(jPanel7);
        }
        jPanel9.add(jPanel8);
        JDialog jDialog = new JDialog((Frame)PM_WindowMain.getInstance(), true);
        jDialog.setUndecorated(true);
        jDialog.getContentPane().add(jPanel9);
        return jDialog;
    }

    private File getDefaultTargetDir() {
        String string = PM_Configuration.getInstance().getTopLevelPictureDirectory().getPath();
        Date date = new Date(System.currentTimeMillis());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy");
        string = string + File.separator + simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("yyyy_MM");
        string = string + File.separator + simpleDateFormat.format(date);
        File file = new File(string);
        file.mkdirs();
        return file;
    }

    private File chooseImportDir(String string) {
        JFileChooser jFileChooser = new JFileChooser(string);
        jFileChooser.setDialogTitle(PM_MSG.getMsg("importDiaChooseTarget"));
        jFileChooser.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                return true;
            }

            public String getDescription() {
                return PM_MSG.getMsg("importDiaTLD");
            }
        });
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setFileSelectionMode(1);
        int n = jFileChooser.showOpenDialog(null);
        if (n != 0) {
            return null;
        }
        File file = jFileChooser.getSelectedFile();
        if (file.isDirectory()) {
            return file;
        }
        return null;
    }
}

