/*
 * Decompiled with CFR 0.152.
 */
package pm.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import pm.gui.PM_WindowImport;
import pm.gui.PM_WindowMain;
import pm.picture.PM_ImportInternal;
import pm.picture.PM_Picture;
import pm.search.PM_Search;
import pm.search.PM_SearchExpr;
import pm.sequence.PM_Sequence;
import pm.sequence.PM_TreeWindow;
import pm.sequence.PM_TreeWindowNew;
import pm.utilities.PM_Action;
import pm.utilities.PM_Interface;
import pm.utilities.PM_Listener;
import pm.utilities.PM_MSG;
import pm.utilities.PM_Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PM_WindowImportGUI
implements PM_Interface {
    private PM_WindowImport master;
    private Border border;
    protected PM_TreeWindow treeWindowNew;
    private JComponent component;
    private TreeSelectionListener treeSelectionListener;
    private PM_WindowMain windowMain;
    private JTextField hitsNewTree;
    private JButton newDiashow;
    private final Color colorRechts = Color.YELLOW;
    protected JButton importButtonExternal = null;
    private JTextField importDirField;
    private JTextArea textExternal;
    private TitledBorder titleExtern;
    protected JButton importButtonInternal = null;
    private JTextArea textInternal;
    private TitledBorder titleIntern;

    public PM_WindowImportGUI(PM_WindowImport pM_WindowImport, PM_WindowMain pM_WindowMain) {
        this.master = pM_WindowImport;
        this.windowMain = pM_WindowMain;
        this.border = BorderFactory.createLineBorder(Color.GRAY, 3);
        this.treeSelectionListener = new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                Object object = treeSelectionEvent.getSource();
                if (!(object instanceof PM_TreeWindow)) {
                    return;
                }
                PM_TreeWindow pM_TreeWindow = (PM_TreeWindow)object;
                TreePath treePath = treeSelectionEvent.getPath();
                Object object2 = treePath.getLastPathComponent();
                if (object2 instanceof DefaultMutableTreeNode) {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object2;
                    PM_WindowImportGUI.this.selectSequence(defaultMutableTreeNode, pM_TreeWindow);
                }
            }
        };
        JScrollPane jScrollPane = new JScrollPane(this.getNew());
        this.component = new JPanel(new BorderLayout());
        this.component.add((Component)this.getImportExternalPanel(), "North");
        this.component.add((Component)this.getImportInternalPanel(), "Center");
        this.component.add((Component)jScrollPane, "South");
        PM_Listener pM_Listener = new PM_Listener(){

            public void actionPerformed(PM_Action pM_Action) {
                PM_WindowImportGUI.this.setMsg();
            }
        };
        PM_MSG.addChangeListener(pM_Listener);
        this.setMsg();
    }

    private void setMsg() {
        this.newDiashow.setText(PM_MSG.getMsg("diashow"));
        this.textExternal.setText(PM_MSG.getMsg("winImpPicsFromExtern"));
        this.importButtonExternal.setText(PM_MSG.getMsg("winImpButtFromExtern"));
        this.titleExtern.setTitle(PM_MSG.getMsg("winImpTitleExtern"));
        this.textInternal.setText(PM_MSG.getMsg("winImpPicsFromIntern"));
        this.importButtonInternal.setText(PM_MSG.getMsg("winImpButtFromIntern"));
        this.titleIntern.setTitle(PM_MSG.getMsg("winImpTitleIntern"));
    }

    private void selectSequence(DefaultMutableTreeNode defaultMutableTreeNode, PM_TreeWindow pM_TreeWindow) {
        Object object;
        PM_Sequence pM_Sequence = null;
        Object object2 = defaultMutableTreeNode.getUserObject();
        if (object2 instanceof PM_Sequence) {
            pM_Sequence = (PM_Sequence)object2;
        }
        int n = 0;
        if (pM_Sequence != null) {
            object = new PM_SearchExpr(PM_Interface.SearchType.SEQ);
            ((PM_SearchExpr)object).setSequenz(pM_Sequence);
            PM_Search pM_Search = new PM_Search((PM_SearchExpr)object);
            n = pM_Search.search();
        }
        object = String.valueOf(n);
        if (pM_TreeWindow == this.treeWindowNew) {
            this.hitsNewTree.setText((String)object);
        }
    }

    private JPanel getNew() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        JButton jButton = PM_Utils.getJButon("1leftarrow.png");
        jPanel.add(jButton);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                List<PM_Picture> list = PM_WindowImportGUI.this.getPictureList(PM_WindowImportGUI.this.treeWindowNew.getSelectedNode());
                if (list.size() == 0) {
                    return;
                }
                PM_WindowImportGUI.this.windowMain.getIndexViewThumbnails().setAndPaintPictureList(list);
            }
        };
        jButton.addActionListener(actionListener);
        JButton jButton2 = PM_Utils.getJButon("2leftarrow.png");
        jPanel.add(jButton2);
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                List<PM_Picture> list = PM_WindowImportGUI.this.getPictureList(PM_WindowImportGUI.this.treeWindowNew.getSelectedNode());
                if (list.size() == 0) {
                    return;
                }
                PM_WindowImportGUI.this.windowMain.getIndexViewThumbnails().appendPictureList(list);
            }
        };
        jButton2.addActionListener(actionListener2);
        this.hitsNewTree = new JTextField("");
        this.hitsNewTree.setForeground(Color.BLACK);
        this.hitsNewTree.setEditable(false);
        this.hitsNewTree.setFocusable(false);
        this.hitsNewTree.setColumns(4);
        jPanel.add(this.hitsNewTree);
        Font font = this.hitsNewTree.getFont();
        Font font2 = new Font(font.getName(), 1, font.getSize());
        this.hitsNewTree.setFont(font2);
        this.newDiashow = new JButton("?Diashow?");
        jPanel.add(this.newDiashow);
        ActionListener actionListener3 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowImportGUI.this.startDiashowFromTreeWindow(PM_WindowImportGUI.this.treeWindowNew.getSelectedNode());
            }
        };
        this.newDiashow.addActionListener(actionListener3);
        JPanel jPanel2 = new JPanel();
        jPanel2.setAlignmentX(0.0f);
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.add(jPanel);
        JScrollPane jScrollPane = new JScrollPane(jPanel2);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        this.treeWindowNew = new PM_TreeWindowNew(this.master);
        this.treeWindowNew.addTreeSelectionListener(this.treeSelectionListener);
        JScrollPane jScrollPane2 = new JScrollPane(this.treeWindowNew);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jScrollPane, "North");
        jPanel3.add((Component)jScrollPane2, "Center");
        return jPanel3;
    }

    private void startDiashowFromTreeWindow(DefaultMutableTreeNode defaultMutableTreeNode) {
        List<PM_Picture> list = this.getPictureList(defaultMutableTreeNode);
        if (list.size() == 0) {
            return;
        }
        this.windowMain.doDiaShow(list.get(0), list, 1);
    }

    public List<PM_Picture> getPictureList(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode == null) {
            return new ArrayList<PM_Picture>();
        }
        PM_Sequence pM_Sequence = null;
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof PM_Sequence) {
            pM_Sequence = (PM_Sequence)object;
        }
        if (pM_Sequence == null) {
            return new ArrayList<PM_Picture>();
        }
        PM_SearchExpr pM_SearchExpr = new PM_SearchExpr(PM_Interface.SearchType.SEQ);
        pM_SearchExpr.setSequenz(pM_Sequence);
        PM_Search pM_Search = new PM_Search(pM_SearchExpr);
        int n = pM_Search.search();
        if (n == 0) {
            return new ArrayList<PM_Picture>();
        }
        return pM_Search.getPictureList(PM_Interface.SearchSortType.SEQ);
    }

    public JComponent getComponent() {
        return this.component;
    }

    public int buildPictureTree(File file) {
        int n = 0;
        this.treeWindowNew.expandTree(-1);
        return n;
    }

    public void importDone() {
        this.importButtonExternal.setEnabled(false);
        this.importDirField.setText("");
    }

    private JPanel getImportExternalPanel() {
        this.textExternal = new JTextArea();
        String string = "Importieren von Bildern ausserhalb des Bilder-Verzeichnisses.";
        this.textExternal.setText(string);
        this.importButtonExternal = new JButton("Importieren extern");
        this.importButtonExternal.setEnabled(false);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowImportGUI.this.importButtonExternal.setEnabled(false);
                PM_WindowImportGUI.this.master.doImportExternal();
                PM_WindowImportGUI.this.importButtonExternal.setEnabled(false);
            }
        };
        this.importButtonExternal.addActionListener(actionListener);
        JPanel jPanel = new JPanel();
        jPanel.setBackground(this.colorRechts);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setAlignmentY(0.0f);
        jPanel.add(this.textExternal);
        jPanel.add(this.importButtonExternal);
        this.titleExtern = BorderFactory.createTitledBorder(this.border, "Importieren Bilder von extern");
        jPanel.setBorder(this.titleExtern);
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.setBackground(this.colorRechts);
        jPanel2.add(jPanel);
        return jPanel2;
    }

    private JPanel getImportInternalPanel() {
        this.textInternal = new JTextArea();
        String string = "Importieren von Bildern innerhalb des Bilder-Verzeichnisses.";
        this.textInternal.setText(string);
        this.importButtonInternal = new JButton("Importieren intern");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_ImportInternal pM_ImportInternal = new PM_ImportInternal();
                pM_ImportInternal.checkAndImport();
            }
        };
        this.importButtonInternal.addActionListener(actionListener);
        JPanel jPanel = new JPanel();
        jPanel.setBackground(this.colorRechts);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setAlignmentY(0.0f);
        jPanel.add(this.textInternal);
        jPanel.add(this.importButtonInternal);
        this.titleIntern = BorderFactory.createTitledBorder(this.border, "Importieren Bilder von intern");
        jPanel.setBorder(this.titleIntern);
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.setBackground(this.colorRechts);
        jPanel2.add(jPanel);
        return jPanel2;
    }
}

