/*
 * Decompiled with CFR 0.152.
 */
package pm.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import pm.gui.PM_IndexView;
import pm.gui.PM_WindowMain;
import pm.inout.PM_SequencesInout;
import pm.picture.PM_Picture;
import pm.sequence.PM_Sequence;
import pm.utilities.PM_Configuration;
import pm.utilities.PM_Interface;
import pm.utilities.PM_Utils;
import pm.utilities.PM_UtilsGrafik;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PM_WindowSlideshow
extends JPanel
implements PM_Interface {
    private boolean tempViewed = false;
    private List<PM_Picture> pictureList = null;
    private PM_Picture picture = null;
    private List<PM_Picture> tempPictureList;
    private PM_Picture pictureOrig = null;
    private List<PM_Picture> pictureListOrig = null;
    private Image imageOriginal = null;
    private PM_WindowMain windowMain = null;
    private final JDialog dialog;
    private JLabel labelAnzahl = null;
    private JPanel picturePanel = null;
    private JPanel lowerPanel = null;
    private boolean aendernAufrufen = false;
    private JLabel labelBezeichnung = null;
    private JLabel labelTime = null;
    private int fontSize = 30;
    private JLabel bearbeitet = null;
    private Timer timer = null;
    private boolean automatic = false;
    private boolean automaticSequ = false;
    private int timeSeconds = 4;
    private Random random = new Random();
    private JLabel temporare;

    public PM_WindowSlideshow(PM_WindowMain pM_WindowMain, JDialog jDialog) {
        this.windowMain = pM_WindowMain;
        this.dialog = jDialog;
        this.tempPictureList = PM_IndexView.getTempPictureList();
        KeyAdapter keyAdapter = new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (PM_Utils.isTemp(keyEvent)) {
                    PM_WindowSlideshow.this.doTemp();
                }
                if (PM_Utils.isTempDelete(keyEvent)) {
                    PM_WindowSlideshow.this.doTempDelete();
                }
                if (PM_Utils.isTempViewed(keyEvent)) {
                    PM_WindowSlideshow.this.doTempViewed();
                }
            }
        };
        this.addKeyListener(keyAdapter);
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowSlideshow.this.keyPressedPfeil(38);
            }
        };
        AbstractAction abstractAction2 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowSlideshow.this.keyPressedPfeil(40);
            }
        };
        AbstractAction abstractAction3 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowSlideshow.this.keyPressedPfeil(37);
            }
        };
        AbstractAction abstractAction4 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowSlideshow.this.keyPressedPfeil(39);
            }
        };
        AbstractAction abstractAction5 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowSlideshow.this.keyPressedEscape();
            }
        };
        AbstractAction abstractAction6 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowSlideshow.this.keyPressedEnter();
            }
        };
        AbstractAction abstractAction7 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowSlideshow.this.keyPressedPlusMinus(521);
            }
        };
        AbstractAction abstractAction8 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowSlideshow.this.keyPressedPlusMinus(45);
            }
        };
        AbstractAction abstractAction9 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowSlideshow.this.keyPressedKategorie(49);
            }
        };
        AbstractAction abstractAction10 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowSlideshow.this.keyPressedKategorie(50);
            }
        };
        AbstractAction abstractAction11 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowSlideshow.this.keyPressedKategorie(51);
            }
        };
        AbstractAction abstractAction12 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowSlideshow.this.keyPressedKategorie(52);
            }
        };
        AbstractAction abstractAction13 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowSlideshow.this.keyPressedRotate(PM_Interface.Rotate.LEFT);
            }
        };
        AbstractAction abstractAction14 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowSlideshow.this.keyPressedRotate(PM_Interface.Rotate.RIGHT);
            }
        };
        AbstractAction abstractAction15 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowSlideshow.this.keyPressedSpiegeln(83);
            }
        };
        InputMap inputMap = this.getInputMap();
        ActionMap actionMap = this.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(76, 0), "VK_L");
        actionMap.put("VK_L", abstractAction13);
        inputMap.put(KeyStroke.getKeyStroke(82, 0), "VK_R");
        actionMap.put("VK_R", abstractAction14);
        inputMap.put(KeyStroke.getKeyStroke(83, 0), "VK_S");
        actionMap.put("VK_S", abstractAction15);
        inputMap.put(KeyStroke.getKeyStroke(49, 0), "VK_1");
        actionMap.put("VK_1", abstractAction9);
        inputMap.put(KeyStroke.getKeyStroke(50, 0), "VK_2");
        actionMap.put("VK_2", abstractAction10);
        inputMap.put(KeyStroke.getKeyStroke(51, 0), "VK_3");
        actionMap.put("VK_3", abstractAction11);
        inputMap.put(KeyStroke.getKeyStroke(52, 0), "VK_4");
        actionMap.put("VK_4", abstractAction12);
        inputMap.put(KeyStroke.getKeyStroke(38, 0), "VK_UP");
        actionMap.put("VK_UP", abstractAction);
        inputMap.put(KeyStroke.getKeyStroke(40, 0), "VK_DOWN");
        actionMap.put("VK_DOWN", abstractAction2);
        inputMap.put(KeyStroke.getKeyStroke(37, 0), "VK_LEFT");
        actionMap.put("VK_LEFT", abstractAction3);
        inputMap.put(KeyStroke.getKeyStroke(39, 0), "VK_RIGHT");
        actionMap.put("VK_RIGHT", abstractAction4);
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "VK_ESCAPE");
        actionMap.put("VK_ESCAPE", abstractAction5);
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "VK_ENTER");
        actionMap.put("VK_ENTER", abstractAction6);
        inputMap.put(KeyStroke.getKeyStroke(521, 0), "VK_PLUS");
        actionMap.put("VK_PLUS", abstractAction7);
        inputMap.put(KeyStroke.getKeyStroke(45, 0), "VK_MINUS");
        actionMap.put("VK_MINUS", abstractAction8);
        this.picturePanel = this.getPicturePanel();
        this.addMouseListener(new MyMouseAdapter());
        this.lowerPanel = this.getLowerShowPanel();
        this.setLayout(new BorderLayout());
        this.add((Component)this.picturePanel, "Center");
        this.add((Component)this.lowerPanel, "South");
    }

    public void keyPressedFkt(int n) {
        if (n == 1) {
            if (this.automatic) {
                this.stopAutomatic();
            }
            this.updateStatusZeile();
            this.picturePanel.repaint();
            return;
        }
        this.startAutomatic(n == 2);
    }

    private void keyPressedPfeil(int n) {
        if (n == 38) {
            return;
        }
        if (n == 40) {
            return;
        }
        if (this.automatic) {
            this.stopAutomatic();
        }
        if (n == 39) {
            this.doZeigenNextBild();
        }
        if (n == 37) {
            this.doZeigenPreviousBild();
        }
    }

    private void keyPressedKategorie(int n) {
        switch (n) {
            case 49: {
                this.picture.meta.setCategory("1");
                break;
            }
            case 50: {
                this.picture.meta.setCategory("2");
                break;
            }
            case 51: {
                this.picture.meta.setCategory("3");
                break;
            }
            case 52: {
                this.picture.meta.setCategory("4");
            }
        }
        this.updateStatusZeile();
    }

    private void keyPressedRotate(PM_Interface.Rotate rotate) {
        int n = PM_Utils.getNextRotation(this.picture.meta.getRotation(), rotate);
        this.picture.meta.setRotation(n);
        this.updateStatusZeile();
        this.picturePanel.repaint();
        this.windowMain.rereadPictureViewThumbnail(this.picture);
    }

    private void keyPressedSpiegeln(int n) {
        this.updateStatusZeile();
        this.picturePanel.repaint();
        this.windowMain.rereadPictureViewThumbnail(this.picture);
    }

    private void doTemp() {
        if (this.tempPictureList.contains(this.picture)) {
            this.tempPictureList.remove(this.picture);
        } else {
            this.tempPictureList.add(this.picture);
        }
        this.updateStatusZeile();
    }

    private void doTempDelete() {
        if (this.tempPictureList.size() == 0) {
            return;
        }
        int n = JOptionPane.showConfirmDialog(this, "Sollen alle Temp Bilder gel\u00f6scht werden?", "Sicherheitsabfrage", 0, 3);
        if (n == 1) {
            return;
        }
        this.tempPictureList.clear();
        this.updateStatusZeile();
    }

    private void doTempViewed() {
        if (this.tempPictureList.size() == 0) {
            JOptionPane.showConfirmDialog(this, "Keine Temp-Bilder-Liste", "keine Temp-Liste", -1, 1);
            return;
        }
        this.stopAutomatic();
        if (this.tempViewed) {
            this.tempViewed = false;
            this.pictureList = this.pictureListOrig;
            this.picture = this.pictureOrig;
        } else {
            this.tempViewed = true;
            this.pictureList = this.tempPictureList;
            this.pictureOrig = this.picture;
            this.picture = this.tempPictureList.get(0);
        }
        this.doZeigenBild();
    }

    private void keyPressedPlusMinus(int n) {
        if (!this.automatic) {
            return;
        }
        if (this.timeSeconds < 2 && n == 45) {
            return;
        }
        if (n == 521) {
            ++this.timeSeconds;
        }
        if (n == 45) {
            --this.timeSeconds;
        }
    }

    private void keyPressedEscape() {
        this.stopDiashow();
    }

    private void keyPressedEnter() {
        this.aendernAufrufen = true;
        this.stopDiashow();
    }

    public boolean start(PM_Picture pM_Picture, List<PM_Picture> list, int n) {
        PM_SequencesInout.getInstance().flush();
        if (pM_Picture == null) {
            return false;
        }
        this.picture = pM_Picture;
        this.pictureList = list;
        this.pictureListOrig = list;
        this.tempViewed = false;
        this.aendernAufrufen = false;
        if (n != 1) {
            this.automatic = true;
            this.automaticSequ = n == 2;
            this.timer = new Timer();
            this.timer.schedule((TimerTask)new MyTimerTask(), this.timeSeconds * 1000);
        }
        this.doZeigenBild();
        return true;
    }

    public boolean getAendernAufrufen() {
        return this.aendernAufrufen;
    }

    private void stopDiashow() {
        this.stopAutomatic();
        this.dialog.dispose();
    }

    private void startAutomatic(boolean bl) {
        if (this.automatic && this.automaticSequ == bl) {
            return;
        }
        this.automatic = true;
        this.automaticSequ = bl;
        boolean bl2 = this.doZeigenNextBild();
        if (!bl2) {
            this.stopAutomatic();
            return;
        }
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new MyTimerTask(), this.timeSeconds * 1000);
    }

    private void stopAutomatic() {
        this.automatic = false;
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    private Point getMoveAfterRotation(int n, Rectangle rectangle) {
        int n2 = 0;
        int n3 = 0;
        if (n == 90) {
            n2 = rectangle.width;
            n3 = 0;
        } else if (n == 270) {
            n2 = 0;
            n3 = rectangle.height;
        } else if (n == 180) {
            n2 = rectangle.height;
            n3 = rectangle.width;
        }
        return new Point(n2, n3);
    }

    private JPanel getPicturePanel() {
        JPanel jPanel = new JPanel(){

            public void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                Graphics2D graphics2D = (Graphics2D)graphics;
                if (PM_WindowSlideshow.this.imageOriginal != null) {
                    Rectangle rectangle = new Rectangle(PM_WindowSlideshow.this.picturePanel.getWidth(), PM_WindowSlideshow.this.picturePanel.getHeight());
                    Rectangle rectangle2 = new Rectangle(PM_UtilsGrafik.getImageSize(PM_WindowSlideshow.this.imageOriginal));
                    Rectangle rectangle3 = ((PM_WindowSlideshow)PM_WindowSlideshow.this).picture.meta.hasCutRectangle() ? ((PM_WindowSlideshow)PM_WindowSlideshow.this).picture.meta.getCutRectangle() : rectangle2;
                    int n = ((PM_WindowSlideshow)PM_WindowSlideshow.this).picture.meta.getRotation();
                    Rectangle rectangle4 = new Rectangle(PM_WindowSlideshow.this.imageOriginal.getWidth(this), PM_WindowSlideshow.this.imageOriginal.getHeight(this));
                    if (n != 0) {
                        rectangle4.setSize(rectangle4.height, rectangle4.width);
                        rectangle3 = PM_UtilsGrafik.rotateCutRectangle(n, rectangle3, rectangle2);
                    }
                    double d = 0.0;
                    d = PM_UtilsGrafik.getRatio(rectangle3) < PM_UtilsGrafik.getRatio(rectangle) ? (double)rectangle.height / (double)rectangle3.height : (double)rectangle.width / (double)rectangle3.width;
                    int n2 = (rectangle.width + 1) / 2;
                    int n3 = (int)((double)((rectangle3.width + 1) / 2) * d);
                    int n4 = n2 - n3;
                    int n5 = (rectangle.height + 1) / 2;
                    int n6 = (int)((double)((rectangle3.height + 1) / 2) * d);
                    int n7 = n5 - n6;
                    AffineTransform affineTransform = new AffineTransform();
                    affineTransform.translate(n4, n7);
                    affineTransform.translate((double)(-rectangle3.x) * d, (double)(-rectangle3.y) * d);
                    affineTransform.scale(d, d);
                    Point point = PM_WindowSlideshow.this.getMoveAfterRotation(n, rectangle4);
                    affineTransform.translate(point.x, point.y);
                    affineTransform.rotate((double)((PM_WindowSlideshow)PM_WindowSlideshow.this).picture.meta.getRotation() * Math.PI / 180.0);
                    Rectangle rectangle5 = graphics2D.getClipBounds();
                    graphics2D.setClip(n4, n7, (int)((double)rectangle3.width * d), (int)((double)rectangle3.height * d));
                    graphics2D.drawImage(PM_WindowSlideshow.this.imageOriginal, affineTransform, this);
                    graphics2D.setClip(rectangle5.x, rectangle5.y, rectangle5.width, rectangle5.height);
                }
            }
        };
        jPanel.setBackground(Color.BLACK);
        return jPanel;
    }

    private JPanel getLowerShowPanel() {
        Color color = Color.red;
        JPanel jPanel = new JPanel();
        jPanel.setBackground(color);
        jPanel.setPreferredSize(new Dimension(0, 30));
        FlowLayout flowLayout = new FlowLayout(0);
        jPanel.setLayout(flowLayout);
        this.temporare = new JLabel();
        this.temporare.setFont(new Font("Arial", 1, this.fontSize));
        jPanel.add(this.temporare);
        this.labelTime = new JLabel("   ");
        jPanel.add(this.labelTime);
        this.labelTime.setFont(new Font("Arial", 1, 20));
        this.bearbeitet = new JLabel("   ");
        jPanel.add(this.bearbeitet);
        this.bearbeitet.setFont(new Font("Arial", 1, this.fontSize));
        this.labelAnzahl = new JLabel("   ");
        jPanel.add(this.labelAnzahl);
        this.labelAnzahl.setFont(new Font("Arial", 1, this.fontSize));
        this.labelBezeichnung = new JLabel();
        jPanel.add(this.labelBezeichnung);
        this.labelBezeichnung.setFont(new Font("Arial", 1, this.fontSize));
        jPanel.setPreferredSize(new Dimension(0, this.fontSize + 10));
        return jPanel;
    }

    private void doZeigenBild() {
        Cursor cursor = this.getCursor();
        this.setCursor(new Cursor(3));
        boolean bl = true;
        this.imageOriginal = this.getImageOriginal(bl);
        this.updateStatusZeile();
        this.picturePanel.repaint();
        this.setCursor(cursor);
    }

    private boolean doZeigenNextBild() {
        if (this.automatic && !this.automaticSequ) {
            return this.doZeigenNextBildRandom();
        }
        int n = this.pictureList.indexOf(this.picture);
        if (n == -1 || n + 1 >= this.pictureList.size()) {
            JOptionPane.showConfirmDialog(this, "Keine weiteren Bilder", "Ende", -1, 1);
            return false;
        }
        this.picture = this.pictureList.get(n + 1);
        Cursor cursor = this.getCursor();
        this.setCursor(new Cursor(3));
        boolean bl = true;
        this.imageOriginal = this.getImageOriginal(bl);
        this.updateStatusZeile();
        this.picturePanel.repaint();
        this.setCursor(cursor);
        return true;
    }

    private void doZeigenPreviousBild() {
        int n = this.pictureList.indexOf(this.picture);
        if (n <= 0) {
            JOptionPane.showConfirmDialog(this, "Keine weiteren Bilder", "Ende", -1, 1);
            return;
        }
        this.picture = this.pictureList.get(n - 1);
        Cursor cursor = this.getCursor();
        this.setCursor(new Cursor(3));
        boolean bl = false;
        this.imageOriginal = this.getImageOriginal(bl);
        this.updateStatusZeile();
        this.picturePanel.repaint();
        this.setCursor(cursor);
    }

    private boolean doZeigenNextBildRandom() {
        this.imageOriginal = this.getImageOriginalRandom();
        if (this.imageOriginal == null) {
            return false;
        }
        Cursor cursor = this.getCursor();
        this.setCursor(new Cursor(3));
        this.updateStatusZeile();
        this.picturePanel.repaint();
        this.setCursor(cursor);
        return true;
    }

    private Image getImageOriginal(boolean bl) {
        List<PM_Picture> list = Collections.singletonList(this.picture);
        List<PM_Picture> list2 = PM_WindowSlideshow.getPrefetchList(this.picture, this.pictureList, bl);
        PM_Picture.readImageOriginal(list, list2);
        return this.picture.getImageOriginal();
    }

    public PM_Picture getPicture() {
        return this.picture;
    }

    public static List<PM_Picture> getPrefetchList(PM_Picture pM_Picture, List<PM_Picture> list, boolean bl) {
        int n;
        int n2;
        int n3;
        ArrayList<PM_Picture> arrayList = new ArrayList<PM_Picture>();
        int n4 = list.indexOf(pM_Picture);
        if (n4 == -1) {
            return arrayList;
        }
        PM_Configuration pM_Configuration = PM_Configuration.getInstance();
        if (bl) {
            n3 = pM_Configuration.getPrefetchPlus();
            n2 = pM_Configuration.getPrefetchMinus();
        } else {
            n2 = pM_Configuration.getPrefetchPlus();
            n3 = pM_Configuration.getPrefetchMinus();
        }
        for (n = 0; n < n3 && n4 + 2 < list.size(); ++n) {
            arrayList.add(list.get(n4 + 1));
            ++n4;
        }
        for (n = 0; n < n2 && n4 != 0; --n4, ++n) {
            arrayList.add(list.get(n4 - 1));
        }
        return arrayList;
    }

    private Image getImageOriginalRandom() {
        this.picture = this.pictureList.get(this.random.nextInt(this.pictureList.size()));
        List<PM_Picture> list = Collections.singletonList(this.picture);
        PM_Picture.readImageOriginal(list, new ArrayList<PM_Picture>());
        return this.picture.getImageOriginal();
    }

    private void updateStatusZeile() {
        this.setLabelAnzahl();
        this.setTextUnterBild();
        this.setBearbeitet();
        this.setTimeSeconds();
        this.setTemporare();
    }

    private void setTextUnterBild() {
        PM_Configuration pM_Configuration = PM_Configuration.getInstance();
        String string = "";
        string = this.addText(string, pM_Configuration.getSlideshowText1());
        string = this.addText(string, pM_Configuration.getSlideshowText2());
        string = this.addText(string, pM_Configuration.getSlideshowText3());
        this.labelBezeichnung.setText(string);
    }

    private String addText(String string, String string2) {
        String string3 = "";
        if (string2.equals("index1")) {
            string3 = this.picture.meta.getIndex1();
        } else if (string2.equals("index2")) {
            string3 = this.picture.meta.getIndex2();
        } else if (string2.equals("datum")) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy");
            string3 = simpleDateFormat.format(this.picture.meta.getDateCurrent());
        } else if (string2.equals("bemerkung") || string2.equals("bemerkungen")) {
            string3 = this.picture.meta.getRemarks();
        } else if (string2.equals("name")) {
            File file = this.picture.meta.getFileOriginal();
            string3 = file.getName();
        } else if (string2.equals("kategorie")) {
            string3 = "K";
            string3 = string3 + this.picture.meta.getCategory();
        } else if (string2.equals("serie")) {
            String string4 = this.picture.meta.getSequence();
            String[] stringArray = string4.split(" ");
            for (int i = 0; i < stringArray.length; ++i) {
                String string5 = stringArray[i];
                if (string5.indexOf("s") < 0) continue;
                String[] stringArray2 = string5.split("_");
                if (stringArray2.length != 2) break;
                PM_Sequence pM_Sequence = PM_Sequence.getSequenzFromAll(stringArray2[0]);
                if (pM_Sequence.getType() != PM_Interface.SequenceType.BASE && pM_Sequence.getType() != PM_Interface.SequenceType.EXTENDED) continue;
                string3 = pM_Sequence.getPath();
                break;
            }
        }
        if (string3.length() == 0) {
            return string;
        }
        if (string.length() == 0) {
            return string3;
        }
        return string + " " + string3;
    }

    private void setBearbeitet() {
        boolean bl = this.picture.meta.hasCutRectangle();
        if (bl) {
            this.bearbeitet.setText("#");
            return;
        }
        if (this.picture.meta.getModified()) {
            this.bearbeitet.setText("x");
        } else {
            this.bearbeitet.setText("");
        }
    }

    private void setTimeSeconds() {
        if (!this.automatic) {
            this.labelTime.setText("");
            return;
        }
        String string = Integer.toString(this.timeSeconds);
        if (!this.automaticSequ) {
            string = string + "r";
        }
        this.labelTime.setText(string);
    }

    private void setLabelAnzahl() {
        int n = this.pictureList.size();
        int n2 = this.pictureList.indexOf(this.picture);
        String string = Integer.toString(n2 + 1) + "/" + Integer.toString(n);
        this.labelAnzahl.setText(string);
    }

    private void setTemporare() {
        if (this.tempViewed) {
            this.temporare.setText("T");
            return;
        }
        if (this.tempPictureList.contains(this.picture)) {
            this.temporare.setText("t");
            return;
        }
        this.temporare.setText(" ");
    }

    class MyMouseAdapter
    extends MouseAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 3) {
                PM_WindowSlideshow.this.keyPressedPfeil(39);
                return;
            }
            if (mouseEvent.getButton() == 1) {
                PM_WindowSlideshow.this.keyPressedPfeil(37);
                return;
            }
        }
    }

    class MyKeyAdapter
    extends KeyAdapter {
        MyKeyAdapter() {
        }

        public void keyPressed(KeyEvent keyEvent) {
        }
    }

    class RadioListener
    implements ActionListener {
        RadioListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand().substring(1);
            ((PM_WindowSlideshow)PM_WindowSlideshow.this).picture.meta.setCategory(string);
        }
    }

    class MyTimerTask
    extends TimerTask {
        MyTimerTask() {
        }

        public void run() {
            boolean bl = PM_WindowSlideshow.this.doZeigenNextBild();
            if (!bl) {
                PM_WindowSlideshow.this.stopAutomatic();
                return;
            }
            if (PM_WindowSlideshow.this.timer != null) {
                PM_WindowSlideshow.this.timer.cancel();
            }
            PM_WindowSlideshow.this.timer = new Timer();
            PM_WindowSlideshow.this.timer.schedule((TimerTask)new MyTimerTask(), PM_WindowSlideshow.this.timeSeconds * 1000);
        }
    }
}

