/*
 * Decompiled with CFR 0.152.
 */
package pm.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import pm.inout.PM_Export;
import pm.picture.PM_Import;
import pm.picture.PM_MetadataContainer;
import pm.utilities.PM_Action;
import pm.utilities.PM_Interface;
import pm.utilities.PM_Listener;
import pm.utilities.PM_MSG;

public class PM_WindowStatusPanel
extends JPanel
implements PM_Interface {
    private JDialog dialog;
    private JLabel picStatus = null;
    private JLabel importText = null;
    private boolean initDone = false;
    private JProgressBar progressionBar = null;
    private PM_Listener metadatenChangeListener;
    private PM_MetadataContainer metadatenContainer;
    private static PM_WindowStatusPanel instance = new PM_WindowStatusPanel();
    private Timer importTimer = null;
    private static boolean importToggle = false;

    public static PM_WindowStatusPanel getInstance() {
        return instance;
    }

    public void init() {
        this.metadatenContainer = PM_MetadataContainer.getInstance();
        JPanel jPanel = this.getPanelLinks();
        JPanel jPanel2 = this.getPanelRechts();
        this.setLayout(new BorderLayout());
        this.setBackground(Color.yellow);
        this.add((Component)jPanel, "West");
        this.add((Component)jPanel2, "East");
        this.initDone = true;
        PM_Listener pM_Listener = new PM_Listener(){

            public void actionPerformed(PM_Action pM_Action) {
                if (pM_Action.getObject() == null) {
                    PM_WindowStatusPanel.this.updateAnzahlBilder();
                }
            }
        };
        PM_Import.addImportListener(pM_Listener);
        PM_Export.addDeleteListener(pM_Listener);
        PM_Listener pM_Listener2 = new PM_Listener(){

            public void actionPerformed(PM_Action pM_Action) {
                PM_WindowStatusPanel.this.setMsg();
            }
        };
        PM_MSG.addChangeListener(pM_Listener2);
        this.setMsg();
    }

    private void setMsg() {
        this.updateAnzahlBilder();
    }

    public void updateAnzahlBilder() {
        int n = PM_MetadataContainer.getInstance().getPictureSizeValid();
        int n2 = PM_MetadataContainer.getInstance().getPictureSizeInvalid();
        this.picStatus.setText(String.format(PM_MSG.getMsg("winStatPicSize"), n, n2));
    }

    public void progressionBarInit(Object object, int n) {
        this.progressionBar.setMinimum(1);
        this.progressionBar.setMaximum(n);
        this.progressionBar.setValue(0);
    }

    public void progressionBarSetValue(Object object, final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PM_WindowStatusPanel.this.progressionBar.setValue(n);
            }
        });
    }

    public void progressionBarStop(Object object) {
        if (this.dialog != null) {
            this.dialog.dispose();
        }
    }

    public void progressionBarStart() {
        this.dialog = new JDialog((Frame)new JFrame(), true);
        this.dialog.setUndecorated(false);
        this.dialog.pack();
        this.dialog.setVisible(true);
    }

    private PM_WindowStatusPanel() {
    }

    private JPanel getPanelLinks() {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.yellow);
        jPanel.setLayout(new FlowLayout(0));
        this.picStatus = new JLabel();
        jPanel.add(this.picStatus);
        this.importText = new JLabel();
        jPanel.add(this.importText);
        this.metadatenChangeListener = new PM_Listener(){

            public void actionPerformed(PM_Action pM_Action) {
                if (pM_Action.getObject() instanceof PM_MetadataContainer) {
                    // empty if block
                }
            }
        };
        this.metadatenContainer.addChangeListener(this.metadatenChangeListener);
        return jPanel;
    }

    private JPanel getPanelRechts() {
        JPanel jPanel = new JPanel();
        this.progressionBar = new JProgressBar();
        this.progressionBar.setForeground(Color.RED);
        jPanel.add(this.progressionBar);
        return jPanel;
    }

    public void startImportTimer() {
        if (this.importTimer == null) {
            return;
        }
        this.importTimer = new Timer();
        this.importTimer.schedule((TimerTask)new ImportTimerTask(), 0L, 1000L);
    }

    public void stopImportTimer() {
        if (this.importTimer == null) {
            return;
        }
        this.importTimer.cancel();
        instance.hasNotImport();
    }

    private void hasImport() {
        this.importText.setText("           Neue Bilder importieren (Arbeitsfenster 'Importieren')");
    }

    private void hasNotImport() {
        this.importText.setText("");
    }

    public class ImportTimerTask
    extends TimerTask {
        public void run() {
            if (!instance.initDone) {
                return;
            }
            if (importToggle) {
                instance.hasImport();
                importToggle = !importToggle;
            } else {
                instance.hasNotImport();
                importToggle = !importToggle;
            }
        }
    }
}

