/*
 * Decompiled with CFR 0.152.
 */
package pm.inout;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.List;
import pm.picture.PM_MetadataContainer;
import pm.picture.PM_Picture;
import pm.search.PM_DatabaseLucene;
import pm.search.PM_Search;
import pm.search.PM_SearchExpr;
import pm.sequence.PM_Sequence;
import pm.utilities.PM_Action;
import pm.utilities.PM_Configuration;
import pm.utilities.PM_Interface;
import pm.utilities.PM_Listener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PM_VDR_Index
implements PM_Interface {
    private List<PM_Sequence> listeOffenenSequenzen;
    private PM_Search luceneSuchen;
    private PM_Configuration einstellungen;
    private File vdrPluginIndexFile;

    public PM_VDR_Index(File file) {
        this.vdrPluginIndexFile = file;
        this.einstellungen = PM_Configuration.getInstance();
    }

    public int getAnzahlSequenzen() {
        return this.listeOffenenSequenzen.size();
    }

    public void createAllDir(PM_Listener pM_Listener) {
        PM_DatabaseLucene.getInstance().flush();
        PM_MetadataContainer.getInstance().flush();
        this.deleteAllDir();
        for (PM_Sequence pM_Sequence : this.listeOffenenSequenzen) {
            if (pM_Listener != null) {
                pM_Listener.actionPerformed(new PM_Action(pM_Sequence));
            }
            List<PM_Picture> list = this.getPictureList(pM_Sequence);
            this.createFileForOneSequence(list, pM_Sequence);
        }
    }

    private List<PM_Picture> getPictureList(PM_Sequence pM_Sequence) {
        PM_SearchExpr pM_SearchExpr = new PM_SearchExpr(PM_Interface.SearchType.SEQ);
        pM_SearchExpr.setSequenz(pM_Sequence);
        this.luceneSuchen = new PM_Search(pM_SearchExpr);
        this.luceneSuchen.search();
        return this.luceneSuchen.getPictureList(PM_Interface.SearchSortType.SEQ);
    }

    private void createFileForOneSequence(List<PM_Picture> list, PM_Sequence pM_Sequence) {
        if (list == null) {
            return;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (PM_Picture object2 : list) {
            int file = object2.meta.getCategory();
            if (file == 1) {
                ++n;
            }
            if (file == 2) {
                ++n2;
            }
            if (file == 3) {
                ++n3;
            }
            if (file != 4) continue;
            ++n4;
        }
        String string = this.vdrPluginIndexFile.getAbsolutePath() + File.separator + this.einstellungen.getVdrPluginName() + File.separator;
        File file = new File(string);
        File file2 = new File(file.getParent());
        file2.mkdirs();
        file.delete();
        try {
            file.createNewFile();
        }
        catch (IOException printWriter) {
            return;
        }
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file)));
        }
        catch (IOException pM_Picture) {
            return;
        }
        for (PM_Picture pM_Picture : list) {
            String string2;
            String string3 = pM_Picture.getFileOriginal().getAbsolutePath();
            if (string3.startsWith(string2 = this.einstellungen.getTopLevelPictureDirectory().getAbsolutePath()) && (string3 = string3.replaceFirst(string2, "")).startsWith(File.separator)) {
                string3 = string3.replaceFirst(File.separator, "");
            }
            string3 = this.einstellungen.getVdrPluginName() + File.separator + string3;
            String string4 = String.valueOf(pM_Picture.meta.getCategory());
            String string5 = pM_Picture.meta.getRemarks();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy");
            String string6 = simpleDateFormat.format(pM_Picture.meta.getDateCurrent());
            String string7 = "pic;d=" + string6 + ";q=" + string4;
            if (string5.length() > 0) {
                string5 = string5.replaceAll(";", "");
                string7 = string7 + ";bem=\"" + string5 + "\"";
            }
            string7 = string7 + ";f=" + string3 + ".mpg";
            printWriter.println(string7);
        }
        printWriter.close();
    }

    private void deleteAllDir() {
        PM_MetadataContainer.getInstance().flush();
        File file = new File(this.vdrPluginIndexFile.getAbsoluteFile() + File.separator + this.einstellungen.getVdrPluginName());
        this.deleteDir(file);
        file.mkdirs();
    }

    private boolean deleteDir(File file) {
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                boolean bl = this.deleteDir(new File(file, stringArray[i]));
                if (bl) continue;
                return false;
            }
        }
        return file.delete();
    }
}

