/*
 * Decompiled with CFR 0.152.
 */
package pm.inout;

import java.io.File;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.tree.DefaultElement;
import pm.utilities.PM_Interface;
import pm.utilities.PM_XML_Utils;

public class PM_XML
implements PM_Interface {
    protected Document document = null;
    protected String rootTagName = "";
    protected File xmlFile;
    private int versionRead = 0;
    private int versionWrite = 0;

    protected void openDocument(int n) {
        if (this.document != null) {
            return;
        }
        this.document = PM_XML_Utils.getDocumentFromXMLfile(this.xmlFile, this.rootTagName, n);
        if (this.document != null) {
            Element element = this.document.getRootElement();
            this.versionWrite = this.versionRead = PM_XML_Utils.getAttributeInt(element, "version");
        }
    }

    protected void closeDocument() {
        this.document = null;
    }

    protected void writeDocument() {
        Element element = this.document.getRootElement();
        this.updateAttribute(element, "version", Integer.toString(this.versionWrite));
        PM_XML_Utils.writeOutDocument(this.document, this.xmlFile);
        System.out.println("Schreiben XML-Datei nach: " + this.xmlFile.getPath());
    }

    public int getVersionRead() {
        return this.versionRead;
    }

    public int getVersionWrite() {
        return this.versionWrite;
    }

    public void setVersionWrite(int n) {
        this.versionWrite = n;
    }

    protected String getAttribute(Element element, String string) {
        if (element == null) {
            return "";
        }
        String string2 = element.attributeValue(string);
        if (string2 == null) {
            return "";
        }
        return string2;
    }

    protected int getAttributeInt(Element element, String string) {
        if (element == null) {
            return 0;
        }
        String string2 = this.getAttribute(element, string);
        if (string2.length() == 0) {
            return 0;
        }
        int n = 0;
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
        return n;
    }

    protected void updateAttribute(Element element, String string, String string2) {
        String string3 = string2;
        if (string3 != null && string3.length() == 0) {
            string3 = null;
        }
        element.addAttribute(string, string3);
    }

    protected void addTag(Element element, String string, String string2) {
        String string3 = string2;
        if (string3 != null && string3.length() == 0) {
            string3 = null;
        }
        List list = element.elements(string);
        Element element2 = null;
        if (list.size() == 0) {
            if (string3 == null) {
                return;
            }
            element2 = new DefaultElement(string);
            element2.setText(string3);
            list.add(element2);
            return;
        }
        if (string3 == null) {
            for (int i = 0; i < list.size(); ++i) {
                list.remove(i);
            }
            return;
        }
        element2 = (Element)list.get(0);
        element2.setText(string3);
    }

    protected String getTagValue(Element element, String string) {
        List list = element.elements(string);
        Element element2 = null;
        if (list.size() == 0) {
            return "";
        }
        element2 = (Element)list.get(0);
        String string2 = element2.getText();
        if (string2 == null) {
            return "";
        }
        return string2;
    }
}

