/*
 * Decompiled with CFR 0.152.
 */
package pm.picture;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.File;
import java.util.Date;
import java.util.Vector;
import pm.picture.PM_Picture;
import pm.utilities.PM_Action;
import pm.utilities.PM_Interface;
import pm.utilities.PM_Listener;
import pm.utilities.PM_Utils;

public class PM_PictureMetadaten
implements PM_Interface {
    public static final int UNKNOWN = 0;
    public static final int LOESCHEN_INDEX_FILE = 1;
    public static final int INDEX_1 = 10;
    public static final int QS = 11;
    public static final int BEMERKUNGEN = 12;
    public static final int HOEHE = 13;
    public static final int BREITE = 14;
    public static final int CUT_X = 15;
    public static final int CUT_Y = 16;
    public static final int CUT_BREITE = 17;
    public static final int CUT_HOEHE = 18;
    public static final int CUT_RECTANGLE = 19;
    public static final int INDEX_2 = 20;
    public static final int ROTATE = 21;
    public static final int DATUM = 22;
    public static final int BEARBEITET = 23;
    public static final int SEQUENZ = 24;
    public static final int SPIEGELN = 25;
    private String id = "";
    private String datum = "";
    private Date dateImport = null;
    private Date dateCurrent = null;
    private String qs = "3";
    private String rotate = "";
    private String index1 = "";
    private String bemerkungen = "";
    private String index2 = "";
    private String sequence = "";
    private boolean spiegeln = false;
    private String breite = "";
    private String hoehe = "";
    private String cutX = "";
    private String cutY = "";
    private String cutBreite = "";
    private String cutHoehe = "";
    private boolean bearbeitet = false;
    private boolean loeschen = false;
    private File fileOriginal;
    private boolean init = true;
    private static Vector<PM_Listener> alleChangeListener = new Vector();
    private PM_Picture picture;

    protected PM_PictureMetadaten(File file, PM_Picture pM_Picture) {
        this.fileOriginal = file;
        this.picture = pM_Picture;
        this.id = PM_Utils.fileOriginalToXmlId(file);
        long l = System.currentTimeMillis();
        this.dateImport = new Date(l);
        this.dateCurrent = new Date(l);
    }

    public void setInit(boolean bl) {
        this.init = bl;
    }

    public boolean getInit() {
        return this.init;
    }

    public static void addChangeListener(PM_Listener pM_Listener) {
        if (!alleChangeListener.contains(pM_Listener)) {
            alleChangeListener.add(pM_Listener);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setIndex1(String string) {
        if (!this.requestToUpdate()) {
            return;
        }
        String string2 = string.toLowerCase();
        if (this.hasUpdate(this.index1, string2 = PM_Utils.sortedSetToString(PM_Utils.getSortedSet(string2)))) {
            this.index1 = this.getUpdate(this.index1, string2);
            this.update(10);
        }
    }

    public String getIndex1() {
        return this.index1;
    }

    public void setIndex2(String string) {
        if (!this.requestToUpdate()) {
            return;
        }
        String string2 = string.toLowerCase();
        if (this.hasUpdate(this.index2, string2 = PM_Utils.sortedSetToString(PM_Utils.getSortedSet(string2)))) {
            this.index2 = this.getUpdate(this.index2, string2);
            this.update(20);
        }
    }

    public String getIndex2() {
        return this.index2;
    }

    public void setSequenz(String string) {
        if (!this.requestToUpdate()) {
            return;
        }
        String string2 = string.toLowerCase();
        if (this.hasUpdate(this.sequence, string2 = PM_Utils.sortedSetToString(PM_Utils.getSortedSet(string2)))) {
            this.sequence = this.getUpdate(this.sequence, string2);
            this.update(24);
        }
    }

    public String getSequence() {
        return this.sequence;
    }

    public boolean hasExtendedSequence() {
        String[] stringArray = this.sequence.split(" ");
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.indexOf("s") < 0) continue;
            return true;
        }
        return false;
    }

    public boolean hasBaseSequence() {
        String[] stringArray = this.sequence.split(" ");
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.indexOf("b") < 0) continue;
            return true;
        }
        return false;
    }

    public String getBaseSequenceName() {
        String[] stringArray = this.sequence.split(" ");
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.indexOf("b") < 0) continue;
            String[] stringArray2 = stringArray[i].split("_");
            if (stringArray2.length < 1) {
                return "";
            }
            return stringArray2[0];
        }
        return "";
    }

    public boolean hasClosedSequence() {
        String[] stringArray = this.sequence.split(" ");
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.indexOf("s") < 0) continue;
            return true;
        }
        return false;
    }

    public boolean hasNewSequence() {
        String[] stringArray = this.sequence.split(" ");
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.indexOf("n") < 0) continue;
            return true;
        }
        return false;
    }

    public boolean hasSequenz() {
        return this.hasNewSequence() || this.hasClosedSequence() || this.hasBaseSequence();
    }

    public boolean getModified() {
        return this.bearbeitet;
    }

    public void setModified(boolean bl) {
        if (!this.requestToUpdate()) {
            return;
        }
        if (this.bearbeitet == bl) {
            return;
        }
        this.bearbeitet = bl;
        this.update(23);
    }

    public void setInvalid(boolean bl) {
        if (this.loeschen == bl) {
            return;
        }
        this.loeschen = bl;
        this.fireChangeListener(1);
    }

    public boolean isInvalid() {
        return this.loeschen;
    }

    public void setDateImport(Date date) {
        this.dateImport = new Date(date.getTime());
        this.update(22);
    }

    public void setDateCurrent(Date date) {
        this.dateCurrent = new Date(date.getTime());
        this.update(22);
    }

    public boolean hasDateChanged() {
        return this.dateImport.getTime() != this.dateCurrent.getTime();
    }

    public Date getDateImport() {
        return this.dateImport;
    }

    public Date getDateCurrent() {
        return this.dateCurrent;
    }

    public void setRemarks(String string) {
        if (!this.requestToUpdate()) {
            return;
        }
        if (this.hasUpdate(this.bemerkungen, string)) {
            this.bemerkungen = this.getUpdate(this.bemerkungen, string);
            this.update(12);
        }
    }

    public String getRemarks() {
        return this.bemerkungen;
    }

    private void setHoehe(String string) {
        if (!this.requestToUpdate()) {
            return;
        }
        if (this.hasUpdate(this.hoehe, string)) {
            this.hoehe = this.getUpdate(this.hoehe, string);
            this.update(13);
        }
    }

    public long getResolution() {
        return PM_Utils.stringToLong(this.breite) * PM_Utils.stringToLong(this.hoehe);
    }

    public Dimension getImageSize() {
        return new Dimension(PM_Utils.stringToInt(this.breite), PM_Utils.stringToInt(this.hoehe));
    }

    public void setImageSize(Dimension dimension) {
        this.setBreite(String.valueOf(dimension.width));
        this.setHoehe(String.valueOf(dimension.height));
    }

    private void setBreite(String string) {
        if (!this.requestToUpdate()) {
            return;
        }
        if (this.hasUpdate(this.breite, string)) {
            this.breite = this.getUpdate(this.breite, string);
            this.update(14);
        }
    }

    public void setCategory(String string) {
        int n = PM_Utils.stringToInt(string);
        if (n < 1 || n > 4) {
            string = "3";
        }
        if (!this.requestToUpdate()) {
            return;
        }
        if (this.hasUpdate(this.qs, string)) {
            this.qs = this.getUpdate(this.qs, string);
            this.update(11);
        }
    }

    public void setCategory(int n) {
        this.setCategory(String.valueOf(n));
    }

    public int getCategory() {
        if (this.qs.equals("1")) {
            return 1;
        }
        if (this.qs.equals("2")) {
            return 2;
        }
        if (this.qs.equals("3")) {
            return 3;
        }
        if (this.qs.equals("4")) {
            return 4;
        }
        return 3;
    }

    public Rectangle getCutRectangle() {
        if (this.cutBreite.length() == 0) {
            return new Rectangle(this.getImageSize());
        }
        return new Rectangle(PM_Utils.stringToInt(this.cutX), PM_Utils.stringToInt(this.cutY), PM_Utils.stringToInt(this.cutBreite), PM_Utils.stringToInt(this.cutHoehe));
    }

    public void setCutRectangle(Rectangle rectangle) {
        if (!this.requestToUpdate()) {
            return;
        }
        if (rectangle.x == 0 && rectangle.y == 0 && rectangle.width == 0 && rectangle.height == 0) {
            this.cutX = "";
            this.cutY = "";
            this.cutBreite = "";
            this.cutHoehe = "";
        } else {
            this.cutX = Integer.toString(rectangle.x);
            this.cutY = Integer.toString(rectangle.y);
            this.cutBreite = Integer.toString(rectangle.width);
            this.cutHoehe = Integer.toString(rectangle.height);
        }
        this.update(19);
    }

    public boolean getMirror() {
        return this.spiegeln;
    }

    public void setMirror(boolean bl) {
        if (!this.requestToUpdate()) {
            return;
        }
        if (this.spiegeln == bl) {
            return;
        }
        this.spiegeln = bl;
        this.update(25);
    }

    public boolean hasCutRectangle() {
        int n = PM_Utils.stringToInt(this.cutBreite);
        int n2 = PM_Utils.stringToInt(this.cutHoehe);
        return n != 0 && n2 != 0;
    }

    public int getRotation() {
        if (this.rotate.equals("L")) {
            return 270;
        }
        if (this.rotate.equals("R")) {
            return 90;
        }
        if (this.rotate.equals("U")) {
            return 180;
        }
        return 0;
    }

    public void setRotation(int n) {
        if (!this.requestToUpdate()) {
            return;
        }
        String string = "";
        switch (n) {
            case 0: {
                string = "";
                break;
            }
            case 90: {
                string = "R";
                break;
            }
            case 180: {
                string = "U";
                break;
            }
            case 270: {
                string = "L";
            }
        }
        if (this.hasUpdate(this.rotate, string)) {
            this.rotate = this.getUpdate(this.rotate, string);
            this.update(21);
        }
    }

    public File getFileOriginal() {
        return this.fileOriginal;
    }

    private boolean hasUpdate(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        String string3 = string2.trim();
        return !string.equals(string3);
    }

    private String getUpdate(String string, String string2) {
        if (string2 == null) {
            return string;
        }
        String string3 = string2.trim();
        if (string.equals(string3)) {
            return string;
        }
        return string3;
    }

    private boolean requestToUpdate() {
        return !this.loeschen;
    }

    private void update(int n) {
        if (this.init || this.loeschen) {
            return;
        }
        this.fireChangeListener(n);
    }

    public void fireChangeListener(int n) {
        for (int i = 0; i < alleChangeListener.size(); ++i) {
            PM_Listener pM_Listener = alleChangeListener.elementAt(i);
            pM_Listener.actionPerformed(new PM_Action(this.picture, n));
        }
    }

    public String toString() {
        String string = "ID = " + this.id;
        String string2 = "datum  = " + this.datum;
        String string3 = "qs = " + this.qs;
        String string4 = "breite = " + this.breite;
        String string5 = "hoehe = " + this.hoehe;
        String string6 = "index = " + this.index1;
        String string7 = "cutX = " + this.cutX;
        String string8 = "cutY = " + this.cutY;
        String string9 = "cutHoehe = " + this.cutHoehe;
        String string10 = "cutBreite = " + this.cutBreite;
        return "Metadaten = " + string + "/" + string2 + "/" + string3 + "/" + string4 + "/" + string5 + "/" + string6 + "/" + string7 + "/" + string8 + "/" + string9 + "/" + string10;
    }
}

