/*
 * Decompiled with CFR 0.152.
 */
package pm.picture;

import java.awt.Container;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import pm.picture.PM_Picture;
import pm.picture.PM_PictureImageMetadaten;
import pm.utilities.PM_Interface;
import pm.utilities.PM_Utils;
import pm.utilities.PM_UtilsGrafik;

class PM_ReadImageThumbnail
implements PM_Interface {
    public static final PM_ReadImageThumbnail INSTANCE = new PM_ReadImageThumbnail();

    private PM_ReadImageThumbnail() {
    }

    public static PM_ReadImageThumbnail getInstance() {
        return INSTANCE;
    }

    public Image getImage(PM_Picture pM_Picture) {
        File file = pM_Picture.getFileOriginal();
        File file2 = PM_Utils.getFileThumbnail(file);
        if (file2.isFile()) {
            return this.readImageThumbnail(file2);
        }
        pM_Picture.readImageOriginal();
        Image image = pM_Picture.getImageOriginal();
        Image image2 = this.makeThumbnail(image);
        PM_UtilsGrafik.writeThumbnail(file2, image2);
        this.setEXIFpictureMetadaten(pM_Picture);
        pM_Picture.meta.setImageSize(PM_UtilsGrafik.getImageSize(image));
        PM_Picture.flushAllImagesOriginal();
        return image2;
    }

    private Image readImageThumbnail(File file) {
        Image image = null;
        try {
            image = Toolkit.getDefaultToolkit().getImage(file.getPath());
            MediaTracker mediaTracker = new MediaTracker(new Container());
            mediaTracker.addImage(image, 0);
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        return image;
    }

    private Image makeThumbnail(Image image) {
        double d = (double)image.getWidth(null) / (double)image.getHeight(null);
        int n = PM_ReadImageThumbnail.THUMBNAIL.width;
        int n2 = PM_ReadImageThumbnail.THUMBNAIL.height;
        if (d > 0.0) {
            n = (int)((double)n2 * d);
        } else {
            n2 = (int)((double)n * d);
        }
        if (n == 0 || n2 == 0) {
            System.out.println("ERROR makeThumbnail: width = " + n + ", height = " + n2 + ", imageRation = " + d);
            System.out.println("  Workaround: width = " + PM_ReadImageThumbnail.THUMBNAIL.width + ", height = " + PM_ReadImageThumbnail.THUMBNAIL.height);
            n = PM_ReadImageThumbnail.THUMBNAIL.width;
            n2 = PM_ReadImageThumbnail.THUMBNAIL.height;
        }
        return this.getScaledImage(image, n, n2);
    }

    private Image getScaledImage(Image image, int n, int n2) {
        Image image2 = image.getScaledInstance(n, n2, 1);
        try {
            MediaTracker mediaTracker = new MediaTracker(new Container());
            mediaTracker.addImage(image2, 0);
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        return image2;
    }

    private void setEXIFpictureMetadaten(PM_Picture pM_Picture) {
        String string = "Date/Time Original";
        String string2 = "";
        PM_PictureImageMetadaten pM_PictureImageMetadaten = pM_Picture.getImageMetadaten();
        if (pM_PictureImageMetadaten.hasTag(string)) {
            string2 = pM_PictureImageMetadaten.getDescription(string);
        }
        Date date = null;
        if (string2.length() == 0 || string2.equals("0000:00:00 00:00:00")) {
            File file = pM_Picture.getFileOriginal();
            Date date2 = new Date(file.lastModified());
            pM_Picture.meta.setDateImport(date2);
            pM_Picture.meta.setDateCurrent(new Date(date2.getTime()));
            return;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss");
        try {
            date = simpleDateFormat.parse(string2);
        }
        catch (ParseException parseException) {
            date = new Date(System.currentTimeMillis());
        }
        pM_Picture.meta.setDateImport(date);
        pM_Picture.meta.setDateCurrent(new Date(date.getTime()));
    }
}

