/*
 * Decompiled with CFR 0.152.
 */
package pm.print;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import pm.gui.PM_WindowMain;
import pm.print.PM_CutTempPrint;
import pm.print.PM_PaperFormat;
import pm.print.PM_PicturePrint;
import pm.print.PM_PmPrinter;
import pm.utilities.PM_Interface;
import pm.utilities.PM_UtilsGrafik;

public class PM_PictureFormat
implements PM_Interface {
    protected final Rectangle bildGroesse;
    protected final String formatName;
    protected final PM_PaperFormat papierFormat;
    protected PM_PmPrinter drucker = null;
    protected Rectangle2D papierBereich = null;
    protected double ratioPapierBereich = 1.0;
    protected Rectangle2D druckBereich = null;
    protected double ratioDruckBereich = 1.0;
    protected Rectangle2D imagePapierBereich = null;
    protected Rectangle2D imageCutRectangle = null;
    protected double ratioImageCutRectangle = 1.0;
    protected AffineTransform scaling = new AffineTransform();
    protected AffineTransform scalingInverse = new AffineTransform();

    public PM_PictureFormat(PM_PaperFormat pM_PaperFormat, Rectangle rectangle, String string) {
        this.papierFormat = pM_PaperFormat;
        this.bildGroesse = rectangle;
        this.formatName = string;
    }

    public void init(PM_PicturePrint pM_PicturePrint) {
        this.init(pM_PicturePrint, pM_PicturePrint.getDruckBereich(), pM_PicturePrint.getCutRectangle());
    }

    public void init(PM_PicturePrint pM_PicturePrint, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        this.papierBereich = pM_PicturePrint.getPapierBereich();
        this.drucker = pM_PicturePrint.getDrucker();
    }

    public void drehenCutRectangle() {
        this.imageCutRectangle = PM_UtilsGrafik.rotateRoundMiddlePoint(this.imageCutRectangle);
        this.imagePapierBereich = PM_UtilsGrafik.rotateRoundMiddlePoint(this.imagePapierBereich);
        this.druckBereich = PM_UtilsGrafik.rotateRoundMiddlePoint(this.druckBereich);
    }

    public void toPictureDrucken(PM_PicturePrint pM_PicturePrint) {
        this.imageCutRectangle = this.scalingInverse.createTransformedShape(this.imageCutRectangle).getBounds2D();
        pM_PicturePrint.setCutRectangle(this.imageCutRectangle);
        pM_PicturePrint.setDruckBereich(this.druckBereich);
    }

    public PM_PaperFormat getPapierFormat() {
        return this.papierFormat;
    }

    public void setScaling(double d) {
        this.scaling.setToScale(d, d);
        this.scalingInverse.setToScale(1.0 / d, 1.0 / d);
    }

    protected boolean anfasserPapier() {
        PM_WindowMain pM_WindowMain = PM_WindowMain.getInstance();
        PM_CutTempPrint pM_CutTempPrint = pM_WindowMain.getDialogDruckenAendern();
        if (pM_CutTempPrint == null) {
            return true;
        }
        return pM_CutTempPrint.getAnfasserPapier().isSelected();
    }

    protected Rectangle2D getPapierBereich() {
        return this.papierBereich;
    }

    public Rectangle2D getCutRectangle() {
        return this.scalingInverse.createTransformedShape(this.imageCutRectangle).getBounds2D();
    }

    public Rectangle2D getDruckBereich() {
        return this.druckBereich;
    }

    public String toString() {
        return this.formatName;
    }

    protected boolean move() {
        return true;
    }

    protected boolean resizeDiagonal() {
        return true;
    }

    protected boolean resizeDiagonalSymmetrich() {
        return false;
    }

    protected boolean resizeVertiHorizontal() {
        return false;
    }

    protected boolean resizeVertiHoriSymmetrich() {
        return false;
    }

    protected Rectangle2D getRectangleResize() {
        if (this.anfasserPapier()) {
            return this.imagePapierBereich;
        }
        return this.imageCutRectangle;
    }

    protected void setRectangleResized(Rectangle2D rectangle2D, AffineTransform affineTransform) {
        if (this.anfasserPapier()) {
            this.imagePapierBereich = rectangle2D;
            this.imageCutRectangle = affineTransform.createTransformedShape(this.imageCutRectangle).getBounds2D();
        } else {
            this.imageCutRectangle = rectangle2D;
            this.imagePapierBereich = affineTransform.createTransformedShape(this.imagePapierBereich).getBounds2D();
        }
    }

    protected void drawRectangleResize(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Color color = graphics2D.getColor();
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setColor(Color.BLACK);
        graphics2D.setStroke(new BasicStroke(5.0f, 0, 2, 3.0f, new float[]{50.0f, 10.0f}, 4.0f));
        graphics2D.draw(this.imagePapierBereich);
        graphics2D.setStroke(stroke);
        graphics2D.setColor(Color.YELLOW);
        graphics2D.draw(this.imageCutRectangle);
        graphics2D.setColor(color);
    }

    protected Rectangle2D getRectangle(Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, rectangle2D2.getWidth(), rectangle2D2.getHeight());
        Rectangle2D rectangle2D3 = this.fitIntoRectangle(rectangle2D, double_);
        double_.height = rectangle2D2.getWidth();
        double_.width = rectangle2D2.getHeight();
        Rectangle2D rectangle2D4 = this.fitIntoRectangle(rectangle2D, double_);
        if (rectangle2D3.getWidth() * rectangle2D3.getHeight() >= rectangle2D4.getWidth() * rectangle2D4.getHeight()) {
            return rectangle2D3;
        }
        return rectangle2D4;
    }

    protected Rectangle2D fitIntoRectangle(Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        Rectangle2D rectangle2D3 = null;
        double d = rectangle2D.getWidth() / rectangle2D2.getWidth();
        rectangle2D3 = AffineTransform.getScaleInstance(d, d).createTransformedShape(rectangle2D2).getBounds2D();
        if (rectangle2D.getHeight() < rectangle2D3.getHeight()) {
            d = rectangle2D.getHeight() / rectangle2D2.getHeight();
            rectangle2D3 = AffineTransform.getScaleInstance(d, d).createTransformedShape(rectangle2D2).getBounds2D();
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        double_.setRect(rectangle2D3);
        double_.x = (rectangle2D.getWidth() - double_.getWidth()) / 2.0 + rectangle2D.getX();
        double_.y = (rectangle2D.getHeight() - double_.getHeight()) / 2.0 + rectangle2D.getY();
        return double_;
    }
}

