/*
 * Decompiled with CFR 0.152.
 */
package pm.search;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import pm.picture.PM_Picture;
import pm.utilities.PM_Interface;

public class PM_LuceneDocument
implements PM_Interface {
    public static final String LUCENE_ID = "id";
    public static final String LUCENE_INDEX = "i";
    public static final String LUCENE_ORT = "j";
    public static final String LUCENE_TIME = "time";
    public static final String LUCENE_DATE = "date";
    public static final String LUCENE_QS = "q";
    public static final String LUCENE_BEARBEITET = "b";
    public static final String LUCENE_SEQUENZ = "s";
    private String id = "";
    private String qs = "";
    private String ort = "";
    private String index = "";
    private String time = "";
    private String date = "";
    private String berarb = "";
    private String sequenz = "";
    private Document doc = new Document();

    public static PM_LuceneDocument create(PM_Picture pM_Picture) {
        PM_LuceneDocument pM_LuceneDocument = new PM_LuceneDocument();
        pM_LuceneDocument.id = pM_Picture.getFileOriginal().getPath();
        pM_LuceneDocument.ort = pM_Picture.meta.getIndex2();
        pM_LuceneDocument.qs = String.valueOf(pM_Picture.meta.getCategory());
        pM_LuceneDocument.index = pM_Picture.meta.getIndex1();
        Date date = pM_Picture.meta.getDateCurrent();
        pM_LuceneDocument.time = Long.toString(date.getTime());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        pM_LuceneDocument.date = simpleDateFormat.format(date);
        pM_LuceneDocument.berarb = pM_Picture.meta.getModified() ? "ja" : "";
        pM_LuceneDocument.sequenz = pM_Picture.meta.getSequence();
        if (pM_LuceneDocument.makeFields()) {
            return pM_LuceneDocument;
        }
        return null;
    }

    public static boolean isRelevant(int n) {
        switch (n) {
            case 1: 
            case 10: 
            case 11: 
            case 20: 
            case 22: 
            case 23: 
            case 24: {
                return true;
            }
        }
        return false;
    }

    private PM_LuceneDocument() {
    }

    private boolean makeFields() {
        String string;
        int n;
        String[] stringArray;
        if (this.index.length() != 0) {
            stringArray = this.index.split(" ");
            for (n = 0; n < stringArray.length; ++n) {
                string = stringArray[n].trim();
                this.doc.add(new Field(LUCENE_INDEX, string, Field.Store.YES, Field.Index.UN_TOKENIZED));
            }
        } else {
            this.doc.add(new Field(LUCENE_INDEX, "OHNE_INDEX_1", Field.Store.YES, Field.Index.UN_TOKENIZED));
        }
        if (this.ort.length() != 0) {
            stringArray = this.ort.split(" ");
            for (n = 0; n < stringArray.length; ++n) {
                string = stringArray[n].trim();
                this.doc.add(new Field(LUCENE_ORT, string, Field.Store.YES, Field.Index.UN_TOKENIZED));
            }
        } else {
            this.doc.add(new Field(LUCENE_ORT, "OHNE_INDEX_2", Field.Store.YES, Field.Index.UN_TOKENIZED));
        }
        if (this.sequenz.length() != 0) {
            stringArray = this.sequenz.split(" ");
            for (n = 0; n < stringArray.length; ++n) {
                string = stringArray[n].trim();
                this.doc.add(new Field(LUCENE_SEQUENZ, string, Field.Store.YES, Field.Index.UN_TOKENIZED));
            }
        }
        if (this.qs.length() != 0) {
            this.doc.add(new Field(LUCENE_QS, this.qs, Field.Store.YES, Field.Index.UN_TOKENIZED));
        }
        if (this.berarb.length() != 0) {
            this.doc.add(new Field(LUCENE_BEARBEITET, this.berarb, Field.Store.YES, Field.Index.UN_TOKENIZED));
        }
        if (!this.doc.fields().hasMoreElements()) {
            return false;
        }
        this.doc.add(new Field(LUCENE_TIME, this.time, Field.Store.YES, Field.Index.UN_TOKENIZED));
        this.doc.add(new Field(LUCENE_DATE, this.date, Field.Store.YES, Field.Index.UN_TOKENIZED));
        this.doc.add(new Field(LUCENE_ID, this.id, Field.Store.YES, Field.Index.UN_TOKENIZED));
        return true;
    }

    public Document getDocument() {
        return this.doc;
    }
}

