/*
 * Decompiled with CFR 0.152.
 */
package pm.search;

import pm.sequence.PM_Sequence;
import pm.sequence.PM_SequenceAlbum;
import pm.utilities.PM_Interface;

public class PM_SearchExpr
implements PM_Interface {
    private PM_Interface.SearchType searchType = PM_Interface.SearchType.NOTHING;
    private PM_Interface.SearchSortType searchSortType = PM_Interface.SearchSortType.TIME;
    private PM_Sequence sequenz = null;
    private PM_Sequence sortSequenz = null;

    public PM_SearchExpr(PM_Interface.SearchType searchType) {
        this.searchType = searchType;
    }

    public void setSequenz(PM_Sequence pM_Sequence) {
        this.sequenz = pM_Sequence;
        this.sortSequenz = pM_Sequence;
    }

    public PM_Sequence getSequenz() {
        return this.sequenz;
    }

    public PM_Sequence getSortSequenz() {
        return this.sortSequenz;
    }

    public String getSearchString() {
        switch (this.searchType) {
            case NO_INDEX_1: {
                return "i:(OHNE_INDEX_1)";
            }
            case NO_INDEX_2: {
                return "j:(OHNE_INDEX_2)";
            }
            case SEQ: {
                return this.getSearchStringForSequenze();
            }
        }
        return "";
    }

    public PM_Interface.SearchType getSearchType() {
        return this.searchType;
    }

    public PM_Interface.SearchSortType getSortType() {
        return this.searchSortType;
    }

    private String getSearchStringForSequenze() {
        if (this.sequenz == null) {
            return "";
        }
        switch (this.sequenz.getType()) {
            case EXTENDED: 
            case BASE: 
            case NEW: {
                return "s:" + this.sequenz.getShortName() + "_" + "*";
            }
            case ALBUM: {
                return this.getSearchStringFromOpenSequenz((PM_SequenceAlbum)this.sequenz);
            }
        }
        return "";
    }

    private String getDatumString(PM_Sequence pM_Sequence) {
        Object object;
        String string = "";
        String string2 = "";
        if (this.sequenz instanceof PM_SequenceAlbum) {
            object = (PM_SequenceAlbum)this.sequenz;
            string = ((PM_SequenceAlbum)object).getVon();
            string2 = ((PM_SequenceAlbum)object).getBis();
        }
        object = this.getJJ(string);
        String string3 = this.getMM(string);
        String string4 = this.getTT(string);
        String string5 = this.getJJ(string2);
        String string6 = this.getMM(string2);
        String string7 = this.getTT(string2);
        if (((String)object).length() != 4) {
            object = "????";
        }
        if (string3.length() != 2) {
            string3 = "??";
        }
        if (string4.length() != 2) {
            string4 = "??";
        }
        if ((string = (String)object + string3 + string4).startsWith("?")) {
            return "";
        }
        if (string5.length() != 4) {
            string5 = "????";
        }
        if (string6.length() != 2) {
            string6 = "??";
        }
        if (string7.length() != 2) {
            string7 = "??";
        }
        if ((string2 = string5 + string6 + string7).startsWith("?")) {
            return "date:" + string;
        }
        return "date:[" + string + " TO " + string2 + "]";
    }

    private String getJJ(String string) {
        String[] stringArray = string.split("\\.");
        if (stringArray.length >= 1) {
            return stringArray[0];
        }
        return "";
    }

    private String getMM(String string) {
        String[] stringArray = string.split("\\.");
        if (stringArray.length >= 2) {
            return stringArray[1];
        }
        return "";
    }

    private String getTT(String string) {
        String[] stringArray = string.split("\\.");
        if (stringArray.length >= 3) {
            return stringArray[2];
        }
        return "";
    }

    private String getIndex1(PM_SequenceAlbum pM_SequenceAlbum) {
        String string = pM_SequenceAlbum.getIndex().trim();
        if (string.length() != 0) {
            string = "i:(" + string + ")";
        }
        return string;
    }

    private String getIndex2(PM_SequenceAlbum pM_SequenceAlbum) {
        String string = pM_SequenceAlbum.getOrt().trim();
        if (string.length() != 0) {
            string = "j:(" + string + ")";
        }
        return string;
    }

    private String getQsString(PM_SequenceAlbum pM_SequenceAlbum) {
        String string = pM_SequenceAlbum.getQual();
        String string2 = "";
        if (string.indexOf("1") >= 0) {
            string2 = string2 + " q:1 ";
        }
        if (string.indexOf("2") >= 0) {
            string2 = string2 + " q:2 ";
        }
        if (string.indexOf("3") >= 0) {
            string2 = string2 + " q:3 ";
        }
        if (string.indexOf("4") >= 0) {
            string2 = string2 + " q:4 ";
        }
        if ((string2 = string2.trim()).length() != 0) {
            string2 = "(" + string2 + ")";
        }
        return string2;
    }

    private String getSeqString(PM_SequenceAlbum pM_SequenceAlbum) {
        PM_Sequence pM_Sequence = pM_SequenceAlbum.getSeqClosed();
        if (pM_Sequence == null) {
            return "";
        }
        this.sortSequenz = pM_Sequence;
        return "s:" + pM_Sequence.getShortName() + "_" + "*";
    }

    private String getSearchStringFromOpenSequenz(PM_SequenceAlbum pM_SequenceAlbum) {
        String string = "";
        string = this.andToSuchstring(string, this.getQsString(pM_SequenceAlbum));
        string = this.andToSuchstring(string, this.getDatumString(pM_SequenceAlbum).trim());
        string = this.andToSuchstring(string, this.getIndex1(pM_SequenceAlbum));
        string = this.andToSuchstring(string, this.getIndex2(pM_SequenceAlbum));
        string = this.andToSuchstring(string, this.getSeqString(pM_SequenceAlbum));
        return string;
    }

    private String andToSuchstring(String string, String string2) {
        String string3 = string.trim();
        String string4 = string2.trim();
        string3 = string3.length() != 0 && string4.length() != 0 ? string3 + " AND " + string4 : string3 + "  " + string4;
        return string3.trim();
    }
}

