/*
 * Decompiled with CFR 0.152.
 */
package pm.sequence;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import pm.picture.PM_Picture;
import pm.search.PM_DatabaseLucene;
import pm.search.PM_Search;
import pm.search.PM_SearchExpr;
import pm.sequence.PM_SequenceAlbum;
import pm.sequence.PM_TreeModel;
import pm.sequence.PM_TreeModelBase;
import pm.sequence.PM_TreeModelExtended;
import pm.sequence.PM_TreeModelNew;
import pm.utilities.PM_Interface;
import pm.utilities.PM_Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PM_Sequence
implements PM_Interface {
    protected String initPath = "";
    protected int numberOfShortName = 0;
    protected String shortName = "";
    protected String longName = "";
    protected int count = 0;
    private boolean stringLeaf = false;
    protected boolean textFile = false;
    private static int freieSequNummer = -1;

    protected int getSequenceNumberFromName(String string) {
        if (string.length() <= 1) {
            return 0;
        }
        return PM_Utils.stringToInt(string.substring(1));
    }

    public abstract File getTextFile();

    public boolean hasTextFile() {
        return this.textFile;
    }

    public void textFile(boolean bl) {
        this.textFile = bl;
    }

    public void setAnzahlBilder(int n) {
        if (n < 0) {
            this.count = 0;
            return;
        }
        this.count = n;
    }

    public String getPath() {
        return this.initPath;
    }

    public void setPath(String string) {
        this.initPath = string;
    }

    public void setStringLeaf(boolean bl) {
        this.stringLeaf = bl;
    }

    public boolean getStringLeaf() {
        return this.stringLeaf;
    }

    public boolean makeSequence() {
        return false;
    }

    public abstract PM_Interface.SequenceType getSequenceType();

    public String getSequenceCharacter() {
        return "";
    }

    public PM_Interface.SequenceType getType() {
        return this.getSequenceType();
    }

    public int getSequenceNumber() {
        return this.numberOfShortName;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getLongName() {
        return this.longName;
    }

    public int getAnzahlBilder() {
        return this.count;
    }

    public void setLongName(String string) {
        this.longName = string;
    }

    public List<PM_Picture> getAlleBilder() {
        return new ArrayList<PM_Picture>();
    }

    public void neuNummerieren(int n) {
    }

    public List getFileListFromDirectory() {
        return new ArrayList();
    }

    protected String toStringBilder(int n) {
        if (n == 1) {
            return n + " Bild";
        }
        return n + " Bilder";
    }

    public String toStringComboBox() {
        return this.longName + "(" + this.shortName + ": " + this.toStringBilder(this.getAnzahlBilder()) + ")";
    }

    public String getTypeString() {
        return "muss \u00fcberschrieben werden";
    }

    public String getListenName() {
        return this.getPath() + " (" + this.getShortName() + "-" + this.getAnzahlBilder() + ")";
    }

    public void loeschenSequenz() {
        this.deletePictureChain();
        PM_DatabaseLucene.getInstance().flush();
    }

    public void aendernSequenz(List<PM_Picture> list) {
        this.deletePictureChain();
        this.newPictureChain(list);
        PM_DatabaseLucene.getInstance().flush();
    }

    public void neuPictures(List<PM_Picture> list) {
        this.newPictureChain(list);
        PM_DatabaseLucene.getInstance().flush();
    }

    public void makeBasisSequenz() {
        List<PM_Picture> list = this.getPictureListFromLucene();
        for (PM_Picture pM_Picture : list) {
            String string;
            String[] stringArray;
            Iterator<String> iterator = PM_Utils.getList(pM_Picture.meta.getSequence()).iterator();
            while (iterator.hasNext() && (stringArray = (string = iterator.next()).split("_")).length == 2) {
                if (!this.getShortName().equals(stringArray[0])) continue;
                string = string.replaceFirst("s", "b");
                pM_Picture.meta.setSequenz(string);
            }
        }
        this.longName = this.longName.replaceFirst("s", "b");
    }

    protected List<PM_Picture> getPictureListFromLucene() {
        PM_SearchExpr pM_SearchExpr = new PM_SearchExpr(PM_Interface.SearchType.SEQ);
        pM_SearchExpr.setSequenz(this);
        PM_Search pM_Search = new PM_Search(pM_SearchExpr);
        int n = pM_Search.search();
        if (n == 0) {
            return new ArrayList<PM_Picture>();
        }
        return pM_Search.getPictureList(PM_Interface.SearchSortType.SEQ);
    }

    public void computeNewSize() {
        PM_SearchExpr pM_SearchExpr = new PM_SearchExpr(PM_Interface.SearchType.SEQ);
        pM_SearchExpr.setSequenz(this);
        PM_Search pM_Search = new PM_Search(pM_SearchExpr);
        this.setAnzahlBilder(pM_Search.search());
    }

    protected void newPictureChain(List<PM_Picture> list) {
        Iterator<PM_Picture> iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            PM_Picture pM_Picture = iterator.next();
            this.updateMetadaten(pM_Picture, n);
            ++n;
        }
        this.count = list.size();
        PM_DatabaseLucene.getInstance().flush();
    }

    protected void deletePictureChain() {
        List<PM_Picture> list = this.getPictureListFromLucene();
        if (list.isEmpty()) {
            this.count = 0;
            return;
        }
        for (PM_Picture pM_Picture : list) {
            String string = "";
            String string2 = pM_Picture.meta.getSequence();
            String[] stringArray = string2.split(" ");
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i];
                if (string3.indexOf(this.shortName + "_") == 0) continue;
                string = string + string3 + " ";
            }
            pM_Picture.meta.setSequenz(string);
        }
        this.count = 0;
    }

    public void deleteTextFile() {
        File file = this.getTextFile();
        if (file == null) {
            return;
        }
        if (!file.isFile()) {
            return;
        }
        file.delete();
    }

    protected void updateMetadaten(PM_Picture pM_Picture, int n) {
        String string = pM_Picture.meta.getSequence();
        String string2 = PM_Utils.stringToString("00000" + Integer.toString(n), 3);
        String string3 = this.shortName + "_" + string2;
        if (this.getSequenceType() != PM_Interface.SequenceType.BASE) {
            string = string + " " + string3;
        } else {
            String string4 = "";
            String[] stringArray = string.split(" ");
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].startsWith("b")) {
                    PM_Sequence pM_Sequence;
                    String[] stringArray2 = stringArray[i].split("_");
                    if (stringArray2.length != 2 || (pM_Sequence = this.getSequenz(stringArray2[0])) == null) continue;
                    int n2 = pM_Sequence.getAnzahlBilder() - 1;
                    if (n2 > 0) {
                        pM_Sequence.setAnzahlBilder(n2);
                        continue;
                    }
                    pM_Sequence.setAnzahlBilder(0);
                    continue;
                }
                string4 = string4 + " " + stringArray[i];
            }
            string = string4 + " " + string3;
        }
        pM_Picture.meta.setSequenz(string);
    }

    public PM_Sequence getSequenz(String string) {
        PM_Sequence pM_Sequence2 = null;
        List<PM_Sequence> list = this.getSequenceList();
        for (PM_Sequence pM_Sequence2 : list) {
            if (!pM_Sequence2.getShortName().equals(string)) continue;
            return pM_Sequence2;
        }
        return pM_Sequence2;
    }

    public static PM_Sequence getSequenzFromAll(String string) {
        PM_Sequence pM_Sequence2 = null;
        PM_TreeModelBase pM_TreeModelBase = PM_TreeModelBase.getInstance();
        PM_TreeModelExtended pM_TreeModelExtended = PM_TreeModelExtended.getInstance();
        PM_TreeModelNew pM_TreeModelNew = PM_TreeModelNew.getInstance();
        ArrayList<PM_Sequence> arrayList = ((PM_TreeModel)pM_TreeModelBase).getSequenceList();
        arrayList.addAll(((PM_TreeModel)pM_TreeModelExtended).getSequenceList());
        arrayList.addAll(((PM_TreeModel)pM_TreeModelNew).getSequenceList());
        for (PM_Sequence pM_Sequence2 : arrayList) {
            if (!pM_Sequence2.getShortName().equals(string)) continue;
            return pM_Sequence2;
        }
        return pM_Sequence2;
    }

    public static int getNextFreeSequenceNumber() {
        if (freieSequNummer == -1) {
            ArrayList<PM_Sequence> arrayList = PM_TreeModelBase.getInstance().getSequenceList();
            arrayList.addAll(PM_TreeModelExtended.getInstance().getSequenceList());
            arrayList.addAll(PM_TreeModelNew.getInstance().getSequenceList());
            for (PM_Sequence pM_Sequence : arrayList) {
                freieSequNummer = Math.max(freieSequNummer, pM_Sequence.numberOfShortName);
            }
        }
        return ++freieSequNummer;
    }

    public List<PM_Sequence> getSequenceList() {
        return new ArrayList<PM_Sequence>();
    }

    protected String getLongNameFromInitPath(String string) {
        if (string == null || string.length() == 0) {
            return "unbekannter Name";
        }
        String[] stringArray = string.split("\\.");
        if (stringArray.length == 0) {
            return string;
        }
        return stringArray[stringArray.length - 1];
    }

    protected void setSequenzNumber(PM_Picture pM_Picture, int n) {
        String string = PM_Utils.stringToString("00000" + Integer.toString(n), 4);
        pM_Picture.meta.setSequenz(pM_Picture.meta.getSequence() + " " + this.getShortName() + "_" + string);
    }

    public static int sequenzenNeuNummerieren(int n) {
        PM_TreeModelBase pM_TreeModelBase = PM_TreeModelBase.getInstance();
        PM_TreeModelExtended pM_TreeModelExtended = PM_TreeModelExtended.getInstance();
        ArrayList<PM_Sequence> arrayList = ((PM_TreeModel)pM_TreeModelBase).getSequenceList();
        arrayList.addAll(((PM_TreeModel)pM_TreeModelExtended).getSequenceList());
        Iterator iterator = arrayList.iterator();
        int n2 = n;
        int n3 = 0;
        while (iterator.hasNext()) {
            PM_Sequence pM_Sequence = (PM_Sequence)iterator.next();
            PM_Interface.SequenceType sequenceType = pM_Sequence.getType();
            if (sequenceType != PM_Interface.SequenceType.BASE && sequenceType != PM_Interface.SequenceType.EXTENDED) continue;
            String string = pM_Sequence.getShortName();
            pM_Sequence.neuNummerieren(n2);
            ++n2;
            ++n3;
            for (PM_Sequence pM_Sequence2 : arrayList) {
                PM_SequenceAlbum pM_SequenceAlbum;
                String string2;
                PM_Interface.SequenceType sequenceType2 = pM_Sequence2.getType();
                if (sequenceType2 != PM_Interface.SequenceType.ALBUM || !(string2 = (pM_SequenceAlbum = (PM_SequenceAlbum)pM_Sequence2).getSeqClosedName()).equals(string)) continue;
                System.out.println("            Close name. alt =" + string2 + ",neu = ");
            }
        }
        return n3;
    }

    public static String getSequenzKurzName(String string) {
        String[] stringArray = string.split("_");
        if (stringArray.length >= 1) {
            return stringArray[0];
        }
        return null;
    }
}

