/*
 * Decompiled with CFR 0.152.
 */
package pm.sequence;

import java.io.File;
import java.util.List;
import pm.picture.PM_Picture;
import pm.sequence.PM_Sequence;
import pm.sequence.PM_TreeModelBase;
import pm.utilities.PM_Configuration;
import pm.utilities.PM_Interface;
import pm.utilities.PM_Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PM_SequenceBase
extends PM_Sequence {
    private List<PM_Picture> pictureList;

    public PM_SequenceBase(String string, String string2) {
        this.initPath = string;
        this.shortName = string2;
        this.numberOfShortName = this.getSequenceNumberFromName(string2);
        this.longName = this.getLongNameFromInitPath(string);
    }

    public PM_SequenceBase(String string, List<PM_Picture> list) {
        this.longName = string;
        this.pictureList = list;
        this.initPath = string;
    }

    @Override
    public boolean makeSequence() {
        if (this.pictureList != null) {
            this.numberOfShortName = PM_SequenceBase.getNextFreeSequenceNumber();
            this.shortName = this.getSequenceCharacter() + this.numberOfShortName;
            this.newPictureChain(this.pictureList);
            this.pictureList = null;
            return true;
        }
        return false;
    }

    @Override
    public List<PM_Picture> getAlleBilder() {
        return this.getPictureListFromLucene();
    }

    public List<PM_Picture> getPictureList() {
        return this.pictureList;
    }

    @Override
    protected void newPictureChain(List<PM_Picture> list) {
        this.deletePictureChain();
        super.newPictureChain(list);
    }

    @Override
    public void deletePictureChain() {
        super.deletePictureChain();
    }

    @Override
    public File getTextFile() {
        return new File(PM_Configuration.getInstance().getSequencesDirBase(), "???.txt");
    }

    @Override
    public PM_Interface.SequenceType getSequenceType() {
        return PM_Interface.SequenceType.BASE;
    }

    @Override
    public String getSequenceCharacter() {
        return "b";
    }

    public String toString() {
        return this.longName + "   (" + this.shortName + ": " + this.toStringBilder(this.getAnzahlBilder()) + ")";
    }

    @Override
    public String getTypeString() {
        return "Basis - Serie";
    }

    @Override
    public List<PM_Sequence> getSequenceList() {
        return PM_TreeModelBase.getInstance().getSequenceList();
    }

    @Override
    protected void setSequenzNumber(PM_Picture pM_Picture, int n) {
        String string = PM_Utils.stringToString("00000" + Integer.toString(n), 3);
        String string2 = this.shortName + "_" + string;
        String string3 = "";
        String string4 = pM_Picture.meta.getSequence();
        String[] stringArray = string4.split(" ");
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2;
            if (stringArray[i].startsWith("b") && (stringArray2 = stringArray[i].split("_")).length != 2) continue;
            string3 = string3 + " " + stringArray[i];
        }
        string4 = string3 + " " + string2;
        pM_Picture.meta.setSequenz(string4);
    }
}

