/*
 * Decompiled with CFR 0.152.
 */
package pm.sequence;

import java.io.File;
import java.util.List;
import pm.picture.PM_Picture;
import pm.sequence.PM_Sequence;
import pm.sequence.PM_TreeModelExtended;
import pm.utilities.PM_Configuration;
import pm.utilities.PM_Interface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PM_SequenceExtended
extends PM_Sequence {
    private List<PM_Picture> pictureList;

    public PM_SequenceExtended(String string, String string2) {
        this.initPath = string;
        this.shortName = string2;
        this.numberOfShortName = this.getSequenceNumberFromName(string2);
        this.longName = this.getLongNameFromInitPath(string);
    }

    public PM_SequenceExtended(String string, List<PM_Picture> list) {
        this.longName = string;
        this.pictureList = list;
        this.initPath = string;
    }

    @Override
    public List<PM_Sequence> getSequenceList() {
        return PM_TreeModelExtended.getInstance().getSequenceList();
    }

    @Override
    public boolean makeSequence() {
        if (this.pictureList != null) {
            this.numberOfShortName = PM_SequenceExtended.getNextFreeSequenceNumber();
            this.shortName = this.getSequenceCharacter() + this.numberOfShortName;
            this.newPictureChain(this.pictureList);
            this.pictureList = null;
            return true;
        }
        return false;
    }

    @Override
    public File getTextFile() {
        return new File(PM_Configuration.getInstance().getSequencesDirNormal(), "?????.txt");
    }

    @Override
    public List<PM_Picture> getAlleBilder() {
        return this.getPictureListFromLucene();
    }

    @Override
    public PM_Interface.SequenceType getSequenceType() {
        return PM_Interface.SequenceType.EXTENDED;
    }

    @Override
    public String getSequenceCharacter() {
        return "s";
    }

    public String toString() {
        return this.longName + "   (" + this.shortName + ": " + this.toStringBilder(this.getAnzahlBilder()) + ")";
    }

    @Override
    public String getTypeString() {
        return "'normale' Serie";
    }
}

