/*
 * Decompiled with CFR 0.152.
 */
package pm.sequence;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import pm.picture.PM_Picture;
import pm.sequence.PM_Sequence;
import pm.utilities.PM_Configuration;
import pm.utilities.PM_Interface;
import pm.utilities.PM_Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PM_SequenceOriginal
extends PM_Sequence {
    protected File dirAlleBilder = null;

    public PM_SequenceOriginal(String string) {
        this.longName = string;
    }

    public void setDirAlleBilder(File file) {
        this.dirAlleBilder = file;
    }

    @Override
    public File getTextFile() {
        return new File(PM_Configuration.getInstance().getSequencesDir(), "???.txt");
    }

    @Override
    public List getFileListFromDirectory() {
        ArrayList arrayList = new ArrayList();
        if (this.dirAlleBilder == null) {
            return arrayList;
        }
        if (!this.dirAlleBilder.isDirectory()) {
            return arrayList;
        }
        return Arrays.asList(this.dirAlleBilder.listFiles());
    }

    @Override
    public String getLongName() {
        return this.dirAlleBilder.getName();
    }

    @Override
    public List<PM_Picture> getAlleBilder() {
        ArrayList<PM_Picture> arrayList = new ArrayList<PM_Picture>();
        if (this.dirAlleBilder == null) {
            return arrayList;
        }
        if (!this.dirAlleBilder.isDirectory()) {
            return arrayList;
        }
        File[] fileArray = this.dirAlleBilder.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            PM_Picture pM_Picture;
            File file = fileArray[i];
            if (!PM_Utils.isPictureFile(file) || (pM_Picture = PM_Picture.getPicture(file)) == null) continue;
            arrayList.add(pM_Picture);
        }
        return arrayList;
    }

    public String toString() {
        String string = this.getLongName() + "  ";
        string = string + " (" + this.getAnzahlBilder() + " Bilder)";
        return string;
    }

    @Override
    public String getTypeString() {
        return "'reales' Verzeichnis";
    }

    @Override
    public PM_Interface.SequenceType getSequenceType() {
        return PM_Interface.SequenceType.ORIGINAL;
    }
}

