/*
 * Decompiled with CFR 0.152.
 */
package pm.sequence;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.dnd.Autoscroll;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import pm.gui.PM_WindowBase;
import pm.picture.PM_PictureDirectory;
import pm.sequence.PM_Sequence;
import pm.sequence.PM_TreeModel;
import pm.utilities.PM_Interface;
import pm.utilities.PM_Utils;

public abstract class PM_TreeWindow
extends JTree
implements PM_Interface,
Autoscroll {
    protected DefaultMutableTreeNode rootNode;
    private PM_WindowBase windowBase;
    private boolean isClearedSelection = false;
    protected PM_TreeModel treeModel;
    private PM_TreeWindow treeWindow = this;
    private Font font = null;
    private Color fgColor = null;
    private Color bgColor = null;
    protected JMenuItem menuItemZeileLoeschen = null;
    protected JMenuItem menuItemZeileAendern = null;
    protected JMenuItem menuItemNewNode = null;
    private JPopupMenu popup = null;

    public PM_TreeWindow(PM_WindowBase pM_WindowBase, PM_TreeModel pM_TreeModel) {
        this.setModel(pM_TreeModel);
        this.treeModel = pM_TreeModel;
        this.rootNode = pM_TreeModel.getRootNode();
        this.windowBase = pM_WindowBase;
        this.initTree();
        this.createAndAddChangeListener();
        this.makeMouseListener();
        this.setCellRenderer(this.getDefaultTreeCellRenderer());
    }

    public void selectSequenz(PM_Sequence pM_Sequence, DefaultMutableTreeNode defaultMutableTreeNode) {
        this.windowBase.darstellungSequenz(pM_Sequence, defaultMutableTreeNode);
    }

    public PM_TreeModel getTreeModel() {
        return this.treeModel;
    }

    public boolean isSequenceSelected() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null) {
            return false;
        }
        return defaultMutableTreeNode.getUserObject() instanceof PM_Sequence;
    }

    public boolean isNodeSelected() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null) {
            return false;
        }
        return defaultMutableTreeNode != this.rootNode;
    }

    public DefaultMutableTreeNode getSelectedNode() {
        return (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
    }

    public void clearSelection(boolean bl) {
        this.isClearedSelection = bl;
        if (bl) {
            super.clearSelection();
        }
    }

    public boolean isClearedSelection() {
        return this.isClearedSelection;
    }

    private void initTree() {
        this.getSelectionModel().setSelectionMode(1);
        this.setRootVisible(true);
        this.putClientProperty("JTree.lineStyle", "Angled");
        this.setToggleClickCount(3);
        this.makeKeyBinding();
    }

    private void createAndAddChangeListener() {
        TreeWillExpandListener treeWillExpandListener = new TreeWillExpandListener(){

            public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
                TreePath treePath = treeExpansionEvent.getPath();
                if (treePath.getPathCount() > 1) {
                    return;
                }
                throw new ExpandVetoException(treeExpansionEvent);
            }

            public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            }
        };
        this.addTreeWillExpandListener(treeWillExpandListener);
    }

    public DefaultMutableTreeNode getRootNode() {
        return this.rootNode;
    }

    private void makeKeyBinding() {
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)PM_TreeWindow.this.getLastSelectedPathComponent();
                if (defaultMutableTreeNode == null) {
                    return;
                }
                Object object = defaultMutableTreeNode.getUserObject();
                if (object instanceof PM_Sequence) {
                    PM_TreeWindow.this.selectSequenz((PM_Sequence)object, defaultMutableTreeNode);
                } else {
                    PM_TreeWindow.this.selectSequenz(null, null);
                }
            }
        };
        this.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "enter");
        this.getActionMap().put("enter", abstractAction);
    }

    private void makeMouseListener() {
        KeyAdapter keyAdapter = new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (PM_Utils.isTemp(keyEvent)) {
                    System.out.println("ist Temp Picture");
                }
            }
        };
        this.addKeyListener(keyAdapter);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                TreePath treePath = PM_TreeWindow.this.getPathForLocation(point.x, point.y);
                if (treePath == null) {
                    return;
                }
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                int n = mouseEvent.getButton();
                int n2 = mouseEvent.getClickCount();
                if (n == 1) {
                    if (n2 >= 2) {
                        PM_TreeWindow.this.windowBase.doubleClickOnTree(defaultMutableTreeNode, PM_TreeWindow.this.treeWindow);
                    }
                } else if (n == 3) {
                    PM_TreeWindow.this.showContextMenu(mouseEvent, defaultMutableTreeNode);
                }
            }
        };
        this.addMouseListener(mouseAdapter);
    }

    private DefaultTreeCellRenderer getDefaultTreeCellRenderer() {
        DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer(){

            public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
                if (PM_TreeWindow.this.font == null) {
                    PM_TreeWindow.this.font = this.getFont();
                }
                if (PM_TreeWindow.this.fgColor == null) {
                    PM_TreeWindow.this.fgColor = this.getForeground();
                }
                if (PM_TreeWindow.this.bgColor == null) {
                    PM_TreeWindow.this.bgColor = this.getBackground();
                }
                this.setFont(PM_TreeWindow.this.font);
                this.setForeground(PM_TreeWindow.this.fgColor);
                this.setBackground(PM_TreeWindow.this.bgColor);
                if (object instanceof DefaultMutableTreeNode) {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
                    if (defaultMutableTreeNode.isLeaf() && !(defaultMutableTreeNode.getUserObject() instanceof PM_Sequence) && !(defaultMutableTreeNode.getUserObject() instanceof PM_PictureDirectory)) {
                        this.setForeground(Color.GREEN);
                        this.setFont(new Font("Arial", 1, 12));
                        return this;
                    }
                    PM_TreeWindow.this.renderCell(jTree, defaultMutableTreeNode, this);
                }
                return this;
            }
        };
        return defaultTreeCellRenderer;
    }

    protected void renderCell(JTree jTree, DefaultMutableTreeNode defaultMutableTreeNode, DefaultTreeCellRenderer defaultTreeCellRenderer) {
    }

    protected void renderCellBaseExtended(JTree jTree, DefaultMutableTreeNode defaultMutableTreeNode, DefaultTreeCellRenderer defaultTreeCellRenderer) {
        Set<DefaultMutableTreeNode> set = this.treeModel.getNodesNotInAlbum();
        if (set.contains(defaultMutableTreeNode)) {
            defaultTreeCellRenderer.setFont(new Font("Arial", 1, 12));
            return;
        }
    }

    private void showContextMenu(MouseEvent mouseEvent, final DefaultMutableTreeNode defaultMutableTreeNode) {
        this.popup = new JPopupMenu();
        this.menuItemZeileLoeschen = new JMenuItem("l\u00f6schen Eintrag");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_TreeWindow.this.doMenuItemDelete(defaultMutableTreeNode);
            }
        };
        this.menuItemZeileLoeschen.addActionListener(actionListener);
        this.menuItemZeileAendern = new JMenuItem("\u00e4ndern Name");
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (PM_TreeWindow.this.doMenuItemChangeName(defaultMutableTreeNode)) {
                    PM_TreeWindow.this.treeModel.nodeChanged(defaultMutableTreeNode);
                    PM_TreeWindow.this.treeModel.fireNameChanged(defaultMutableTreeNode);
                }
            }
        };
        this.menuItemZeileAendern.addActionListener(actionListener2);
        this.menuItemNewNode = new JMenuItem("neuer Knoten");
        ActionListener actionListener3 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_TreeWindow.this.doMenuItemNewNode(defaultMutableTreeNode);
            }
        };
        this.menuItemNewNode.addActionListener(actionListener3);
        this.editPopupMenu(this.popup, defaultMutableTreeNode);
        if (this.popup.getSubElements().length > 0) {
            this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    protected void editPopupMenu(JPopupMenu jPopupMenu, DefaultMutableTreeNode defaultMutableTreeNode) {
    }

    protected void doMenuItemDelete(DefaultMutableTreeNode defaultMutableTreeNode) {
        int n = JOptionPane.showConfirmDialog(this, "Eintrag entfernen?", "Sicherheitsabfrage", 0, 3);
        if (n == 1) {
            return;
        }
        this.treeModel.removeNodeFromParent(defaultMutableTreeNode);
        this.treeModel.nodeChanged(this.treeModel.getRootNode());
    }

    private boolean doMenuItemChangeName(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode.getParent() == null) {
            return false;
        }
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof String) {
            String string = this.getNewNameDialog(object.toString());
            if (string == null) {
                return false;
            }
            defaultMutableTreeNode.setUserObject(string);
            return true;
        }
        if (object instanceof PM_Sequence) {
            PM_Sequence pM_Sequence = (PM_Sequence)object;
            String string = this.getNewNameDialog(pM_Sequence.getLongName());
            if (string == null) {
                return false;
            }
            pM_Sequence.setLongName(string);
            return true;
        }
        return false;
    }

    private boolean doMenuItemNewNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        String string = this.getNewNameDialog("neuer Name");
        if (string == null) {
            return false;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(string);
        this.treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, 0);
        TreePath treePath = this.getTreePath(defaultMutableTreeNode);
        if (this.isCollapsed(treePath)) {
            this.expandPath(treePath);
        }
        return true;
    }

    protected String getNewNameDialog(String string) {
        String string2 = "Gib einen neuen Namen ein.";
        String string3 = JOptionPane.showInputDialog(string2, (Object)string);
        if (string3 == null || !(string3 instanceof String)) {
            return null;
        }
        String string4 = string3;
        string4 = string4.trim();
        if ((string4 = string4.replaceAll("\\.", " ")).length() == 0) {
            return "????????";
        }
        return string4;
    }

    public void expandTree(int n) {
        Enumeration<TreeNode> enumeration = this.rootNode.preorderEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            TreePath treePath = this.getTreePath(defaultMutableTreeNode);
            if (treePath.getPathCount() > n || !this.isCollapsed(treePath)) continue;
            this.expandPath(treePath);
        }
    }

    protected TreePath getTreePath(DefaultMutableTreeNode defaultMutableTreeNode) {
        ArrayList<DefaultMutableTreeNode> arrayList = new ArrayList<DefaultMutableTreeNode>();
        arrayList.add(defaultMutableTreeNode);
        for (DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent(); defaultMutableTreeNode2 != null; defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getParent()) {
            arrayList.add(0, defaultMutableTreeNode2);
        }
        return new TreePath(arrayList.toArray());
    }
}

