/*
 * Decompiled with CFR 0.152.
 */
import edu.umd.cs.jazz.util.ZCanvas;
import java.awt.Cursor;

public class EventHandlers {
    ImagePane imagePane;
    ZCanvas canvas;
    Cursor prevCursor = null;
    public static final int PAN_MODE = 1;
    public static final int SELECTION_MODE = 2;
    KeyNavEventHandler keyNavHandler;
    RegionEventHandler regionHandler;
    PreviewEventHandler previewHandler;
    ImageEventHandler imageHandler;
    HiResEventHandler hiResHandler;
    PanEventHandler panHandler;
    SelectionEventHandler selectionHandler;
    FileManipEventHandler fileManipHandler;
    PopupMenuEventHandler popupMenuHandler;
    int eventMode = 1;

    public EventHandlers(ImagePane imagePane, ZCanvas zCanvas) {
        this.imagePane = imagePane;
        this.canvas = zCanvas;
        this.keyNavHandler = new KeyNavEventHandler(this.imagePane, zCanvas.getCameraNode(), zCanvas);
        this.regionHandler = new RegionEventHandler(this.imagePane, zCanvas.getCameraNode());
        this.previewHandler = new PreviewEventHandler(this.imagePane, zCanvas.getCameraNode());
        this.imageHandler = new ImageEventHandler(this.imagePane, zCanvas.getCameraNode());
        this.hiResHandler = new HiResEventHandler(this.imagePane, zCanvas.getCameraNode());
        this.panHandler = new PanEventHandler(this.imagePane, zCanvas.getCameraNode());
        this.selectionHandler = new SelectionEventHandler(this.imagePane, zCanvas.getCameraNode());
        this.fileManipHandler = new FileManipEventHandler(this.imagePane, zCanvas.getCameraNode(), zCanvas);
        this.popupMenuHandler = new PopupMenuEventHandler(this.imagePane, zCanvas.getCameraNode(), zCanvas);
    }

    void activateEventHandlers() {
        this.selectionHandler.setActive(true);
        this.selectionHandler.getMouseFilter().rejectAllEventTypes();
        this.popupMenuHandler.setActive(true);
        this.fileManipHandler.setActive(true);
        this.panHandler.setActive(true);
        this.hiResHandler.setActive(true);
        this.imageHandler.setActive(true);
        this.previewHandler.setActive(true);
        this.regionHandler.setActive(true);
        this.keyNavHandler.setActive(true);
        if (this.imagePane.photomesa.state.getLayoutType() == 3) {
            this.imageHandler.getMouseFilter().rejectAllEventTypes();
            this.previewHandler.getMouseFilter().rejectAllEventTypes();
        } else {
            this.imageHandler.getMouseFilter().acceptAllEventTypes();
            this.previewHandler.getMouseFilter().acceptAllEventTypes();
        }
        this.setEventMode(this.eventMode);
    }

    void setEventMode(int n) {
        switch (n) {
            case 1: {
                this.imagePane.clearSelection();
                this.canvas.setCursor(Cursor.getPredefinedCursor(12));
                this.selectionHandler.getMouseFilter().rejectAllEventTypes();
                this.panHandler.getMouseFilter().acceptAllEventTypes();
                this.imageHandler.getMouseFilter().acceptAllEventTypes();
                this.hiResHandler.getMouseFilter().acceptAllEventTypes();
                break;
            }
            case 2: {
                this.canvas.setCursor(Cursor.getPredefinedCursor(0));
                this.selectionHandler.getMouseFilter().acceptAllEventTypes();
                this.panHandler.getMouseFilter().rejectAllEventTypes();
                this.imageHandler.getMouseFilter().rejectAllEventTypes();
                this.hiResHandler.getMouseFilter().rejectAllEventTypes();
                this.imagePane.stopHiliteFade();
            }
        }
        this.eventMode = n;
    }

    int getEventMode() {
        return this.eventMode;
    }

    boolean isInteracting() {
        return this.isSpaceBarDown() || this.isDragging();
    }

    boolean isSpaceBarDown() {
        return this.keyNavHandler.isSpaceBarDown();
    }

    boolean isDragging() {
        return this.panHandler.isDragging();
    }
}

