/*
 * Decompiled with CFR 0.152.
 */
import edu.umd.cs.jazz.ZSceneGraphObject;
import edu.umd.cs.jazz.event.ZFilteredEventHandler;
import edu.umd.cs.jazz.event.ZMouseEvent;
import edu.umd.cs.jazz.util.ZCanvas;
import edu.umd.cs.jazz.util.ZSceneGraphPath;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.SwingUtilities;

class FileManipEventHandler
extends ZFilteredEventHandler {
    ImagePane imagePane = null;
    ZCanvas canvas;
    ImageItem currentImageItem = null;
    ImageItem renamingImageItem = null;
    boolean renamingSelection = false;

    public FileManipEventHandler(ImagePane imagePane, ZSceneGraphObject zSceneGraphObject, ZCanvas zCanvas) {
        super(zSceneGraphObject, zCanvas);
        this.imagePane = imagePane;
        this.canvas = zCanvas;
        this.getMouseFilter().rejectAllEventTypes();
        this.getMouseFilter().setAcceptsMouseMoved(true);
    }

    public void filteredMousePressed(ZMouseEvent zMouseEvent) {
        this.canvas.requestFocus();
    }

    public void filteredMouseMoved(ZMouseEvent zMouseEvent) {
        ZSceneGraphPath zSceneGraphPath = zMouseEvent.getPath();
        PMImage pMImage = (PMImage)zSceneGraphPath.getObject();
        this.currentImageItem = pMImage == null ? null : pMImage.getImageItem();
    }

    public void filteredKeyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        switch (n) {
            case 113: {
                if (this.currentImageItem == null) break;
                this.startRename(this.currentImageItem);
                break;
            }
            default: {
                if (this.renamingImageItem == null) {
                    if (n != 127) break;
                    if (this.imagePane.eventHandlers.getEventMode() == 1) {
                        if (this.currentImageItem == null) break;
                        this.imagePane.deleteImage(this.currentImageItem);
                        break;
                    }
                    this.imagePane.deleteSelectedImages();
                    break;
                }
                if (this.renamingImageItem.interactiveRenameKeyPress(keyEvent)) break;
                this.imagePane.eventHandlers.keyNavHandler.setActive(true);
                this.imagePane.eventHandlers.previewHandler.getMouseFilter().acceptAllEventTypes();
                if (this.renamingSelection) {
                    int n2 = 1;
                    File file = this.renamingImageItem.getFile();
                    Vector vector = this.imagePane.getSelectionImageItems();
                    int n3 = 1;
                    while (n3 < vector.size()) {
                        File file2;
                        ImageItem imageItem = (ImageItem)vector.elementAt(n3);
                        do {
                            int n4 = file.getName().lastIndexOf(46);
                            String string = file.getName().substring(0, n4) + " " + n2 + file.getName().substring(n4);
                            file2 = new File(file.getParentFile(), string);
                            ++n2;
                        } while (file2.exists());
                        imageItem.renameTo(file2);
                        ++n3;
                    }
                    this.renamingSelection = false;
                }
                this.renamingImageItem = null;
            }
        }
    }

    void cancelRename() {
        if (this.renamingImageItem != null) {
            this.renamingImageItem.interactiveRenameKeyPress(null);
            this.renamingImageItem = null;
        }
    }

    protected void startRename(ImageItem imageItem) {
        if (this.renamingImageItem != null) {
            this.renamingImageItem.interactiveRenameKeyPress(null);
        }
        imageItem.interactiveRename();
        this.renamingImageItem = imageItem;
        this.imagePane.eventHandlers.keyNavHandler.setActive(false);
        this.imagePane.stopPreview();
        this.imagePane.eventHandlers.previewHandler.getMouseFilter().rejectAllEventTypes();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FileManipEventHandler.this.canvas.requestFocus();
            }
        });
    }

    public void renameSelection() {
        Vector vector = this.imagePane.getSelectionImageItems();
        if (vector.size() >= 1) {
            ImageItem imageItem = (ImageItem)vector.elementAt(0);
            this.canvas.requestFocus();
            this.startRename(imageItem);
            this.renamingSelection = true;
        }
    }

    public void renameSelection(ImageItem imageItem) {
        if (imageItem != null) {
            this.canvas.requestFocus();
            this.startRename(imageItem);
            this.renamingSelection = true;
        }
    }
}

