/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz;

import edu.umd.cs.jazz.ZCamera;
import edu.umd.cs.jazz.ZGroup;
import edu.umd.cs.jazz.ZLayerGroup;
import edu.umd.cs.jazz.ZNode;
import edu.umd.cs.jazz.ZSelectionGroup;
import edu.umd.cs.jazz.event.ZGroupEvent;
import edu.umd.cs.jazz.event.ZGroupListener;
import edu.umd.cs.jazz.util.ZFindFilter;
import edu.umd.cs.jazz.util.ZSceneGraphEditor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.event.EventListenerList;

public class ZSelectionManager {
    private static final Object ALL_CAMERA_LISTENERS = new Object();
    private static transient HashMap listenerListMap = new HashMap();
    static /* synthetic */ Class class$edu$umd$cs$jazz$event$ZGroupListener;

    private ZSelectionManager() {
    }

    public static void addGroupListener(ZGroupListener l) {
        EventListenerList listenerList = (EventListenerList)listenerListMap.get(ALL_CAMERA_LISTENERS);
        if (listenerList == null) {
            listenerList = new EventListenerList();
            listenerListMap.put(ALL_CAMERA_LISTENERS, listenerList);
        }
        listenerList.add(class$edu$umd$cs$jazz$event$ZGroupListener == null ? (class$edu$umd$cs$jazz$event$ZGroupListener = ZSelectionManager.class$("edu.umd.cs.jazz.event.ZGroupListener")) : class$edu$umd$cs$jazz$event$ZGroupListener, l);
    }

    public static void removeGroupListener(ZGroupListener l) {
        EventListenerList listenerList = (EventListenerList)listenerListMap.get(ALL_CAMERA_LISTENERS);
        if (listenerList != null) {
            listenerList.remove(class$edu$umd$cs$jazz$event$ZGroupListener == null ? (class$edu$umd$cs$jazz$event$ZGroupListener = ZSelectionManager.class$("edu.umd.cs.jazz.event.ZGroupListener")) : class$edu$umd$cs$jazz$event$ZGroupListener, l);
        }
    }

    public static void addGroupListener(ZGroupListener l, ZCamera camera) {
        EventListenerList listenerList = (EventListenerList)listenerListMap.get(camera);
        if (listenerList == null) {
            listenerList = new EventListenerList();
            listenerListMap.put(camera, listenerList);
        }
        listenerList.add(class$edu$umd$cs$jazz$event$ZGroupListener == null ? (class$edu$umd$cs$jazz$event$ZGroupListener = ZSelectionManager.class$("edu.umd.cs.jazz.event.ZGroupListener")) : class$edu$umd$cs$jazz$event$ZGroupListener, l);
    }

    public static void removeGroupListener(ZGroupListener l, ZCamera camera) {
        EventListenerList listenerList = (EventListenerList)listenerListMap.get(camera);
        if (listenerList != null) {
            listenerList.remove(class$edu$umd$cs$jazz$event$ZGroupListener == null ? (class$edu$umd$cs$jazz$event$ZGroupListener = ZSelectionManager.class$("edu.umd.cs.jazz.event.ZGroupListener")) : class$edu$umd$cs$jazz$event$ZGroupListener, l);
        }
    }

    protected static void fireGroupEvent(int id, ZGroup group, ZNode child) {
        EventListenerList globalListenerList = (EventListenerList)listenerListMap.get(ALL_CAMERA_LISTENERS);
        if (globalListenerList != null) {
            Object[] listeners = globalListenerList.getListenerList();
            ZGroupEvent e = null;
            if (id == 100) {
                e = ZGroupEvent.createNodeAddedEvent(group, child, false);
            } else if (id == 101) {
                e = ZGroupEvent.createNodeRemovedEvent(group, child, false);
            }
            int j = listeners.length - 2;
            while (j >= 0) {
                if (listeners[j] == e.getListenerType()) {
                    e.dispatchTo(listeners[j + 1]);
                }
                j -= 2;
            }
        }
        ZGroup ancestor = child.getParent();
        while (ancestor != null) {
            if (ancestor instanceof ZLayerGroup) {
                ZCamera[] cameras = ((ZLayerGroup)ancestor).getCamerasReference();
                int i = 0;
                while (i < cameras.length) {
                    EventListenerList listenerList = (EventListenerList)listenerListMap.get(cameras[i]);
                    if (listenerList != null) {
                        Object[] listeners = listenerList.getListenerList();
                        ZGroupEvent e = null;
                        if (id == 100) {
                            e = ZGroupEvent.createNodeAddedEvent(group, child, false);
                        } else if (id == 101) {
                            e = ZGroupEvent.createNodeRemovedEvent(group, child, false);
                        }
                        int j = listeners.length - 2;
                        while (j >= 0) {
                            if (listeners[j] == e.getListenerType()) {
                                e.dispatchTo(listeners[j + 1]);
                            }
                            j -= 2;
                        }
                    }
                    ++i;
                }
            }
            ancestor = ancestor.getParent();
        }
    }

    public static ArrayList getSelectedNodes(ZNode node) {
        ArrayList selection = new ArrayList();
        node.findNodes(new SelectionFilter(), selection);
        return selection;
    }

    public static ArrayList getSelectedNodes(ZCamera camera) {
        ArrayList selection = new ArrayList();
        ZLayerGroup[] layers = camera.getLayersReference();
        int i = 0;
        while (i < camera.getNumLayers()) {
            layers[i].findNodes(new SelectionFilter(), selection);
            ++i;
        }
        return selection;
    }

    public static ZSelectionGroup select(ZNode node) {
        if (node != null && node.isSelectable()) {
            ZSelectionGroup group = node.editor().getSelectionGroup();
            ZSelectionManager.fireGroupEvent(100, group, node);
            return group;
        }
        return null;
    }

    public static void unselect(ZNode node) {
        ZSceneGraphEditor editor = node.editor();
        if (editor.hasSelectionGroup()) {
            ZSelectionManager.fireGroupEvent(101, editor.getSelectionGroup(), node);
            editor.removeSelectionGroup();
        }
    }

    public static void unselectAll(ZNode node) {
        ArrayList selection = ZSelectionManager.getSelectedNodes(node);
        Iterator i = selection.iterator();
        while (i.hasNext()) {
            node = (ZNode)i.next();
            ZSelectionManager.unselect(node);
        }
    }

    public static void unselectAll(ZCamera camera) {
        if (camera == null) {
            return;
        }
        ArrayList selection = ZSelectionManager.getSelectedNodes(camera);
        Iterator i = selection.iterator();
        while (i.hasNext()) {
            ZNode node = (ZNode)i.next();
            ZSelectionManager.unselect(node);
        }
    }

    public static boolean isSelected(ZNode node) {
        if (node == null) {
            return false;
        }
        return node.editor().hasSelectionGroup();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class SelectionFilter
    implements ZFindFilter {
        private SelectionFilter() {
        }

        public boolean accept(ZNode node) {
            if (node instanceof ZGroup && ((ZGroup)node).hasOneChild()) {
                return false;
            }
            return ZSelectionManager.isSelected(node);
        }

        public boolean childrenFindable(ZNode node) {
            return true;
        }
    }
}

