/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz;

import edu.umd.cs.jazz.ZCamera;
import edu.umd.cs.jazz.ZConstraintGroup;
import edu.umd.cs.jazz.ZGroup;
import edu.umd.cs.jazz.ZNode;
import edu.umd.cs.jazz.ZTransformGroup;
import edu.umd.cs.jazz.io.ZObjectOutputStream;
import edu.umd.cs.jazz.util.ZBounds;
import edu.umd.cs.jazz.util.ZNoninvertibleTransformException;
import edu.umd.cs.jazz.util.ZSceneGraphEditor;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class ZStickyGroup
extends ZConstraintGroup
implements Serializable {
    public static final int STICKY = 1;
    public static final int STICKYZ = 2;
    public static double stickyPointX_DEFAULT;
    public static double stickyPointY_DEFAULT;
    public static int constraintType_DEFAULT;
    private int constraintType = constraintType_DEFAULT;
    private double stickyPointX = stickyPointX_DEFAULT;
    private double stickyPointY = stickyPointY_DEFAULT;
    private transient Point2D pt = new Point2D.Double();

    public ZStickyGroup() {
    }

    public ZStickyGroup(ZCamera camera) {
        this.setCamera(camera);
    }

    public ZStickyGroup(ZNode child) {
        super(child);
    }

    public ZStickyGroup(ZCamera camera, ZNode child) {
        super(child);
        this.setCamera(camera);
    }

    public static ZStickyGroup makeSticky(ZNode node, ZCamera camera, int constraintType) {
        ZGroup parent = node.getParent();
        ZStickyGroup sticky = null;
        ZSceneGraphEditor editor = node.editor();
        if (editor.hasStickyGroup()) {
            sticky = editor.getStickyGroup();
        }
        if (sticky != null && sticky.getConstraintType() != constraintType) {
            ZStickyGroup.makeUnSticky(node);
            sticky = null;
        }
        if (sticky == null) {
            sticky = editor.getStickyGroup();
            sticky.setCamera(camera);
            sticky.setConstraintType(constraintType);
            ZTransformGroup transform = editor.getTransformGroup();
            transform.concatenate(sticky.getInverseTransform());
        }
        return sticky;
    }

    public static void makeUnSticky(ZNode node) {
        ZSceneGraphEditor editor = node.editor();
        ZStickyGroup sticky = null;
        if (editor.hasStickyGroup()) {
            sticky = editor.getStickyGroup();
            ZNode[] children = sticky.getChildren();
            ZGroup newParent = sticky.getParent();
            AffineTransform stickyTransform = sticky.getTransform();
            newParent.removeChild(sticky);
            int i = 0;
            while (i < children.length) {
                children[i].setParent(newParent);
                editor = children[i].editor();
                ZNode primary = editor.getNode();
                editor.getTransformGroup().concatenate(stickyTransform);
                ++i;
            }
        }
    }

    public void setStickyPoint(double x, double y) {
        this.stickyPointX = x;
        this.stickyPointY = y;
        this.updateTransform();
    }

    public Dimension getStickyPoint() {
        Dimension d = new Dimension();
        d.setSize(this.stickyPointX, this.stickyPointY);
        return d;
    }

    public void setConstraintType(int constraintType) {
        this.constraintType = constraintType;
        this.updateTransform();
    }

    public int getConstraintType() {
        return this.constraintType;
    }

    public AffineTransform computeTransform() {
        AffineTransform at = null;
        switch (this.constraintType) {
            case 1: {
                at = this.computeStickyTransform();
                break;
            }
            case 2: {
                at = this.computeStickyZTransform();
            }
        }
        return at;
    }

    public AffineTransform computeStickyTransform() {
        AffineTransform at = new AffineTransform();
        if (this.camera != null) {
            try {
                AffineTransform globalCoordFrame = this.parent == null ? new AffineTransform() : this.parent.getLocalToGlobalTransform();
                at = globalCoordFrame.createInverse();
                at.concatenate(this.camera.getInverseViewTransformReference());
                at.concatenate(globalCoordFrame);
            }
            catch (NoninvertibleTransformException e) {
                throw new ZNoninvertibleTransformException(e);
            }
        }
        return at;
    }

    protected AffineTransform computeStickyZTransform() {
        AffineTransform at = new AffineTransform();
        if (this.camera != null) {
            double iscale = 1.0 / this.camera.getMagnification();
            ZBounds childrenBounds = new ZBounds();
            ZNode[] childrenRef = this.getChildrenReference();
            int i = 0;
            while (i < this.children.size()) {
                childrenBounds.add(childrenRef[i].getBoundsReference());
                ++i;
            }
            this.pt.setLocation(childrenBounds.getX() + this.stickyPointX * childrenBounds.getWidth(), childrenBounds.getY() + this.stickyPointY * childrenBounds.getHeight());
            at.translate(this.pt.getX(), this.pt.getY());
            at.scale(iscale, iscale);
            at.translate(-this.pt.getX(), -this.pt.getY());
        }
        return at;
    }

    public String dump() {
        String str = super.dump();
        switch (this.constraintType) {
            case 1: {
                str = str + "\n Sticky constraint";
                break;
            }
            case 2: {
                str = str + "\n Sticky-Z constraint";
            }
        }
        return str;
    }

    public void writeObject(ZObjectOutputStream out) throws IOException {
        super.writeObject(out);
        if (this.constraintType != constraintType_DEFAULT) {
            out.writeState("int", "constraintType", this.constraintType);
        }
        if (this.stickyPointX != stickyPointX_DEFAULT) {
            out.writeState("double", "stickyPointX", this.stickyPointX);
        }
        if (this.stickyPointY != stickyPointY_DEFAULT) {
            out.writeState("double", "stickyPointY", this.stickyPointY);
        }
    }

    public void setState(String fieldType, String fieldName, Object fieldValue) {
        super.setState(fieldType, fieldName, fieldValue);
        if (fieldName.compareTo("constraintType") == 0) {
            this.constraintType = (Integer)fieldValue;
        } else if (fieldName.compareTo("stickyPointX") == 0) {
            this.stickyPointX = (Double)fieldValue;
        } else if (fieldName.compareTo("stickyPointY") == 0) {
            this.stickyPointY = (Double)fieldValue;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.pt = new Point2D.Double();
    }

    static {
        STICKY = 1;
        STICKYZ = 2;
        stickyPointX_DEFAULT = 0.5;
        stickyPointY_DEFAULT = 0.5;
        constraintType_DEFAULT = 1;
    }
}

