/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz;

import edu.umd.cs.jazz.ZGroup;
import edu.umd.cs.jazz.ZLayoutGroup;
import edu.umd.cs.jazz.ZLayoutManager;
import edu.umd.cs.jazz.ZNode;
import edu.umd.cs.jazz.ZTransformGroup;
import edu.umd.cs.jazz.ZVisualComponent;
import edu.umd.cs.jazz.ZVisualGroup;
import edu.umd.cs.jazz.ZVisualLeaf;
import edu.umd.cs.jazz.component.ZStroke;
import edu.umd.cs.jazz.io.ZObjectOutputStream;
import edu.umd.cs.jazz.io.ZSerializable;
import edu.umd.cs.jazz.util.ZBounds;
import edu.umd.cs.jazz.util.ZRenderContext;
import edu.umd.cs.jazz.util.ZSceneGraphEditor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Hashtable;

public class ZTreeLayoutManager
implements ZLayoutManager,
ZSerializable,
Serializable,
Cloneable {
    public static final int ORIENT_VERTICAL = 0;
    public static final int ORIENT_HORIZONTAL = 1;
    public static final int HEAD_IN = 0;
    public static final int HEAD_OUT = 1;
    public static final int HEAD_SIDE = 2;
    public static final int LINK_STRAIGHTLINE = 0;
    public static final int LINK_ANGLEDLINE = 1;
    protected static double DEFAULT_SPACING;
    protected static final Point2D ORIGIN;
    protected int currentHeadStyle = 0;
    protected int currentOrientation = 0;
    protected double currentXSpacing = DEFAULT_SPACING;
    protected double currentYSpacing = DEFAULT_SPACING;
    protected int currentLinkStyle = 0;
    protected boolean linkVisible = true;
    protected Hashtable areaManager = new Hashtable();
    protected Hashtable transformTable = new Hashtable();
    protected ArrayList transformNodes = new ArrayList();
    protected int recurseLevel = 0;

    public ZTreeLayoutManager() {
        this.areaManager = new Hashtable();
        this.transformTable = new Hashtable();
        this.transformNodes = new ArrayList();
    }

    public Object clone() {
        Object newObject;
        try {
            newObject = super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Error in Object.clone(): " + e);
        }
        return newObject;
    }

    public ZTreeLayoutManager(int orientation, int headingStyle, boolean showLink, int linkStyle) {
        this.currentOrientation = orientation;
        this.currentHeadStyle = headingStyle;
        if (showLink) {
            this.linkVisible = true;
            this.setLinkStyle(null, linkStyle);
        } else {
            this.linkVisible = false;
        }
    }

    public boolean setCurrentOrientation(ZLayoutGroup layout, int orientation) {
        boolean rc;
        if (orientation == 0 || orientation == 1) {
            this.currentOrientation = orientation;
            rc = true;
        } else {
            rc = false;
        }
        if (layout != null && rc) {
            ZLayoutGroup.invalidateChildren(layout);
            layout.invalidate();
        }
        return rc;
    }

    public int getCurrentOrientation() {
        return this.currentOrientation;
    }

    public boolean setCurrentHeadingStyle(ZLayoutGroup layout, int h) {
        boolean rc;
        if ((h == 0 || h == 1 || h == 2) && this.currentHeadStyle != h) {
            this.currentHeadStyle = h;
            rc = true;
        } else {
            rc = false;
        }
        if (layout != null && rc) {
            ZLayoutGroup.invalidateChildren(layout);
            layout.invalidate();
        }
        return rc;
    }

    public int getCurrentHeadStyle() {
        return this.currentHeadStyle;
    }

    public boolean setCurrentXSpacing(double x) {
        if (x > 0.0 && x != this.currentXSpacing) {
            this.currentXSpacing = x;
            return true;
        }
        return false;
    }

    public boolean setCurrentYSpacing(double y) {
        if (y > 0.0 && y != this.currentYSpacing) {
            this.currentYSpacing = y;
            return true;
        }
        return false;
    }

    public double getCurrentXSpacing() {
        return this.currentXSpacing;
    }

    public double getCurrentYSpacing() {
        return this.currentYSpacing;
    }

    public int getLinkStyle() {
        return this.currentLinkStyle;
    }

    public boolean setLinkStyle(ZLayoutGroup layout, int v) {
        boolean rc;
        if ((v == 0 || v == 1) && v != this.currentLinkStyle) {
            this.currentLinkStyle = v;
            rc = true;
        } else {
            rc = false;
        }
        if (layout != null) {
            ZLayoutGroup.invalidateChildren(layout);
            layout.invalidate();
        }
        return rc;
    }

    public void preLayout(ZGroup aLayoutGroup) {
        ++this.recurseLevel;
    }

    public void doLayout(ZGroup node, int millis) {
        System.out.println("WARNING: Layout animation not implemented yet - layout being applied without animation.");
        this.doLayout(node);
    }

    public void doLayout(ZGroup aLayoutGroup) {
        ZNode primary = aLayoutGroup.editor().getNode();
        if (primary instanceof ZGroup) {
            this.calculateChildrenLayout((ZGroup)primary);
        }
        this.computeNodeArea(primary);
    }

    public void postLayout(ZGroup aLayoutGroup) {
        --this.recurseLevel;
        if (this.recurseLevel == 0) {
            this.updateTree();
            this.resetTransformVariables();
            ZTreeLayoutManager.updateInvalidLinks(aLayoutGroup.editor().getLayoutGroup());
        }
    }

    protected void calculateChildrenLayout(ZGroup aPrimaryGroup) {
        ZLayoutGroup layoutGroup;
        ZBounds bounds;
        ZNode childPrimary;
        ZSceneGraphEditor childEditor;
        double lastX = 0.0;
        double lastY = 0.0;
        Area currentUsage = new Area();
        Area childUsage = null;
        ZBounds immediateChildrenBounds = new ZBounds();
        ZNode[] children = aPrimaryGroup.getChildren();
        double[] matrix = new double[6];
        int i = 0;
        while (i < children.length) {
            childEditor = children[i].editor();
            childPrimary = childEditor.getNode();
            bounds = null;
            if (i == 0) {
                Point2D trans = this.setDestinationPoint(childPrimary, ORIGIN);
                this.updateChildArea(childPrimary, trans);
                bounds = this.getFrontVisualComponentBounds(childPrimary);
                if (bounds == null) {
                    bounds = new ZBounds();
                }
                bounds.transform(childEditor.getTransformGroup().getTransform());
                this.padBounds(bounds);
                bounds.setRect(0.0, 0.0, bounds.getWidth(), bounds.getHeight());
                currentUsage.add(this.getNodeArea(childPrimary));
                lastX = bounds.getWidth();
                lastY = bounds.getHeight();
            } else {
                Point2D.Double dest = this.currentOrientation == 0 ? new Point2D.Double(lastX, 0.0) : new Point2D.Double(0.0, lastY);
                Point2D trans = this.setDestinationPoint(childPrimary, dest);
                childUsage = this.updateChildArea(childPrimary, trans);
                do {
                    trans = this.computeOverlap(currentUsage, childUsage);
                    ((Point2D)dest).setLocation(((Point2D)dest).getX() + trans.getX(), ((Point2D)dest).getY() + trans.getY());
                    this.translateDestinationPoint(childPrimary, trans);
                    childUsage = this.updateChildArea(childPrimary, trans);
                } while (trans.getX() > 0.0 || trans.getY() > 0.0);
                bounds = this.getFrontVisualComponentBounds(childPrimary);
                if (bounds == null) {
                    bounds = new ZBounds();
                }
                bounds.transform(childEditor.getTransformGroup().getTransform());
                this.padBounds(bounds);
                bounds.setRect(((Point2D)dest).getX(), ((Point2D)dest).getY(), bounds.getWidth(), bounds.getHeight());
                currentUsage.add(childUsage);
                lastX = bounds.getX() + bounds.getWidth();
                lastY = bounds.getY() + bounds.getHeight();
            }
            immediateChildrenBounds.add(bounds);
            ++i;
        }
        if (children.length > 0 && (bounds = this.getFrontVisualComponentBounds(aPrimaryGroup)) != null) {
            double transX = 0.0;
            double transY = 0.0;
            Rectangle allChildrenBounds = currentUsage.getBounds();
            if (this.currentHeadStyle == 0) {
                if (this.currentOrientation == 0) {
                    transX = 0.5 * (bounds.getWidth() - immediateChildrenBounds.getWidth()) + bounds.getX() - immediateChildrenBounds.getX();
                    transY = bounds.getHeight() + 0.5 * this.currentYSpacing;
                } else {
                    transX = bounds.getWidth() + 0.5 * this.currentXSpacing;
                    transY = 0.5 * (bounds.getHeight() - immediateChildrenBounds.getHeight()) + bounds.getY() - immediateChildrenBounds.getY();
                }
            } else if (this.currentHeadStyle == 1) {
                if (this.currentOrientation == 0) {
                    transX = 0.5 * (bounds.getWidth() - ((RectangularShape)allChildrenBounds).getWidth()) + bounds.getX() - ((RectangularShape)allChildrenBounds).getX();
                    transY = bounds.getHeight() + 0.5 * this.currentYSpacing;
                } else {
                    transX = bounds.getWidth() + 0.5 * this.currentXSpacing;
                    transY = 0.5 * (bounds.getHeight() - ((RectangularShape)allChildrenBounds).getHeight()) + bounds.getY() - ((RectangularShape)allChildrenBounds).getY();
                }
            } else if (this.currentOrientation == 0) {
                transX = bounds.getX() - immediateChildrenBounds.getX() - 0.5 * this.currentXSpacing;
                transY = bounds.getHeight() + 0.5 * this.currentYSpacing;
            } else {
                transX = bounds.getWidth() + 0.5 * this.currentXSpacing;
                transY = bounds.getY() - immediateChildrenBounds.getY() - 0.5 * this.currentYSpacing;
            }
            Point2D.Double trans = new Point2D.Double(transX, transY);
            int i2 = 0;
            while (i2 < children.length) {
                childPrimary = children[i2].editor().getNode();
                this.translateDestinationPoint(childPrimary, trans);
                this.updateChildArea(childPrimary, trans);
                ++i2;
            }
        }
        if ((layoutGroup = aPrimaryGroup.editor().getLayoutGroup()) != null && this.linkVisible) {
            ZVisualComponent vc = layoutGroup.getFrontVisualComponent();
            ZTreeLayoutManagerLink link = null;
            if (vc == null || !(vc instanceof ZTreeLayoutManagerLink)) {
                link = new ZTreeLayoutManagerLink();
                layoutGroup.setFrontVisualComponent(link);
            } else {
                link = (ZTreeLayoutManagerLink)vc;
                link.setLinkDirty(true);
            }
        }
        if (this.linkVisible) {
            int i3 = 0;
            while (i3 < children.length) {
                ZVisualComponent vc;
                childEditor = children[i3].editor();
                if (childEditor.hasLayoutGroup() && (vc = childEditor.getLayoutGroup().getFrontVisualComponent()) instanceof ZTreeLayoutManagerLink) {
                    ((ZTreeLayoutManagerLink)vc).setLinkDirty(true);
                }
                ++i3;
            }
        }
    }

    protected void updateTree() {
        Object[] groups = this.transformNodes.toArray();
        AffineTransform[] transforms = new AffineTransform[groups.length];
        int i = 0;
        while (i < groups.length) {
            transforms[i] = ((ZTransformGroup)groups[i]).getTransform();
            transforms[i].preConcatenate((AffineTransform)this.transformTable.get(groups[i]));
            ((ZTransformGroup)groups[i]).setTransform(transforms[i]);
            ++i;
        }
    }

    protected void translateDestinationPoint(ZNode aPrimaryNode, Point2D trans) {
        AffineTransform at = new AffineTransform();
        at.translate(trans.getX(), trans.getY());
        ZTransformGroup transGroup = aPrimaryNode.editor().getTransformGroup();
        AffineTransform oldAt = (AffineTransform)this.transformTable.get(transGroup);
        if (oldAt == null) {
            this.transformNodes.add(transGroup);
            this.transformTable.put(transGroup, at);
        } else {
            oldAt.concatenate(at);
            this.transformTable.put(transGroup, oldAt);
        }
    }

    protected Point2D setDestinationPoint(ZNode aPrimaryNode, Point2D dest) {
        ZTransformGroup transGroup = aPrimaryNode.editor().getTransformGroup();
        AffineTransform at = transGroup.getTransform();
        ZBounds localBounds = this.getFrontVisualComponentBounds(aPrimaryNode);
        if (localBounds == null) {
            localBounds = new ZBounds();
        }
        localBounds.transform(at);
        this.padBounds(localBounds);
        Point2D.Double trans = new Point2D.Double(dest.getX() - localBounds.getX(), dest.getY() - localBounds.getY());
        at.setToTranslation(((Point2D)trans).getX(), ((Point2D)trans).getY());
        if (this.transformTable.put(transGroup, at) == null) {
            this.transformNodes.add(transGroup);
        }
        return trans;
    }

    protected Area updateChildArea(ZNode aPrimaryNode, Point2D trans) {
        AffineTransform at = new AffineTransform();
        at.translate(trans.getX(), trans.getY());
        Area area = (Area)this.areaManager.get(aPrimaryNode);
        if (area == null) {
            ZBounds bounds = aPrimaryNode.getBounds();
            bounds.transform(aPrimaryNode.editor().getTransformGroup().getTransform());
            this.padBounds(bounds);
            area = new Area(bounds);
        }
        area.transform(at);
        this.areaManager.put(aPrimaryNode, area);
        return area;
    }

    protected void computeNodeArea(ZNode aPrimaryNode) {
        Area area;
        AffineTransform at = aPrimaryNode.editor().getTransformGroup().getTransform();
        ZBounds bounds = this.getFrontVisualComponentBounds(aPrimaryNode);
        if (bounds != null) {
            bounds.transform(at);
            this.padBounds(bounds);
            area = new Area(bounds);
        } else {
            area = new Area();
        }
        if (aPrimaryNode instanceof ZGroup) {
            ZNode[] children = ((ZGroup)aPrimaryNode).getChildren();
            int i = 0;
            while (i < children.length) {
                Area childArea;
                ZSceneGraphEditor editor = children[i].editor();
                try {
                    childArea = this.getNodeArea(editor.getNode());
                }
                catch (Exception e) {
                    childArea = new Area();
                }
                childArea.transform(at);
                area.add(childArea);
                ++i;
            }
        }
        this.areaManager.put(aPrimaryNode, area);
    }

    protected Area getNodeArea(ZNode aPrimaryNode) throws ConcurrentModificationException {
        Area area = (Area)((Area)this.areaManager.get(aPrimaryNode)).clone();
        if (area == null) {
            throw new ConcurrentModificationException("Jazz Scenegraph Modified Outside The Swing Event Thread");
        }
        return area;
    }

    protected ZBounds getFrontVisualComponentBounds(ZNode aVisualNode) {
        ZBounds bounds = null;
        if (aVisualNode instanceof ZVisualLeaf) {
            bounds = ((ZVisualLeaf)aVisualNode).getFirstVisualComponent().getBounds();
        } else if (aVisualNode instanceof ZVisualGroup) {
            bounds = ((ZVisualGroup)aVisualNode).getFrontVisualComponentBounds();
        }
        return bounds;
    }

    protected ZBounds padBounds(ZBounds bounds) {
        double spaceX = this.getCurrentXSpacing();
        double spaceY = this.getCurrentYSpacing();
        bounds.setRect(bounds.getX() - 0.5 * spaceX, bounds.getY() - 0.5 * spaceY, bounds.getWidth() + spaceX, bounds.getHeight() + spaceY);
        return bounds;
    }

    protected Point2D computeOverlap(Area a, Area b) {
        Point2D.Double retVal = new Point2D.Double();
        double x = 0.0;
        double y = 0.0;
        Area tmp = (Area)a.clone();
        tmp.intersect(b);
        if (!tmp.isEmpty()) {
            Rectangle bound = tmp.getBounds();
            if (this.currentOrientation == 0) {
                x = bound.getWidth() > this.currentXSpacing ? this.currentXSpacing : bound.getWidth();
            } else {
                y = bound.getHeight() > this.currentYSpacing ? this.currentYSpacing : bound.getHeight();
            }
        }
        retVal.setLocation(x, y);
        Rectangle2D bounds = tmp.getBounds2D();
        Rectangle2D.Double boundsRound = new Rectangle2D.Double((int)(bounds.getX() + 1.0), (int)(bounds.getY() + 1.0), (int)bounds.getWidth(), (int)bounds.getHeight());
        Area round = new Area(boundsRound);
        tmp.intersect(round);
        if (tmp.isEmpty()) {
            retVal.setLocation(0.0, 0.0);
        }
        return retVal;
    }

    protected void resetTransformVariables() {
        this.transformTable.clear();
        this.transformNodes.clear();
    }

    protected static void updateInvalidLinks(ZNode top) {
        if (top instanceof ZGroup) {
            ZVisualComponent vis;
            ZNode[] children = ((ZGroup)top).getChildren();
            int i = 0;
            while (i < children.length) {
                ZTreeLayoutManager.updateInvalidLinks(children[i]);
                ++i;
            }
            if (top instanceof ZLayoutGroup && (vis = ((ZLayoutGroup)top).getFrontVisualComponent()) instanceof ZTreeLayoutManagerLink) {
                ((ZTreeLayoutManagerLink)vis).updateLink();
            }
        }
    }

    public void writeObject(ZObjectOutputStream out) throws IOException {
        if (this.currentHeadStyle != 0) {
            out.writeState("int", "currentHeadStyle", this.currentHeadStyle);
        }
        if (this.currentXSpacing != DEFAULT_SPACING) {
            out.writeState("double", "currentXSpacing", this.currentXSpacing);
        }
        if (this.currentYSpacing != DEFAULT_SPACING) {
            out.writeState("double", "currentYSpacing", this.currentYSpacing);
        }
        if (this.currentLinkStyle != 0) {
            out.writeState("int", "currentLinkStyle", this.currentLinkStyle);
        }
        out.writeState("boolean", "linkVisible", this.linkVisible);
        out.writeState("java.util.HashTable", "areaManager", this.areaManager);
        out.writeState("java.util.HashTable", "transformTable", this.transformTable);
        out.writeState("java.util.ArrayList", "transformNodes", this.transformNodes);
        out.writeState("int", "recurseLevel", this.recurseLevel);
    }

    public void writeObjectRecurse(ZObjectOutputStream out) throws IOException {
    }

    public void setState(String fieldType, String fieldName, Object fieldValue) {
        if (fieldName.compareTo("currentHeadStyle") == 0) {
            this.currentHeadStyle = (Integer)fieldValue;
        } else if (fieldName.compareTo("currentXSpacing") == 0) {
            this.setCurrentXSpacing((Double)fieldValue);
        } else if (fieldName.compareTo("currentYSpacing") == 0) {
            this.setCurrentYSpacing((Double)fieldValue);
        } else if (fieldName.compareTo("currentLinkStyle") == 0) {
            this.currentLinkStyle = (Integer)fieldValue;
        } else if (fieldName.compareTo("linkVisible") == 0) {
            this.linkVisible = (Boolean)fieldValue;
        } else if (fieldName.compareTo("areaManager") == 0) {
            this.areaManager = (Hashtable)fieldValue;
        } else if (fieldName.compareTo("transformTable") == 0) {
            this.transformTable = (Hashtable)fieldValue;
        } else if (fieldName.compareTo("transformNodes") == 0) {
            this.transformNodes = (ArrayList)fieldValue;
        } else if (fieldName.compareTo("recurseLevel") == 0) {
            this.recurseLevel = (Integer)fieldValue;
        }
    }

    static {
        ORIENT_VERTICAL = 0;
        ORIENT_HORIZONTAL = 1;
        HEAD_IN = 0;
        HEAD_OUT = 1;
        HEAD_SIDE = 2;
        LINK_STRAIGHTLINE = 0;
        LINK_ANGLEDLINE = 1;
        DEFAULT_SPACING = 20.0;
        ORIGIN = new Point2D.Double(0.0, 0.0);
    }

    class ZTreeLayoutManagerLink
    extends ZVisualComponent
    implements ZStroke {
        protected Color penColor = Color.black;
        protected BasicStroke stroke = new BasicStroke(2.0f);
        protected double penWidth = 1.0;
        Shape visLink = null;
        protected boolean linkDirty = true;

        public ZTreeLayoutManagerLink() {
            this.setLinkDirty(true);
        }

        protected void computeBounds() {
            if (this.visLink != null) {
                this.bounds = new ZBounds(this.visLink.getBounds());
            } else {
                this.bounds.setRect(0.0, 0.0, 0.0, 0.0);
            }
        }

        public boolean getLinkDirty() {
            return this.linkDirty;
        }

        public void setLinkDirty(boolean v) {
            this.linkDirty = v;
        }

        public Color getPenColor() {
            return this.penColor;
        }

        public void setPenColor(Color color) {
            this.penColor = color;
            this.setLinkDirty(true);
            this.repaint();
        }

        public Stroke getStroke() {
            return this.stroke;
        }

        public void setStroke(Stroke s) {
            if (s instanceof BasicStroke) {
                this.stroke = (BasicStroke)s;
                this.repaint();
            }
        }

        public double getPenWidth() {
            return this.penWidth;
        }

        public void setPenWidth(double w) {
            this.penWidth = w;
            this.repaint();
        }

        public void setAbsPenWidth(double w) {
        }

        public double getAbsPenWidth() {
            return 0.0;
        }

        public void render(ZRenderContext renderContext) {
            Graphics2D g2 = renderContext.getGraphics2D();
            double mag = renderContext.getCompositeMagnification();
            if (mag * (double)this.stroke.getLineWidth() != this.penWidth) {
                this.stroke = new BasicStroke((float)(this.penWidth / mag));
            }
            g2.setStroke(this.stroke);
            this.paint(g2);
        }

        public void paint(Graphics2D g2) {
            if (this.visLink != null) {
                g2.setColor(this.penColor);
                g2.draw(this.visLink);
            }
        }

        protected void updateLink() {
            if (!this.linkDirty) {
                return;
            }
            this.linkDirty = false;
            ZNode parent = (ZNode)this.parents.get(0);
            ZNode parentPrimary = null;
            ZTransformGroup parentTransform = null;
            ZNode[] children = null;
            ZSceneGraphEditor editor = parent.editor();
            parentPrimary = editor.getNode();
            parentTransform = editor.getTransformGroup();
            if (parentPrimary instanceof ZGroup) {
                children = ((ZGroup)parentPrimary).getChildren();
                if (children.length == 0) {
                    this.visLink = null;
                    this.reshape();
                    return;
                }
            } else {
                this.visLink = null;
                this.reshape();
                return;
            }
            ZBounds parentBounds = ZTreeLayoutManager.this.getFrontVisualComponentBounds(parentPrimary);
            if (parentBounds == null) {
                parentBounds = new ZBounds();
            }
            parentBounds.transform(parentTransform.getTransform());
            ZNode child = null;
            ZNode childPrimary = null;
            ZTransformGroup childTransform = null;
            ZBounds childBounds = null;
            if (children.length <= 0) {
                return;
            }
            this.visLink = new GeneralPath();
            switch (ZTreeLayoutManager.this.currentLinkStyle) {
                case 0: {
                    int i = 0;
                    while (i < children.length) {
                        child = children[i];
                        childPrimary = child.editor().getNode();
                        childTransform = childPrimary.editor().getTransformGroup();
                        childBounds = ZTreeLayoutManager.this.getFrontVisualComponentBounds(childPrimary);
                        childBounds.transform(childTransform.getTransform());
                        childBounds.transform(parentTransform.getTransform());
                        if (ZTreeLayoutManager.this.getCurrentOrientation() == 0) {
                            ((GeneralPath)this.visLink).moveTo((float)(parentBounds.getX() + parentBounds.getWidth() / 2.0), (float)(parentBounds.getY() + parentBounds.getHeight()));
                            ((GeneralPath)this.visLink).lineTo((float)(childBounds.getX() + childBounds.getWidth() / 2.0), (float)childBounds.getY());
                        } else {
                            ((GeneralPath)this.visLink).moveTo((float)(parentBounds.getX() + parentBounds.getWidth()), (float)(parentBounds.getY() + parentBounds.getHeight() / 2.0));
                            ((GeneralPath)this.visLink).lineTo((float)childBounds.getX(), (float)(childBounds.getY() + childBounds.getHeight() / 2.0));
                        }
                        ++i;
                    }
                    break;
                }
                case 1: {
                    double xMiddle;
                    double yMiddle;
                    Rectangle2D.Double firstBounds = null;
                    Rectangle2D.Double lastBounds = null;
                    boolean start = true;
                    ZNode first = null;
                    ZNode last = null;
                    int i = 0;
                    while (i < children.length) {
                        child = children[i];
                        childPrimary = child.editor().getNode();
                        childTransform = childPrimary.editor().getTransformGroup();
                        if (start) {
                            start = false;
                            first = child;
                        }
                        childBounds = ZTreeLayoutManager.this.getFrontVisualComponentBounds(childPrimary);
                        childBounds.transform(childTransform.getTransform());
                        childBounds.transform(parentTransform.getTransform());
                        yMiddle = parentBounds.getY() + parentBounds.getHeight() + (childBounds.getY() - (parentBounds.getY() + parentBounds.getHeight())) / 2.0;
                        xMiddle = parentBounds.getX() + parentBounds.getWidth() + (childBounds.getX() - (parentBounds.getX() + parentBounds.getWidth())) / 2.0;
                        if (first == child) {
                            firstBounds = childBounds;
                        }
                        if (first == child && ZTreeLayoutManager.this.getCurrentHeadStyle() == 2) {
                            if (ZTreeLayoutManager.this.getCurrentOrientation() == 0) {
                                ((GeneralPath)this.visLink).moveTo((float)(parentBounds.getX() + parentBounds.getWidth() / 2.0), (float)yMiddle);
                                ((GeneralPath)this.visLink).lineTo((float)(parentBounds.getX() + parentBounds.getWidth() / 2.0), (float)(parentBounds.getY() + parentBounds.getHeight()));
                                ((GeneralPath)this.visLink).moveTo((float)(childBounds.getX() + childBounds.getWidth() / 2.0), (float)yMiddle);
                                ((GeneralPath)this.visLink).lineTo((float)(parentBounds.getX() + parentBounds.getWidth() / 2.0), (float)yMiddle);
                                ((GeneralPath)this.visLink).moveTo((float)(childBounds.getX() + childBounds.getWidth() / 2.0), (float)childBounds.getY());
                                ((GeneralPath)this.visLink).lineTo((float)(childBounds.getX() + childBounds.getWidth() / 2.0), (float)yMiddle);
                            } else {
                                ((GeneralPath)this.visLink).moveTo((float)xMiddle, (float)(parentBounds.getY() + parentBounds.getHeight() / 2.0));
                                ((GeneralPath)this.visLink).lineTo((float)(parentBounds.getX() + parentBounds.getWidth()), (float)(parentBounds.getY() + parentBounds.getHeight() / 2.0));
                                ((GeneralPath)this.visLink).moveTo((float)xMiddle, (float)(childBounds.getY() + childBounds.getHeight() / 2.0));
                                ((GeneralPath)this.visLink).lineTo((float)xMiddle, (float)(parentBounds.getY() + parentBounds.getHeight() / 2.0));
                                ((GeneralPath)this.visLink).moveTo((float)childBounds.getX(), (float)(childBounds.getY() + childBounds.getHeight() / 2.0));
                                ((GeneralPath)this.visLink).lineTo((float)xMiddle, (float)(childBounds.getY() + childBounds.getHeight() / 2.0));
                            }
                        } else if (ZTreeLayoutManager.this.getCurrentOrientation() == 0) {
                            ((GeneralPath)this.visLink).moveTo((float)(childBounds.getX() + childBounds.getWidth() / 2.0), (float)childBounds.getY());
                            ((GeneralPath)this.visLink).lineTo((float)(childBounds.getX() + childBounds.getWidth() / 2.0), (float)yMiddle);
                        } else {
                            ((GeneralPath)this.visLink).moveTo((float)childBounds.getX(), (float)(childBounds.getY() + childBounds.getHeight() / 2.0));
                            ((GeneralPath)this.visLink).lineTo((float)xMiddle, (float)(childBounds.getY() + childBounds.getHeight() / 2.0));
                        }
                        last = child;
                        lastBounds = childBounds;
                        ++i;
                    }
                    yMiddle = parentBounds.getY() + parentBounds.getHeight() + (firstBounds.getY() - (parentBounds.getY() + parentBounds.getHeight())) / 2.0;
                    xMiddle = parentBounds.getX() + parentBounds.getWidth() + (firstBounds.getX() - (parentBounds.getX() + parentBounds.getWidth())) / 2.0;
                    if (ZTreeLayoutManager.this.getCurrentHeadStyle() != 2) {
                        if (ZTreeLayoutManager.this.getCurrentOrientation() == 0) {
                            ((GeneralPath)this.visLink).moveTo((float)(parentBounds.getX() + parentBounds.getWidth() / 2.0), (float)(parentBounds.getY() + parentBounds.getHeight()));
                            ((GeneralPath)this.visLink).lineTo((float)(parentBounds.getX() + parentBounds.getWidth() / 2.0), (float)yMiddle);
                        } else {
                            ((GeneralPath)this.visLink).moveTo((float)(parentBounds.getX() + parentBounds.getWidth()), (float)(parentBounds.getY() + parentBounds.getHeight() / 2.0));
                            ((GeneralPath)this.visLink).lineTo((float)xMiddle, (float)(parentBounds.getY() + parentBounds.getHeight() / 2.0));
                        }
                    }
                    if (first == last) break;
                    if (ZTreeLayoutManager.this.getCurrentHeadStyle() == 2) {
                        if (ZTreeLayoutManager.this.getCurrentOrientation() == 0) {
                            ((GeneralPath)this.visLink).moveTo((float)(lastBounds.getX() + lastBounds.getWidth() / 2.0), (float)yMiddle);
                            ((GeneralPath)this.visLink).lineTo((float)(firstBounds.getX() + firstBounds.getWidth() / 2.0), (float)yMiddle);
                            break;
                        }
                        ((GeneralPath)this.visLink).moveTo((float)xMiddle, (float)(lastBounds.getY() + lastBounds.getHeight() / 2.0));
                        ((GeneralPath)this.visLink).lineTo((float)xMiddle, (float)(firstBounds.getY() + firstBounds.getHeight() / 2.0));
                        break;
                    }
                    if (ZTreeLayoutManager.this.getCurrentOrientation() == 0) {
                        ((GeneralPath)this.visLink).moveTo((float)(lastBounds.getX() + lastBounds.getWidth() / 2.0), (float)yMiddle);
                        ((GeneralPath)this.visLink).lineTo((float)(firstBounds.getX() + firstBounds.getWidth() / 2.0), (float)yMiddle);
                        break;
                    }
                    ((GeneralPath)this.visLink).moveTo((float)xMiddle, (float)(lastBounds.getY() + lastBounds.getHeight() / 2.0));
                    ((GeneralPath)this.visLink).lineTo((float)xMiddle, (float)(firstBounds.getY() + firstBounds.getHeight() / 2.0));
                }
            }
            this.reshape();
        }
    }
}

